/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.Property;

public abstract class PropertyContainer
extends PathElement {
    public PropertyContainer(PropertyContainer parent, String label, PathElement.PathElementKind kind) {
        super(parent, label, kind);
    }

    @Override
    public PathElement.PathElementKind getKind() {
        PathElement.PathElementKind currentKind = super.getKind();
        if (currentKind != PathElement.PathElementKind.UNKNOWN) {
            return currentKind;
        }
        PathElement.PathElementKind kind = this.getChildrenKind();
        this.setKind(kind);
        return kind;
    }

    private PathElement.PathElementKind getChildrenKind() {
        PathElement.PathElementKind childrenKind = PathElement.PathElementKind.IN_SERVER;
        for (PathElement pathElement : this.getChildren()) {
            PathElement.PathElementKind childKind = pathElement.getKind();
            if (childKind == PathElement.PathElementKind.IN_CONFIGURATION) {
                return childKind;
            }
            if (childrenKind == childKind) continue;
            childrenKind = PathElement.PathElementKind.IN_BOTH;
        }
        return childrenKind;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public abstract Collection<? extends PathElement> getChildren();

    public static class EventNode
    extends PropertyContainer
    implements IDescribable {
        private final IEventTypeID eventTypeID;
        private final Map<String, Property> m_options = new LinkedHashMap<String, Property>();
        private final String description;

        public EventNode(PropertyContainer parent, String label, String description, IEventTypeID eventTypeID, PathElement.PathElementKind kind) {
            super(parent, label, kind);
            this.description = description;
            this.eventTypeID = eventTypeID;
        }

        public List<Property> getChildren() {
            return new ArrayList<Property>(this.m_options.values());
        }

        public void addToOption(EventOptionID optionID, String label, String description, PathElement.PathElementKind kind, String value, IConstraint<?> constraint) {
            String optionKey = optionID.getOptionKey();
            Property option = this.m_options.get(optionKey);
            if (option != null) {
                option.addKind(kind);
                return;
            }
            option = new Property(this, optionID, label, description, kind, value, constraint);
            this.m_options.put(optionKey, option);
        }

        public IEventTypeID getEventTypeID() {
            return this.eventTypeID;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class FolderNode
    extends PropertyContainer {
        private final List<PropertyContainer> m_containers = new ArrayList<PropertyContainer>();

        public FolderNode(PropertyContainer parent, String label, PathElement.PathElementKind kind) {
            super(parent, label, kind);
        }

        public List<? extends PathElement> getChildren() {
            return this.m_containers;
        }

        public FolderNode getFolder(String label, PathElement.PathElementKind kind) {
            for (PropertyContainer container : this.m_containers) {
                FolderNode folder;
                if (!(container instanceof FolderNode) || !(folder = (FolderNode)container).getName().equals(label)) continue;
                folder.addKind(kind);
                return folder;
            }
            return null;
        }

        public FolderNode createOrGetFolder(String label, PathElement.PathElementKind kind) {
            FolderNode folder = this.getFolder(label, kind);
            if (folder == null) {
                folder = new FolderNode(this, label, kind);
                this.add(folder);
            }
            return folder;
        }

        public EventNode getEvent(IEventTypeID eventTypeID, PathElement.PathElementKind kind) {
            for (PropertyContainer container : this.m_containers) {
                if (!(container instanceof EventNode) || !eventTypeID.equals(((EventNode)container).eventTypeID)) continue;
                container.addKind(kind);
                return (EventNode)container;
            }
            return null;
        }

        public EventNode createOrGetEvent(IEventTypeID eventTypeID, PathElement.PathElementKind kind, String eventLabel, String eventDescription) {
            EventNode p = this.getEvent(eventTypeID, kind);
            if (p == null) {
                p = new EventNode(this, eventLabel, eventDescription, eventTypeID, kind);
                this.add(p);
            }
            return p;
        }

        private void add(PropertyContainer container) {
            this.m_containers.add(container);
        }
    }
}

