/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.version.JavaVMVersionToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class ZingLiveObjectsPage
extends AbstractDataPage {
    private static final Color COMPILATIONS_COLOR = TypeLabelProvider.getColor("jdk.Compilation");
    private static final ItemList.ItemListBuilder COMPILATIONS_LIST = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder GC_LIST = new ItemList.ItemListBuilder();
    private static final String SASH = "sash";
    private static final String TABLE_SASH = "table_sash";
    private static final String LIVE_OBJECTS_GC_TABLE_NAME = "liveObjectsGCTable";
    private static final String LIVE_OBJECTS_REFERANT_TABLE_NAME = "liveObjectsReferantTable";
    private static final String LIVE_OBJECTS_REFERRER_TABLE_NAME = "liveObjectsReferrerTable";
    private static final IItemFilter TABLE_FILTER;
    private ColumnManager.SelectionState gcPageSelectionState;
    private ColumnManager.SelectionState referantPageSelectionState;
    private ColumnManager.SelectionState referrerPageSelectionState;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        GC_LIST.addColumn(JdkAttributes.ZING_LIVE_GC_ID);
        COMPILATIONS_LIST.addColumn(JdkAttributes.ZING_LIVE_REFERRER);
        COMPILATIONS_LIST.addColumn(JdkAttributes.ZING_LIVE_REFERANT);
        COMPILATIONS_LIST.addColumn(JdkAttributes.ZING_LIVE_GC_ID);
        COMPILATIONS_LIST.addColumn(JdkAttributes.ZING_LIVE_SIZE);
        TABLE_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.ZING_LIVE_OBJECTS_FILTER, JdkFilters.OLD_GARBAGE_COLLECTION});
    }

    private static void logDuplicateGcId(GcPageRow duplicateGC) {
        if (duplicateGC != null) {
            IQuantity gcID = (IQuantity)JdkAttributes.GC_ID.getAccessor(ItemToolkit.getItemType((IItem)duplicateGC.gcItem)).getMember((Object)duplicateGC.gcItem);
            FlightRecorderUI.getDefault().getLogger().severe("GC with id " + String.valueOf(gcID) + " is duplicated");
        }
    }

    private static IColumn buildAttributeColumn(IAttribute<?> a, IMemberAccessor<?, Object> cellAccessor) {
        int style = a.getContentType() instanceof LinearKindOfQuantity ? 131072 : 0;
        return new ColumnBuilder(a.getName(), a.getIdentifier(), cellAccessor).description(a.getDescription()).style(style).build();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        String jvmName = (String)this.getDataSource().getItems().getAggregate(JdkAggregators.JVM_NAME);
        boolean isZing = JavaVMVersionToolkit.isZingJVMName((String)jvmName);
        return isZing ? new LiveObjectPageUi(parent, toolkit, pageContainer, state) : null;
    }

    public ZingLiveObjectsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_FILTER;
    }

    private static class GcPageRow {
        final IType<IItem> type;
        final IItem gcItem;
        IQuantity gcId;
        String gcName;
        IQuantity totalBytesReported;
        IQuantity referantBytes;
        IQuantity referantCount;

        GcPageRow(IItem gcItem, IType<IItem> type) {
            this.type = type;
            this.gcItem = gcItem;
            this.totalBytesReported = UnitLookup.BYTE.quantity(0L);
            this.referantBytes = UnitLookup.BYTE.quantity(0L);
            this.referantCount = UnitLookup.NUMBER_UNITY.quantity(0L);
        }

        void accountGcItem(IQuantity gcId, String gcName) {
            this.gcId = gcId;
            this.gcName = gcName;
        }

        void accountZingItem(IQuantity totalBytesReported, IQuantity referantBytes, IQuantity referantCount) {
            this.totalBytesReported = totalBytesReported;
            this.referantBytes = this.referantBytes.add(referantBytes);
            this.referantCount = this.referantCount.add(referantCount);
        }
    }

    private class LiveObjectPageUi
    implements IPageUI {
        private final SashForm sash;
        private final SashForm tableSash;
        private IItemCollection selectedItems;
        private final FlavorSelector flavorSelector;
        private final ColumnManager gcPageCM;
        private final ColumnManager referantPageCM;
        private final ColumnManager referrerPageCM;

        LiveObjectPageUi(Composite container, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(container, toolkit, ZingLiveObjectsPage.this.getName(), ZingLiveObjectsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.tableSash = new SashForm((Composite)this.sash, 256);
            toolkit.adapt((Composite)this.tableSash);
            TableViewer tableViewer = new TableViewer((Composite)this.tableSash, 268503810);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            ArrayList<IColumn> columns = new ArrayList<IColumn>();
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.GC_ID, o -> ((GcPageRow)o).gcId));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.GC_NAME, o -> ((GcPageRow)o).gcName));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_TOTAL_BYTES_REPORTED, o -> ((GcPageRow)o).totalBytesReported));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_LIVE_SIZE, o -> ((GcPageRow)o).referantBytes));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_REFERANT_COUNT, o -> ((GcPageRow)o).referantCount));
            this.gcPageCM = ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)TableSettings.forState((IState)state.getChild(ZingLiveObjectsPage.LIVE_OBJECTS_GC_TABLE_NAME)));
            MCContextMenuManager itemListMm = MCContextMenuManager.create((Control)this.gcPageCM.getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.gcPageCM, (MCContextMenuManager)itemListMm);
            this.gcPageCM.getViewer().addSelectionChangedListener(e -> {
                pageContainer.showSelection(ItemCollectionToolkit.build(this.gcSelectedGcItems()));
                this.updateReferantsList();
            });
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.gcPageCM.getViewer(), pageContainer.getSelectionStore(), () -> ItemCollectionToolkit.build(this.gcSelectedGcItems()), Messages.GarbageCollectionsPage_LIST_SELECTION, (IContributionManager)itemListMm);
            tableViewer = new TableViewer((Composite)this.tableSash, 268503810);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            columns = new ArrayList();
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.GC_ID, o -> ((ReferantPageRow)o).gcId));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_LIVE_REFERANT, o -> ((ReferantPageRow)o).referant));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_LIVE_SIZE, o -> ((ReferantPageRow)o).referantBytes));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_REFERANT_COUNT, o -> ((ReferantPageRow)o).referantCount));
            this.referantPageCM = ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)TableSettings.forState((IState)state.getChild(ZingLiveObjectsPage.LIVE_OBJECTS_REFERANT_TABLE_NAME)));
            itemListMm = MCContextMenuManager.create((Control)this.referantPageCM.getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.referantPageCM, (MCContextMenuManager)itemListMm);
            this.referantPageCM.getViewer().addSelectionChangedListener(e -> this.updateReferrerList());
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.referantPageCM.getViewer(), pageContainer.getSelectionStore(), () -> ItemCollectionToolkit.build(this.gcSelectedGcItems()), Messages.GarbageCollectionsPage_LIST_SELECTION, (IContributionManager)itemListMm);
            tableViewer = new TableViewer((Composite)this.sash, 268503810);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            columns = new ArrayList();
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.GC_ID, o -> ((ReferrerPageRow)o).gcId));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_LIVE_REFERRER, o -> ((ReferrerPageRow)o).referrer));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_LIVE_REFERANT, o -> ((ReferrerPageRow)o).referant));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_LIVE_SIZE, o -> ((ReferrerPageRow)o).referantBytes));
            columns.add(ZingLiveObjectsPage.buildAttributeColumn(JdkAttributes.ZING_REFERANT_COUNT, o -> ((ReferrerPageRow)o).referantCount));
            this.referrerPageCM = ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)TableSettings.forState((IState)state.getChild(ZingLiveObjectsPage.LIVE_OBJECTS_REFERRER_TABLE_NAME)));
            itemListMm = MCContextMenuManager.create((Control)this.referrerPageCM.getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.referrerPageCM, (MCContextMenuManager)itemListMm);
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.referrerPageCM.getViewer(), pageContainer.getSelectionStore(), () -> ItemCollectionToolkit.build(this.gcSelectedGcItems()), Messages.GarbageCollectionsPage_LIST_SELECTION, (IContributionManager)itemListMm);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(ZingLiveObjectsPage.SASH));
            PersistableSashForm.loadState((SashForm)this.tableSash, (IState)state.getChild(ZingLiveObjectsPage.TABLE_SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_FILTER, ZingLiveObjectsPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, ZingLiveObjectsPage.this.flavorSelectorState);
            ZingLiveObjectsPage.this.addResultActions(form);
            this.gcPageCM.setSelectionState(ZingLiveObjectsPage.this.gcPageSelectionState);
            this.referrerPageCM.setSelectionState(ZingLiveObjectsPage.this.referantPageSelectionState);
            this.referrerPageCM.setSelectionState(ZingLiveObjectsPage.this.referrerPageSelectionState);
        }

        private IItemCollection getSelectedItems() {
            return this.selectedItems != null ? this.selectedItems : ZingLiveObjectsPage.this.getDataSource().getItems();
        }

        public void saveTo(IWritableState memento) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(ZingLiveObjectsPage.SASH));
            PersistableSashForm.saveState((SashForm)this.tableSash, (IWritableState)memento.createChild(ZingLiveObjectsPage.TABLE_SASH));
            this.gcPageCM.getSettings().saveState(memento.createChild(ZingLiveObjectsPage.LIVE_OBJECTS_GC_TABLE_NAME));
            this.referantPageCM.getSettings().saveState(memento.createChild(ZingLiveObjectsPage.LIVE_OBJECTS_REFERANT_TABLE_NAME));
            this.referrerPageCM.getSettings().saveState(memento.createChild(ZingLiveObjectsPage.LIVE_OBJECTS_REFERRER_TABLE_NAME));
            this.saveToLocal();
        }

        private void saveToLocal() {
            ZingLiveObjectsPage.this.gcPageSelectionState = this.gcPageCM.getSelectionState();
            ZingLiveObjectsPage.this.referantPageSelectionState = this.referantPageCM.getSelectionState();
            ZingLiveObjectsPage.this.referrerPageSelectionState = this.referrerPageCM.getSelectionState();
            ZingLiveObjectsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectedItems = items != null ? items : ZingLiveObjectsPage.this.getDataSource().getItems();
            this.updateTable();
        }

        private Set<IQuantity> getSelectedGcIds() {
            List selected = ((IStructuredSelection)this.gcPageCM.getViewer().getSelection()).toList();
            Set<IQuantity> gcIds = selected.stream().map(gc -> (IQuantity)gc.type.getAccessor(JdkAttributes.GC_ID.getKey()).getMember((Object)gc.gcItem)).collect(Collectors.toSet());
            return gcIds;
        }

        private IItemCollection getReferantItems() {
            Set<IQuantity> gcIds = this.getSelectedGcIds();
            IItemCollection gcIdZingLiveObjects = ZingLiveObjectsPage.this.getDataSource().getItems().apply(JdkFilters.ZING_LIVE_OBJECTS_FILTER).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, gcIds));
            return gcIdZingLiveObjects;
        }

        private Set<IMCType> getSelectedReferants() {
            List selected = ((IStructuredSelection)this.referantPageCM.getViewer().getSelection()).toList();
            Set<IMCType> refIds = selected.stream().map(ref -> (IMCType)ref.type.getAccessor(JdkAttributes.ZING_LIVE_REFERANT.getKey()).getMember((Object)ref.zingItem)).collect(Collectors.toSet());
            return refIds;
        }

        private IItemCollection getReferrerItems() {
            Set<IQuantity> gcIds = this.getSelectedGcIds();
            Set<IMCType> refIds = this.getSelectedReferants();
            IItemCollection referrers = ZingLiveObjectsPage.this.getDataSource().getItems().apply(JdkFilters.ZING_LIVE_OBJECTS_FILTER).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, gcIds)).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.ZING_LIVE_REFERANT, refIds));
            return referrers;
        }

        private Stream<? extends IItem> gcSelectedGcItems() {
            List sel = ((IStructuredSelection)this.gcPageCM.getViewer().getSelection()).toList();
            return sel.stream().map(gc -> gc.gcItem);
        }

        Set<IQuantity> getAllOldGcIds() {
            TreeSet<IQuantity> oldGcIds = new TreeSet<IQuantity>();
            IItemCollection oldGcItems = ZingLiveObjectsPage.this.getDataSource().getItems().apply(JdkFilters.OLD_GARBAGE_COLLECTION);
            oldGcItems.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                is.forEach(item -> oldGcIds.add((IQuantity)gcIdAccessor.getMember(item)));
            });
            return oldGcIds;
        }

        Map<Object, GcPageRow> buildGCMap(Set<IQuantity> oldGcIds) {
            IItemCollection gcs = this.getSelectedItems().apply(JdkFilters.GARBAGE_COLLECTION);
            TreeMap<Object, GcPageRow> gcMap = new TreeMap<Object, GcPageRow>();
            gcs.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor nameAccessor = JdkAttributes.GC_NAME.getAccessor(is.getType());
                is.forEach(item -> {
                    IQuantity gcId = (IQuantity)gcIdAccessor.getMember(item);
                    if (oldGcIds.contains(gcId)) {
                        GcPageRow row = new GcPageRow((IItem)item, (IType<IItem>)is.getType());
                        row.accountGcItem(gcId, (String)nameAccessor.getMember(item));
                        ZingLiveObjectsPage.logDuplicateGcId(gcMap.put(gcId, row));
                    }
                });
            });
            IItemCollection oldGcItems = ZingLiveObjectsPage.this.getDataSource().getItems().apply(JdkFilters.ZING_LIVE_OBJECTS_FILTER);
            oldGcItems.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.ZING_LIVE_GC_ID.getAccessor(is.getType());
                IMemberAccessor totalBytesReportedAccessor = JdkAttributes.ZING_TOTAL_BYTES_REPORTED.getAccessor(is.getType());
                IMemberAccessor referantBytesAccessor = JdkAttributes.ZING_LIVE_SIZE.getAccessor(is.getType());
                IMemberAccessor referantCountAccessor = JdkAttributes.ZING_REFERANT_COUNT.getAccessor(is.getType());
                is.forEach(item -> {
                    GcPageRow row = (GcPageRow)gcMap.get(gcIdAccessor.getMember(item));
                    if (row != null) {
                        row.accountZingItem((IQuantity)totalBytesReportedAccessor.getMember(item), (IQuantity)referantBytesAccessor.getMember(item), (IQuantity)referantCountAccessor.getMember(item));
                    }
                });
            });
            return gcMap;
        }

        Map<String, ReferantPageRow> buildReferantsMap() {
            TreeMap<String, ReferantPageRow> referantMap = new TreeMap<String, ReferantPageRow>();
            IItemCollection referants = this.getReferantItems();
            referants.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.ZING_LIVE_GC_ID.getAccessor(is.getType());
                IMemberAccessor accessReferant = JdkAttributes.ZING_LIVE_REFERANT.getAccessor(is.getType());
                IMemberAccessor referantBytesAccessor = JdkAttributes.ZING_LIVE_SIZE.getAccessor(is.getType());
                IMemberAccessor referantCountAccessor = JdkAttributes.ZING_REFERANT_COUNT.getAccessor(is.getType());
                is.forEach(item -> {
                    String name;
                    ReferantPageRow row;
                    IMCType referant = (IMCType)accessReferant.getMember(item);
                    if (referant == null) {
                        referant = NullClassRepresentator.instance;
                    }
                    if ((row = (ReferantPageRow)referantMap.get(name = referant.getFullName())) == null) {
                        row = new ReferantPageRow((IItem)item, (IType<IItem>)is.getType(), referant);
                        referantMap.put(name, row);
                    }
                    row.accountItem((IQuantity)gcIdAccessor.getMember(item), (IQuantity)referantBytesAccessor.getMember(item), (IQuantity)referantCountAccessor.getMember(item));
                });
            });
            return referantMap;
        }

        Map<String, ReferrerPageRow> buildReferrersMap() {
            TreeMap<String, ReferrerPageRow> referrerMap = new TreeMap<String, ReferrerPageRow>();
            IItemCollection referants = this.getReferrerItems();
            referants.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.ZING_LIVE_GC_ID.getAccessor(is.getType());
                IMemberAccessor accessReferrer = JdkAttributes.ZING_LIVE_REFERRER.getAccessor(is.getType());
                IMemberAccessor accessReferant = JdkAttributes.ZING_LIVE_REFERANT.getAccessor(is.getType());
                IMemberAccessor referantBytesAccessor = JdkAttributes.ZING_LIVE_SIZE.getAccessor(is.getType());
                IMemberAccessor referantCountAccessor = JdkAttributes.ZING_REFERANT_COUNT.getAccessor(is.getType());
                is.forEach(item -> {
                    String name;
                    ReferrerPageRow row;
                    IMCType referant = (IMCType)accessReferant.getMember(item);
                    IMCType referrer = (IMCType)accessReferrer.getMember(item);
                    if (referant == null) {
                        referant = NullClassRepresentator.instance;
                    }
                    if (referrer == null) {
                        referrer = NullClassRepresentator.instance;
                    }
                    if ((row = (ReferrerPageRow)referrerMap.get(name = referrer.getFullName() + " " + referant.getFullName())) == null) {
                        row = new ReferrerPageRow(referrer, (IMCType)accessReferant.getMember(item));
                        referrerMap.put(name, row);
                    }
                    row.accountItem((IQuantity)gcIdAccessor.getMember(item), (IQuantity)referantBytesAccessor.getMember(item), (IQuantity)referantCountAccessor.getMember(item));
                });
            });
            return referrerMap;
        }

        private void updateTable() {
            Set<IQuantity> oldGcIds = this.getAllOldGcIds();
            Map<Object, GcPageRow> gcMap = this.buildGCMap(oldGcIds);
            Map<String, ReferantPageRow> referantMap = this.buildReferantsMap();
            Map<String, ReferrerPageRow> referrerMap = this.buildReferrersMap();
            this.gcPageCM.getViewer().setInput((Object)gcMap.values().toArray());
            this.referantPageCM.getViewer().setInput((Object)referantMap.values().toArray());
            this.referrerPageCM.getViewer().setInput((Object)referrerMap.values().toArray());
        }

        void updateReferantsList() {
            Map<String, ReferantPageRow> referantMap = this.buildReferantsMap();
            this.referantPageCM.getViewer().setInput((Object)referantMap.values().toArray());
        }

        void updateReferrerList() {
            Map<String, ReferrerPageRow> referrerMap = this.buildReferrersMap();
            this.referrerPageCM.getViewer().setInput((Object)referrerMap.values().toArray());
        }
    }

    private static class NullClassRepresentator
    implements IMCType {
        static NullClassRepresentator instance = new NullClassRepresentator();

        private NullClassRepresentator() {
        }

        public String getTypeName() {
            return "unknown";
        }

        public IMCPackage getPackage() {
            return null;
        }

        public String getFullName() {
            return "unknown";
        }
    }

    private static class ReferantPageRow {
        final IType<IItem> type;
        final IItem zingItem;
        IQuantity gcId;
        IMCType referant;
        IQuantity referantBytes;
        IQuantity referantCount;

        ReferantPageRow(IItem gcItem, IType<IItem> type, IMCType referant) {
            this.type = type;
            this.zingItem = gcItem;
            this.referant = referant;
            this.referantBytes = UnitLookup.BYTE.quantity(0L);
            this.referantCount = UnitLookup.NUMBER_UNITY.quantity(0L);
            this.gcId = UnitLookup.NUMBER_UNITY.quantity(0L);
        }

        void accountItem(IQuantity gcId, IQuantity referantBytes, IQuantity referantCount) {
            this.gcId = this.gcId.compareTo((Object)gcId) < 0 ? gcId : this.gcId;
            this.referantBytes = this.referantBytes.add(referantBytes);
            this.referantCount = this.referantCount.add(referantCount);
        }
    }

    private static class ReferrerPageRow {
        IQuantity gcId;
        IMCType referrer;
        IMCType referant;
        IQuantity referantBytes;
        IQuantity referantCount;

        ReferrerPageRow(IMCType referrer, IMCType referant) {
            this.referrer = referrer;
            this.referant = referant;
            this.referantBytes = UnitLookup.BYTE.quantity(0L);
            this.referantCount = UnitLookup.NUMBER_UNITY.quantity(0L);
            this.gcId = UnitLookup.NUMBER_UNITY.quantity(0L);
        }

        void accountItem(IQuantity gcId, IQuantity referantBytes, IQuantity referantCount) {
            this.gcId = this.gcId.compareTo((Object)gcId) < 0 ? gcId : this.gcId;
            this.referantBytes = this.referantBytes.add(referantBytes);
            this.referantCount = this.referantCount.add(referantCount);
        }
    }

    public static class ZingLiveObjectsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.MemoryZingLiveObjectsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/objectstatistics.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"zingmemoryleak"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ZingLiveObjectsPage(dpd, items, editor);
        }
    }
}

