/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.celleditors;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.RangeContentType;
import org.openjdk.jmc.ui.celleditors.Messages;
import org.openjdk.jmc.ui.misc.ControlDecorationToolkit;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

public class CommonCellEditors {
    public static CellEditor create(Composite parent, IPersister<?> persister) {
        return new PersisterCellEditor(parent, persister);
    }

    public static CellEditor create(Composite parent, KindOfQuantity<?> kind) {
        return new QuantityCellEditor(parent, kind);
    }

    public static CellEditor create(Composite parent, RangeContentType<?> rangeType) {
        return null;
    }

    public static class MultiLineTextCellEditor
    extends TextCellEditor {
        private final ControlDecoration infoDecorator;

        public MultiLineTextCellEditor(Composite parent) {
            super(parent, 514);
            this.infoDecorator = ControlDecorationToolkit.createInfoDecorator((Control)this.text);
        }

        public void activate() {
            super.activate();
            String info = this.getInfoText();
            if (info != null) {
                this.infoDecorator.setDescriptionText(info);
                this.infoDecorator.show();
            } else {
                this.infoDecorator.hide();
            }
        }

        public String getInfoText() {
            return Messages.MultiLineTextCellEditor_SHIFT_RETURN;
        }

        protected void keyReleaseOccured(KeyEvent keyEvent) {
            if (keyEvent.character == '\u001b') {
                this.fireCancelEditor();
            } else if (keyEvent.character == '\r' && (keyEvent.stateMask & 0x20000) == 0) {
                this.fireApplyEditorValue();
                this.deactivate();
            }
        }
    }

    private static class PersisterCellEditor
    extends MultiLineTextCellEditor {
        private final ControlDecoration errorDecorator;
        private final IPersister<?> persister;
        private Object value;

        PersisterCellEditor(Composite parent, IPersister<?> persister) {
            super(parent);
            this.persister = persister;
            this.errorDecorator = ControlDecorationToolkit.createErrorDecorator((Control)this.text);
        }

        @Override
        public void activate() {
            super.activate();
            this.errorDecorator.hide();
        }

        protected void editOccured(ModifyEvent e) {
            try {
                String str = this.text.getText();
                this.value = this.persister.parseInteractive(str);
                this.setValueValid(true);
                this.errorDecorator.hide();
            }
            catch (QuantityConversionException ex) {
                this.errorDecorator.setDescriptionText(ex.getLocalizedMessage());
                this.errorDecorator.show();
                this.setValueValid(false);
            }
        }

        protected void doSetValue(Object value) {
            this.value = value;
            super.doSetValue((Object)this.persister.interactiveFormat(value != null ? value : ""));
        }

        protected Object doGetValue() {
            return this.value;
        }
    }

    private static class QuantityCellEditor
    extends PersisterCellEditor {
        private QuantityKindProposal proposal;

        private QuantityCellEditor(Composite parent, KindOfQuantity<?> kind) {
            super(parent, kind.getPersister());
            this.proposal = QuantityKindProposal.install((Text)this.text, kind);
        }

        protected void focusLost() {
            if (!this.proposal.isPopupOpen()) {
                super.focusLost();
            }
        }

        protected boolean dependsOnExternalFocusListener() {
            return false;
        }
    }
}

