/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.tab;

import jakarta.inject.Inject;
import javax.management.MBeanServerConnection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.openjdk.jmc.console.ui.editor.IConsolePageContainer;
import org.openjdk.jmc.console.ui.editor.IConsolePageStateHandler;
import org.openjdk.jmc.console.ui.editor.internal.ConsoleEditor;
import org.openjdk.jmc.console.ui.mbeanbrowser.tab.FeatureSectionPart;
import org.openjdk.jmc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.ui.internal.SectionPartManager;
import org.openjdk.jmc.ui.OrientationAction;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;

public class MBeanTab
implements IConsolePageStateHandler {
    private SashForm sashForm;
    private FeatureSectionPart detailsPart;
    private static final String VERTICAL_SASH_ID = "verticalSash";

    @Inject
    protected void createPageContent(IConsolePageContainer page, IManagedForm managedForm, IConnectionHandle ch) {
        IMemento state = page.loadConfig();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        boolean vertical = Boolean.TRUE.equals(state.getBoolean(VERTICAL_SASH_ID));
        this.sashForm = new SashForm(form.getBody(), vertical ? 512 : 256);
        toolkit.adapt((Control)this.sashForm, false, false);
        MBeanServerConnection mbeanServer = (MBeanServerConnection)ch.getServiceOrDummy(MBeanServerConnection.class);
        String guid = ch.getServerDescriptor().getGUID();
        IMBeanHelperService mbeanService = (IMBeanHelperService)ch.getServiceOrDummy(IMBeanHelperService.class);
        MBeanTreeSectionPart tree = new MBeanTreeSectionPart((Composite)this.sashForm, toolkit, mbeanServer, guid, mbeanService);
        managedForm.addPart((IFormPart)tree);
        this.detailsPart = new FeatureSectionPart((Composite)this.sashForm, toolkit, state, ch, (SectionPartManager)((ConsoleEditor)page.getEditor()).getSectionPartManagers().get(0));
        managedForm.addPart((IFormPart)this.detailsPart);
        tree.addMBeanListener(this.detailsPart);
        tree.selectDefaultBean();
        this.sashForm.setWeights(new int[]{7, 20});
        form.getBody().setLayout(MCLayoutFactory.createFormPageLayout());
        this.sashForm.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        OrientationAction.installActions((IManagedForm)managedForm, (SashForm)this.sashForm);
    }

    public boolean saveState(IMemento state) {
        state.putBoolean(VERTICAL_SASH_ID, this.sashForm.getOrientation() == 512);
        this.detailsPart.saveState(state);
        return true;
    }

    public void dispose() {
    }
}

