/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.action;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;
import org.openjdk.jmc.alert.AlertObject;
import org.openjdk.jmc.alert.AlertPlugin;
import org.openjdk.jmc.alert.NotificationUIToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.console.ui.notification.action.Messages;
import org.openjdk.jmc.flightrecorder.configuration.FlightRecorderException;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.services.jfr.FlightRecorderToolkit;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;
import org.openjdk.jmc.ui.MCPathEditorInput;
import org.openjdk.jmc.ui.WorkbenchToolkit;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;

public class WriteAndOpenRecordingJob
extends Job {
    private final String serverName;
    private final IFlightRecorderService service;
    private final MCFile path;
    private final IQuantity timerange;
    private final boolean open;
    private TriggerEvent event;

    public WriteAndOpenRecordingJob(String jobName, String serverName, IFlightRecorderService service, MCFile path, IQuantity timerange, boolean open, TriggerEvent event) {
        super(jobName);
        this.service = service;
        this.serverName = serverName;
        this.path = path;
        this.timerange = timerange;
        this.open = open;
        this.event = event;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String recordingName;
        String triggerMessage = NotificationToolkit.prettyPrint((TriggerEvent)this.event);
        try {
            IRecordingDescriptor descriptor = this.findRecording();
            if (descriptor == null) {
                RJMXPlugin.getDefault().getLogger().severe("There is no usable recording running at " + this.serverName);
                return new Status(4, "org.openjdk.jmc.console.ui.notification", Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_COULD_NOT_FIND_RECORDING);
            }
            recordingName = descriptor.getName();
            File writtenFile = this.writeFile(monitor, descriptor, this.timerange);
            if (this.open) {
                WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(writtenFile, false));
            } else {
                this.showAlert(writtenFile, this.event);
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not dump recording. Faulty rule in console?", e);
            return new Status(4, "org.openjdk.jmc.console.ui.notification", NLS.bind((String)("\n" + triggerMessage + "\n" + Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_DUMPING_RECORDING), (Object)this.serverName), (Throwable)e);
        }
        return new Status(0, "org.openjdk.jmc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)recordingName));
    }

    private void showAlert(File file, TriggerEvent event) {
        String serverName = event.getSource().getServerDescriptor().getDisplayName();
        String message = NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_DUMP_SUCCESSFUL_PATH, (Object)file.getAbsolutePath()));
        AlertObject ao = new AlertObject(event.getCreationTime(), serverName, event.getRule(), message, null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    private IRecordingDescriptor findRecording() throws FlightRecorderException {
        return FlightRecorderToolkit.getDescriptorByTimerange((List)this.service.getAvailableRecordings(), (IQuantity)this.timerange);
    }

    private File writeFile(IProgressMonitor monitor, IRecordingDescriptor descriptor, IQuantity duration) throws FlightRecorderException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = this.service.openStream(descriptor, duration, false);){
            return IDESupportToolkit.writeToUniqueFile((MCFile)this.path, (InputStream)stream, (IProgressMonitor)monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

