/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Root;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;

public abstract class InterimRefChain {
    private final ProblemRecorder problemRecorder;
    protected RefChainElementImpl.GCRoot curRootRefChainElement;
    protected final ArrayList<RefChainElementImpl.GCRoot> rootElements;
    protected boolean newGCRoot;
    protected RefChainElement curCondensedRefChainElement;

    public InterimRefChain(ProblemRecorder problemRecorder) {
        this.problemRecorder = problemRecorder;
        this.rootElements = new ArrayList();
    }

    void setCurrentRoot(Root currentRoot) {
        if (this.curRootRefChainElement != null) {
            this.curRootRefChainElement.switchTreeToFinalFormat();
        }
        if (currentRoot == null) {
            currentRoot = Root.UNKNOWN_ROOT;
        }
        this.curRootRefChainElement = new RefChainElementImpl.GCRoot(currentRoot);
        this.rootElements.add(this.curRootRefChainElement);
        this.resetCurrentRoot();
    }

    void resetCurrentRoot() {
        this.newGCRoot = true;
        this.curCondensedRefChainElement = this.curRootRefChainElement;
        this.onCurrentRootReset();
    }

    protected abstract void onCurrentRootReset();

    protected abstract JavaObject getPointingJavaObject();

    protected abstract RefChainElement getLastRefChainElement();

    protected void convertRefChainElementsToFinalRepresentation() {
        this.curRootRefChainElement.switchTreeToFinalFormat();
    }

    void recordCurrentRefChainForColCluster(JavaLazyReadObject col, CollectionInstanceDescriptor colDesc, Constants.ProblemKind ovhdKind, int ovhd) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordProblematicCollection(col, colDesc, ovhdKind, ovhd, referer);
    }

    void recordCurrentRefChainForGoodCollection(JavaLazyReadObject col, CollectionInstanceDescriptor colDesc) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordGoodCollection(col, colDesc, referer);
    }

    void recordCurrentRefChainForDupString(JavaObject stringObj, String s, int implInclusiveSize, int ovhd, boolean hasDupBackingCharArray) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordDuplicateString(stringObj, s, implInclusiveSize, ovhd, hasDupBackingCharArray, referer);
    }

    void recordCurrentRefChainForNonDupString(JavaObject stringObj, int implInclusiveSize) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordNonDuplicateString(stringObj, implInclusiveSize, referer);
    }

    void recordCurrentRefChainForDupArray(JavaValueArray ar, int ovhd) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordDuplicateArray(ar, ovhd, referer);
    }

    void recordCurrentRefChainForNonDupArray(JavaValueArray ar) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordNonDuplicateArray(ar, referer);
    }

    void recordCurrentRefChainForWeakHashMapWithBackRefs(JavaObject col, CollectionInstanceDescriptor colDesc, int ovhd, String valueTypeAndSample) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordWeakHashMapWithBackRefs(col, colDesc, ovhd, valueTypeAndSample, referer);
    }

    void recordCurrentRefChainForGoodInstance(JavaObject obj) {
        RefChainElement referer = this.getLastRefChainElement();
        this.problemRecorder.recordGoodInstance(obj, referer);
    }
}

