/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.support;

import java.util.ArrayList;
import java.util.HashMap;
import org.openjdk.jmc.joverflow.descriptors.CollectionClassDescriptor;
import org.openjdk.jmc.joverflow.stats.ClassloaderStats;
import org.openjdk.jmc.joverflow.stats.LengthHistogram;
import org.openjdk.jmc.joverflow.stats.ObjectHistogram;
import org.openjdk.jmc.joverflow.support.CompressibleStringStats;
import org.openjdk.jmc.joverflow.support.DupArrayStats;
import org.openjdk.jmc.joverflow.support.DupStringStats;
import org.openjdk.jmc.joverflow.support.NumberEncodingStringStats;
import org.openjdk.jmc.joverflow.support.ShortArrayStats;
import org.openjdk.jmc.joverflow.util.ObjectToIntMap;

public class HeapStats {
    public int ptrSize;
    public int objHeaderSize;
    public int objAlignment;
    public boolean usingNarrowPointers;
    public int nClasses;
    public int nObjects;
    public int nInstances;
    public int nObjectArrays;
    public int nValueArrays;
    public long totalObjSize;
    public long totalInstSize;
    public long totalObjArraySize;
    public long totalValueArraySize;
    public long ovhdObjHeaders;
    public int nEntryInstances;
    public long entryClassSize;
    public ClassloaderStats classloaderStats;
    public ShortArrayStats shortStringStats;
    public ShortArrayStats shortPrimitiveArrayStats;
    public ShortArrayStats shortObjArrayStats;
    public int nBoxedNumbers;
    public long ovhdBoxedNumbers;
    public ObjectToIntMap.Entry<String>[] unmodifiableClasses;
    public int numCols;
    public int numEmptyUnusedCols;
    public int numEmptyUsedCols;
    public int numEmptyCols;
    public int numSmallCols;
    public int numSparseSmallCols;
    public int numSparseLargeCols;
    public int numBoxedNumberCols;
    public int numBarCols;
    public long emptyUnusedColsOverhead;
    public long emptyUsedColsOverhead;
    public long emptyColsOverhead;
    public long smallColsOverhead;
    public long sparseSmallColsOverhead;
    public long sparseLargeColsOverhead;
    public long boxedNumberColsOverhead;
    public long barColsOverhead;
    public int numObjArrays;
    public int numLengthZeroObjArrays;
    public int numLengthOneObjArrays;
    public int numEmptyObjArrays;
    public int numSparseObjArrays;
    public int numBoxedNumberArrays;
    public int numBarObjArrays;
    public long lengthZeroObjArraysOverhead;
    public long lengthOneObjArraysOverhead;
    public long emptyObjArraysOverhead;
    public long sparseObjArraysOverhead;
    public long boxedNumberArraysOverhead;
    public long barObjArraysOverhead;
    public int numValueArrays;
    public int numLengthZeroValueArrays;
    public int numLengthOneValueArrays;
    public int numEmptyValueArrays;
    public int numLZTValueArrays;
    public int numUnusedHiBytesValueArrays;
    public long lengthZeroValueArraysOverhead;
    public long lengthOneValueArraysOverhead;
    public long emptyValueArraysOverhead;
    public long lztValueArraysOverhead;
    public long unusedHiBytesValueArraysOverhead;
    public ArrayList<CollectionClassDescriptor> overheadsByClass;
    public ObjectHistogram objHisto;
    public DupStringStats dupStringStats;
    public CompressibleStringStats compressibleStringStats;
    public NumberEncodingStringStats numberEncodingStringStats;
    public LengthHistogram stringLengthHistogram;
    public DupArrayStats dupArrayStats;
    public HashMap<String, String> systemProperties;

    public HeapStats setGeneralStats(int ptrSize, int objHeaderSize, int objAlignment, boolean usingNarrowPointers, int nClasses, int nObjects, int nInstances, int nObjectArrays, long totalObjSize, long totalInstSize, long totalObjArraySize) {
        this.ptrSize = ptrSize;
        this.objHeaderSize = objHeaderSize;
        this.objAlignment = objAlignment;
        this.usingNarrowPointers = usingNarrowPointers;
        this.nClasses = nClasses;
        this.nObjects = nObjects;
        this.nInstances = nInstances;
        this.nObjectArrays = nObjectArrays;
        this.nValueArrays = nObjects - nInstances - nObjectArrays;
        this.totalObjSize = totalObjSize;
        this.totalInstSize = totalInstSize;
        this.totalObjArraySize = totalObjArraySize;
        this.totalValueArraySize = totalObjSize - totalInstSize - totalObjArraySize;
        return this;
    }

    public HeapStats setObjOverheadStats(long ovhdObjHeaders, int nEntryInstances, long entryClassSize) {
        this.ovhdObjHeaders = ovhdObjHeaders;
        this.nEntryInstances = nEntryInstances;
        this.entryClassSize = entryClassSize;
        return this;
    }

    public HeapStats setClassloaderStats(ClassloaderStats clStats) {
        this.classloaderStats = clStats;
        return this;
    }

    public HeapStats setShortObjArrayStats(ShortArrayStats shortArrayStats) {
        this.shortObjArrayStats = shortArrayStats;
        return this;
    }

    public HeapStats setShortPrimitiveArrayStats(ShortArrayStats shortArrayStats) {
        this.shortPrimitiveArrayStats = shortArrayStats;
        return this;
    }

    public HeapStats setShortStringStats(ShortArrayStats shortStringStats) {
        this.shortStringStats = shortStringStats;
        return this;
    }

    public HeapStats setBoxedNumberStats(int nBoxedNumbers, long ovhdBoxedNumbers) {
        this.nBoxedNumbers = nBoxedNumbers;
        this.ovhdBoxedNumbers = ovhdBoxedNumbers;
        return this;
    }

    public HeapStats setWrappedCollectionStats(ObjectToIntMap.Entry<String>[] unmodifiableClasses, ObjectToIntMap.Entry<String>[] synchronizedClasses) {
        this.unmodifiableClasses = unmodifiableClasses;
        return this;
    }

    public HeapStats setDupStringStats(DupStringStats dupStringStats) {
        this.dupStringStats = dupStringStats;
        return this;
    }

    public HeapStats setCompressibleStringStats(CompressibleStringStats compressibleStringStats) {
        this.compressibleStringStats = compressibleStringStats;
        return this;
    }

    public HeapStats setNumberEncodingStringStats(NumberEncodingStringStats nesStats) {
        this.numberEncodingStringStats = nesStats;
        return this;
    }

    public HeapStats setStringLengthHistogram(LengthHistogram lenHisto) {
        this.stringLengthHistogram = lenHisto;
        return this;
    }

    public HeapStats setDupArrayStats(DupArrayStats dupArrayStats) {
        this.dupArrayStats = dupArrayStats;
        return this;
    }

    public HeapStats setObjectHistogram(ObjectHistogram objHisto) {
        this.objHisto = objHisto;
        return this;
    }

    public HeapStats setCollectionNumberStats(int numCols, int numEmptyUnusedCols, int numEmptyUsedCols, int numEmptyCols, int numSmallCols, int numSparseSmallCols, int numSparseLargeCols, int numBoxedNumberCols, int numBarCols) {
        this.numCols = numCols;
        this.numEmptyUnusedCols = numEmptyUnusedCols;
        this.numEmptyUsedCols = numEmptyUsedCols;
        this.numEmptyCols = numEmptyCols;
        this.numSmallCols = numSmallCols;
        this.numSparseSmallCols = numSparseSmallCols;
        this.numSparseLargeCols = numSparseLargeCols;
        this.numBoxedNumberCols = numBoxedNumberCols;
        this.numBarCols = numBarCols;
        return this;
    }

    public HeapStats setCollectionOverhead(long emptyUnusedColsOvhd, long emptyUsedColsOvhd, long emptyColsOvhd, long smallColsOvhd, long sparseSmallColsOvhd, long sparseLargeColsOvhd, long boxedNumberColsOvhd, long barColsOvhd) {
        this.emptyUnusedColsOverhead = emptyUnusedColsOvhd;
        this.emptyUsedColsOverhead = emptyUsedColsOvhd;
        this.emptyColsOverhead = emptyColsOvhd;
        this.smallColsOverhead = smallColsOvhd;
        this.sparseSmallColsOverhead = sparseSmallColsOvhd;
        this.sparseLargeColsOverhead = sparseLargeColsOvhd;
        this.boxedNumberColsOverhead = boxedNumberColsOvhd;
        this.barColsOverhead = barColsOvhd;
        return this;
    }

    public HeapStats setObjArrayNumberStats(int numObjArrays, int numLengthZeroObjArrays, int numLengthOneObjArrays, int numEmptyObjArrays, int numSparseObjArrays, int numBoxedNumberArrays, int numBarObjArrays) {
        this.numObjArrays = numObjArrays;
        this.numLengthZeroObjArrays = numLengthZeroObjArrays;
        this.numLengthOneObjArrays = numLengthOneObjArrays;
        this.numEmptyObjArrays = numEmptyObjArrays;
        this.numSparseObjArrays = numSparseObjArrays;
        this.numBoxedNumberArrays = numBoxedNumberArrays;
        this.numBarObjArrays = numBarObjArrays;
        return this;
    }

    public HeapStats setObjArrayOverhead(long lengthZeroObjArraysOvhd, long lengthOneObjArraysOvhd, long emptyArraysOvhd, long sparseArraysOvhd, long boxedNumberArraysOvhd, long barArraysOvhd) {
        this.lengthZeroObjArraysOverhead = lengthZeroObjArraysOvhd;
        this.lengthOneObjArraysOverhead = lengthOneObjArraysOvhd;
        this.emptyObjArraysOverhead = emptyArraysOvhd;
        this.sparseObjArraysOverhead = sparseArraysOvhd;
        this.boxedNumberArraysOverhead = boxedNumberArraysOvhd;
        this.barObjArraysOverhead = barArraysOvhd;
        return this;
    }

    public HeapStats setCollectionOverheadByClass(ArrayList<CollectionClassDescriptor> overheadsByClass) {
        this.overheadsByClass = overheadsByClass;
        return this;
    }

    public HeapStats setValueArrayNumberStats(int numValueArrays, int numLengthZeroValueArrays, int numLengthOneValueArrays, int numEmptyValueArrays, int numLZTValueArrays, int numUnusedHiBytesValueArrays) {
        this.numValueArrays = numValueArrays;
        this.numLengthZeroValueArrays = numLengthZeroValueArrays;
        this.numLengthOneValueArrays = numLengthOneValueArrays;
        this.numEmptyValueArrays = numEmptyValueArrays;
        this.numLZTValueArrays = numLZTValueArrays;
        this.numUnusedHiBytesValueArrays = numUnusedHiBytesValueArrays;
        return this;
    }

    public HeapStats setValueArrayOverhead(long lengthZeroValueArraysOvhd, long lengthOneValueArraysOvhd, long emptyValueArraysOvhd, long lztValueArraysOvhd, long unusedHiBytesValueArraysOvhd) {
        this.lengthZeroValueArraysOverhead = lengthZeroValueArraysOvhd;
        this.lengthOneValueArraysOverhead = lengthOneValueArraysOvhd;
        this.emptyValueArraysOverhead = emptyValueArraysOvhd;
        this.lztValueArraysOverhead = lztValueArraysOvhd;
        this.unusedHiBytesValueArraysOverhead = unusedHiBytesValueArraysOvhd;
        return this;
    }

    public HeapStats setSystemProperties(HashMap<String, String> systemProps) {
        this.systemProperties = systemProps;
        return this;
    }
}

