/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.editor.sections;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.agent.manager.model.Event;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;

public class EventListSection
extends MCSectionPart {
    private static final String SECTION_TITLE = "Event List";
    private static final String NO_EVENT_REGISTERED = "No event registered";
    private final Composite stack;
    private final StackLayout stackLayout;
    private final Composite message;
    private final TableViewer viewer;

    public EventListSection(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, 256);
        this.getSection().setText(SECTION_TITLE);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        this.stack = toolkit.createComposite(body);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stack.setLayout((Layout)this.stackLayout);
        this.message = toolkit.createComposite(this.stack);
        this.message.setLayout((Layout)new GridLayout(1, false));
        toolkit.createLabel(this.message, NO_EVENT_REGISTERED).setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.viewer = this.createViewer(this.stack, toolkit);
        this.viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
    }

    private TableViewer createViewer(Composite parent, FormToolkit formToolkit) {
        Table table = formToolkit.createTable(parent, 68352);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Event)element).getName();
            }
        });
        return viewer;
    }

    public void setInput(IPreset preset) {
        this.viewer.setInput((Object)preset);
        this.stackLayout.topControl = preset == null || preset.getEvents().length == 0 ? this.message : this.viewer.getControl();
        this.stack.layout();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    private static class ListContentProvider
    extends AbstractStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (!(inputElement instanceof IPreset)) {
                throw new IllegalArgumentException("input element must be an IPreset");
            }
            return ((IPreset)inputElement).getEvents();
        }
    }
}

