/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface FrameFontProvider<T> {
    @NotNull
    public Font getFont(@Nullable FrameBox<@NotNull T> var1, int var2);

    @NotNull
    public static <T> @NotNull FrameFontProvider<@NotNull T> defaultFontProvider() {
        return new FrameFontProvider<T>(){
            private final Font regular = new Font("SansSerif", 0, 12);
            private final Font italic = new Font("SansSerif", 2, 12);
            private final Font bold = new Font("SansSerif", 1, 12);
            private final Font italicBold = new Font("SansSerif", 3, 12);

            @Override
            @NotNull
            public Font getFont(@Nullable FrameBox<@NotNull T> frame, int flags) {
                if (frame != null && frame.isRoot()) {
                    return this.bold;
                }
                if (FrameRenderingFlags.isHighlightedFrame(flags)) {
                    return FrameRenderingFlags.isPartialFrame(flags) ? this.italicBold : this.bold;
                }
                return FrameRenderingFlags.isPartialFrame(flags) ? this.italic : this.regular;
            }
        };
    }
}

