/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.openjdk.jmc.greychart.AbstractAxis;
import org.openjdk.jmc.greychart.GreyChartPanel;
import org.openjdk.jmc.greychart.LongAxis;
import org.openjdk.jmc.greychart.SeriesGreyChart;
import org.openjdk.jmc.greychart.XAxis;
import org.openjdk.jmc.greychart.util.ChartRenderingToolkit;

public abstract class AbstractAliasingLongAxis
extends AbstractAxis
implements LongAxis,
XAxis {
    public static final long DEFAULT_RANGE = 60000L;
    private long m_diff;
    private long m_fixedRange;
    private final long[] m_aliasingArray;

    public AbstractAliasingLongAxis(SeriesGreyChart owner, long[] aliasingArray, long defaultRange, long defaultDiff) {
        super(owner);
        this.setTickMarksEnabled(true);
        this.setNumberOfTicks(5);
        this.m_diff = defaultDiff;
        this.m_fixedRange = defaultRange;
        this.m_aliasingArray = aliasingArray;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle plotArea) {
        this.setRenderedBounds(targetArea);
        if (targetArea.width <= 0 || targetArea.height <= 0) {
            return;
        }
        AffineTransform trans = ctx.getTransform();
        ctx.translate(targetArea.x, targetArea.y);
        ctx.setColor(this.getBackground());
        ctx.fillRect(0, 0, this.getRenderedWidth(), this.getRenderedHeight());
        ctx.setColor(this.getForeground());
        ctx.drawLine(0, 0, this.getRenderedWidth(), 0);
        if (this.isTickMarksEnabled()) {
            long tickInterval = this.getNormalizedTickDistance();
            Font oldfont = ctx.getFont();
            FontMetrics fm = ctx.getFontMetrics();
            Font font = oldfont.deriveFont(this.getActualFontSize(oldfont.getSize()));
            if (oldfont.getSize() != font.getSize()) {
                ctx.setFont(font);
                fm = ctx.getFontMetrics();
            }
            int tickSize = (int)(this.getRelativeTickSize() * (float)(fm.getMaxAscent() + fm.getMaxDescent()));
            long max = this.m_max.longValue();
            long min = this.m_min.longValue();
            long startVal = this.getFirstTickValue(tickInterval);
            Rectangle worstBounds = fm.getStringBounds(this.formatString(this.getLastTickValue(tickInterval), min, max, tickInterval), ctx).getBounds();
            long numberY = tickSize * 2 + worstBounds.height;
            int tickIntervalX = (int)Math.round((double)this.getRenderedWidth() / (double)this.m_diff * (double)tickInterval);
            if (tickIntervalX < 1) {
                tickIntervalX = 1;
            }
            int skipCount = (int)(worstBounds.getWidth() * 1.2) / tickIntervalX;
            int count = 0;
            long tickVal = startVal;
            while (tickVal <= max) {
                int x = this.convertLongAxisValueToDrawingCoordinate(tickVal);
                ctx.drawLine(x, -tickSize, x, tickSize);
                if (this.isPaintGridLinesEnabled()) {
                    Stroke oldStroke = ctx.getStroke();
                    ctx.setColor(this.getTitleColor());
                    ctx.setStroke(DASH_STROKE);
                    ctx.drawLine(x, 0, x, -plotArea.height);
                    ctx.setColor(this.getForeground());
                    ctx.setStroke(oldStroke);
                }
                if (skipCount == 0 || count % (skipCount + 1) == 0) {
                    String text = this.formatString(tickVal, min, max, tickInterval);
                    Rectangle2D bounds = fm.getStringBounds(text, ctx);
                    ctx.drawString(text, (float)((int)Math.round((double)x - bounds.getWidth() / 2.0)), (float)numberY);
                }
                ++count;
                tickVal += tickInterval;
            }
            Object title = this.getTitle();
            String unitString = this.getFormatter().getUnitString(this.m_min.longValue(), this.m_max.longValue());
            if (unitString.length() > 0) {
                title = (String)title + unitString;
            }
            Rectangle2D bounds = fm.getStringBounds((String)title, ctx);
            ctx.setColor(this.getTitleColor());
            ctx.drawString((String)title, this.getRenderedWidth() / 2 - (int)bounds.getWidth() / 2, this.getRenderedHeight() - fm.getDescent() - tickSize);
            if (GreyChartPanel.DEBUG) {
                ChartRenderingToolkit.markBoundary(ctx, 0, 0, targetArea.width, targetArea.height, Color.RED);
            }
            ctx.setFont(oldfont);
            ctx.setTransform(trans);
        }
    }

    private String formatString(long tickValue, long min, long max, long labelDistance) {
        return this.getFormatter().format(tickValue, min, max, labelDistance);
    }

    public void setRange(Number min, Number max) {
        this.m_min = min;
        this.m_max = max;
        this.setRangeInternal(min, max);
    }

    public void setRange(Number max) {
        this.setRange(max.longValue() - this.getFixedRange(), max);
    }

    private void setRangeInternal(Number min, Number max) {
        this.m_diff = max.longValue() - min.longValue();
        if (this.m_diff <= 0L) {
            this.m_diff = 1L;
        }
        this.fireAxisChange();
    }

    @Override
    public int convertAxisValueToDrawingCoordinate(double value) {
        return Math.round((float)((double)this.getRenderedWidth() / (double)this.m_diff * (value - (double)this.m_min.longValue())));
    }

    @Override
    public double convertDrawingCoordinateToAxisValue(int coordinate) {
        return (double)this.m_diff * ((double)coordinate / (double)this.getRenderedWidth()) + this.m_min.doubleValue();
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        Font oldfont;
        if (!this.isVisible()) {
            return new Dimension(totalDrawingArea.width, 0);
        }
        Font newFont = oldfont = ctx.getFont();
        float actualSize = this.getActualFontSize(oldfont.getSize());
        if (actualSize != (float)oldfont.getSize()) {
            newFont = oldfont.deriveFont(actualSize);
        }
        FontMetrics fm = ctx.getFontMetrics(newFont);
        int fontHeight = fm.getMaxAscent() + fm.getMaxDescent();
        int tickSize = (int)(this.getRelativeTickSize() * (float)fontHeight);
        int titleSize = this.hasTitle() ? fontHeight * 2 : fontHeight;
        return new Dimension(totalDrawingArea.width, titleSize + tickSize * 6);
    }

    private long getFirstTickValue(long tickDistance) {
        long ticksBeforeMin = this.getMin().longValue() / tickDistance;
        return (ticksBeforeMin + 1L) * tickDistance;
    }

    private long getLastTickValue(long tickDistance) {
        long ticksBeforeMax = this.getMax().longValue() / tickDistance;
        return ticksBeforeMax * tickDistance;
    }

    private long getNormalizedTickDistance() {
        long range = this.getLongRange();
        long minTickDist = range / (long)this.getNumberOfTicks();
        long quantum = this.getLargestTickQuantumBelow(minTickDist);
        long quantaPerTick = minTickDist / quantum + 1L;
        return quantaPerTick * quantum;
    }

    private long getLargestTickQuantumBelow(long range) {
        int i = 1;
        while (i < this.m_aliasingArray.length) {
            if (range <= this.m_aliasingArray[i]) {
                return this.m_aliasingArray[i - 1];
            }
            ++i;
        }
        return this.m_aliasingArray[this.m_aliasingArray.length - 1];
    }

    public long getFixedRange() {
        return this.m_fixedRange;
    }

    public void setFixedRange(long fixedRange) {
        this.m_fixedRange = fixedRange;
    }

    public String toString() {
        return "DateXAxis range: " + (this.getMax().longValue() - this.getMin().longValue()) / 1000000000L + " s min:" + String.valueOf(this.getMin()) + " max:" + String.valueOf(this.getMax());
    }

    @Override
    public long convertDrawingCoordinateToLongAxisValue(int coordinate) {
        return (long)((double)this.m_diff * ((double)coordinate / (double)this.getRenderedWidth()) + (double)this.m_min.longValue());
    }

    @Override
    public int convertLongAxisValueToDrawingCoordinate(long value) {
        return (int)((double)this.getRenderedWidth() * ((double)(value - this.m_min.longValue()) / (double)this.m_diff));
    }

    @Override
    public long getLongRange() {
        return this.getMax().longValue() - this.getMin().longValue();
    }
}

