/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.p2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.openjdk.jmc.rcp.application.ApplicationPlugin;
import org.openjdk.jmc.rcp.application.Messages;
import org.openjdk.jmc.rcp.application.p2.UpdateSiteURLToolkit;

public final class P2Toolkit {
    public static void addRepositories(IProvisioningAgent agent) {
        for (String site : UpdateSiteURLToolkit.getUpdateSites()) {
            P2Toolkit.addRepository(agent, site);
        }
    }

    private static void addRepository(IProvisioningAgent agent, String repo) {
        URI repoUri;
        try {
            repoUri = new URI(repo);
        }
        catch (URISyntaxException e) {
            ApplicationPlugin.getLogger().log(Level.WARNING, "Failed to add update site due to malformed URI", e);
            return;
        }
        ProvisioningUI ui = ProvUIActivator.getDefault().getProvisioningUI();
        IArtifactRepositoryManager artifactManager = ProvUI.getArtifactRepositoryManager((ProvisioningSession)ui.getSession());
        artifactManager.addRepository(repoUri);
        IMetadataRepositoryManager metadataManager = ProvUI.getMetadataRepositoryManager((ProvisioningSession)ui.getSession());
        metadataManager.addRepository(repoUri);
        metadataManager.setRepositoryProperty(repoUri, "p2.nickname", Messages.JMC_RCP_P2_UPDATESITE_NICK_NAME);
        artifactManager.setRepositoryProperty(repoUri, "p2.nickname", Messages.JMC_RCP_P2_UPDATESITE_NICK_NAME);
    }
}

