/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.p2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.openjdk.jmc.rcp.application.ApplicationPlugin;

public final class UpdateSiteURLToolkit {
    private static final String KEY_UPDATE_PROPERTIES_PATH = "org.openjdk.jmc.updatesites.properties";
    private static final Object SITES_LOCK = new Object();
    private static List<String> SITES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUpdateSites() {
        Object object = SITES_LOCK;
        synchronized (object) {
            if (SITES == null) {
                ArrayList<String> updateSites = new ArrayList<String>();
                Properties props = UpdateSiteURLToolkit.readOverrideProperties();
                if (props == null) {
                    props = UpdateSiteURLToolkit.readDefaultProperties();
                }
                if (props != null) {
                    String site;
                    int i = 0;
                    do {
                        if ((site = props.getProperty("updatesite." + i++)) == null) continue;
                        updateSites.add(MessageFormat.format(site, ApplicationPlugin.VERSION));
                    } while (site != null);
                }
                SITES = updateSites;
            }
            if (SITES.size() == 0) {
                ApplicationPlugin.getLogger().log(Level.INFO, "No updatesites configured. To manually configure updatesites set the org.openjdk.jmc.updatesites.properties property on the commandline to point to a file that specifies one or more 'updatesite.<num from 0 and up>=<updatesite url>' properties");
            }
            return SITES;
        }
    }

    private static Properties readDefaultProperties() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream is = UpdateSiteURLToolkit.class.getClassLoader().getResourceAsStream("updatesites.properties");){
                if (is != null) {
                    Properties props = new Properties();
                    props.load(is);
                    return props;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ApplicationPlugin.getLogger().log(Level.WARNING, "Could not load default update sites", e);
        }
        return null;
    }

    private static Properties readOverrideProperties() {
        File propertiesFile;
        String propertiesPath = System.getProperty(KEY_UPDATE_PROPERTIES_PATH);
        if (propertiesPath != null && (propertiesFile = new File(propertiesPath)).isFile() && propertiesFile.canRead()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream is = new FileInputStream(propertiesFile);){
                    Properties props = new Properties();
                    props.load(is);
                    return props;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                ApplicationPlugin.getLogger().log(Level.WARNING, "Could not load override update sites", e);
            }
        }
        return null;
    }

    private UpdateSiteURLToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }
}

