/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.IParserStats;
import org.openjdk.jmc.flightrecorder.parser.IConstantPoolExtension;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;

public class ParserStats {
    private short majorVersion;
    private short minorVersion;
    private final AtomicInteger chunkCount = new AtomicInteger();
    private final AtomicLong skippedEventCount = new AtomicLong();
    private final ConcurrentHashMap<String, EventTypeStats> statsByType = new ConcurrentHashMap();
    private final ConcurrentLinkedDeque<ConstantPoolInfo> constantPoolInfoList = new ConcurrentLinkedDeque();
    private final ConcurrentHashMap<String, AtomicLong> entryPoolSizeByType = new ConcurrentHashMap();
    private IItemCollection poolStats;
    private IItemCollection constants;
    private final Map<String, IConstantPoolExtension> constantPoolExtensions = new ConcurrentHashMap<String, IConstantPoolExtension>();

    public void setVersion(short majorVersion, short minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public void incChunkCount() {
        this.chunkCount.incrementAndGet();
    }

    public void setSkippedEventCount(long skippedEventCount) {
        this.skippedEventCount.addAndGet(skippedEventCount);
    }

    public void updateEventStats(String eventTypeName, long size) {
        this.statsByType.computeIfAbsent(eventTypeName, EventTypeStats::new).add(size);
    }

    public void addConstantPool(long id, String name, FastAccessNumberMap<Object> constantPool) {
        this.constantPoolInfoList.add(new ConstantPoolInfo(id, name, constantPool));
    }

    public void addEntryPoolSize(String typeIdentifier, long size) {
        this.entryPoolSizeByType.computeIfAbsent(typeIdentifier, id -> new AtomicLong()).addAndGet(size);
    }

    public void addConstantPoolExtension(IConstantPoolExtension extension) {
        this.constantPoolExtensions.put(extension.getId(), extension);
    }

    public void forEachEventType(Consumer<IParserStats.IEventStats> consumer) {
        for (EventTypeStats eventStats : this.statsByType.values()) {
            consumer.accept(eventStats);
        }
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public int getChunkCount() {
        return this.chunkCount.get();
    }

    public long getSkippedEventCount() {
        return this.skippedEventCount.get();
    }

    public long getCount(String eventTypeName) {
        EventTypeStats stats = this.statsByType.get(eventTypeName);
        if (stats == null) {
            return 0L;
        }
        return stats.getCount();
    }

    public long getTotalSize(String eventTypeName) {
        EventTypeStats stats = this.statsByType.get(eventTypeName);
        if (stats == null) {
            return 0L;
        }
        return stats.getTotalSize();
    }

    public IItemCollection getConstantPools() {
        if (this.poolStats == null) {
            HashMap<String, ConstPoolItem> poolStatsByName = new HashMap<String, ConstPoolItem>();
            for (ConstantPoolInfo info : this.constantPoolInfoList) {
                ConstPoolItem poolItem = poolStatsByName.computeIfAbsent(info.name, this::createPoolItem);
                poolItem.count += this.getConstantPoolCount(info.constantPool);
            }
            this.poolStats = ItemCollectionToolkit.build(poolStatsByName.values().stream());
        }
        return this.poolStats;
    }

    public IItemCollection getConstants() {
        if (this.constants == null) {
            ArrayList<ConstantItem> items = new ArrayList<ConstantItem>();
            for (ConstantPoolInfo info : this.constantPoolInfoList) {
                for (Object value : info.constantPool) {
                    items.add(new ConstantItem(info.name, value));
                }
            }
            this.constants = ItemCollectionToolkit.build(items.stream());
        }
        return this.constants;
    }

    public Map<String, IConstantPoolExtension> getConstantPoolExtensions() {
        return this.constantPoolExtensions;
    }

    private ConstPoolItem createPoolItem(String infoName) {
        AtomicLong totalSize = this.entryPoolSizeByType.get(infoName);
        long entrySize = totalSize != null ? totalSize.longValue() : 0L;
        return new ConstPoolItem(infoName, 0L, entrySize);
    }

    private long getConstantPoolCount(FastAccessNumberMap<Object> constantPool) {
        Iterator iterator = constantPool.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    private static class EventTypeStats
    implements IParserStats.IEventStats {
        private final String eventTypeName;
        private static final AtomicLongFieldUpdater<EventTypeStats> COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(EventTypeStats.class, "count");
        private volatile long count;
        private static final AtomicLongFieldUpdater<EventTypeStats> TOTAL_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(EventTypeStats.class, "totalSize");
        private volatile long totalSize;

        public EventTypeStats(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        public void add(long size) {
            COUNT_UPDATER.incrementAndGet(this);
            TOTAL_SIZE_UPDATER.addAndGet(this, size);
        }

        @Override
        public String getName() {
            return this.eventTypeName;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "EventTypeStats [eventTypeName=" + this.eventTypeName + ", count=" + this.count + ", totalSize=" + this.totalSize + "]";
        }
    }

    private static class ConstantPoolInfo {
        final long id;
        final String name;
        final FastAccessNumberMap<Object> constantPool;

        public ConstantPoolInfo(long id, String name, FastAccessNumberMap<Object> constantPool) {
            this.id = id;
            this.name = name;
            this.constantPool = constantPool;
        }
    }

    static class ConstPoolItem
    implements IItem,
    IType<IItem> {
        private final String name;
        private long count;
        private final long size;

        public IType<?> getType() {
            return this;
        }

        public ConstPoolItem(String name, long count, long size) {
            this.name = name;
            this.count = count;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return "ConstantPoolStats";
        }

        public List<IAttribute<?>> getAttributes() {
            return Collections.emptyList();
        }

        public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
            return null;
        }

        public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
            return false;
        }

        public <M> IMemberAccessor<M, IItem> getAccessor(IAccessorKey<M> attribute) {
            if ("name".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant((Object)this.name);
            }
            if ("count".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant((Object)this.count);
            }
            if ("size".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant((Object)UnitLookup.BYTE.quantity(this.size));
            }
            return null;
        }

        public String getIdentifier() {
            return "constPoolStatsType";
        }
    }

    static class ConstantItem
    implements IItem,
    IType<IItem> {
        private final String typeName;
        private final Object constant;

        public ConstantItem(String typeName, Object constant) {
            this.typeName = typeName;
            this.constant = constant;
        }

        public String getName() {
            return this.typeName;
        }

        public String getDescription() {
            return null;
        }

        public List<IAttribute<?>> getAttributes() {
            return Collections.emptyList();
        }

        public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
            return null;
        }

        public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
            return false;
        }

        public <M> IMemberAccessor<M, IItem> getAccessor(IAccessorKey<M> attribute) {
            if ("typeName".equals(attribute.getIdentifier())) {
                return MemberAccessorToolkit.constant((Object)this.typeName);
            }
            if ("constant".equals(attribute.getIdentifier())) {
                IMCStackTrace stackTrace;
                if (this.constant instanceof IMCStackTrace && !(stackTrace = (IMCStackTrace)this.constant).getFrames().isEmpty()) {
                    IMCFrame imcFrame = (IMCFrame)stackTrace.getFrames().get(0);
                    String str = StacktraceFormatToolkit.formatFrame(imcFrame, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false));
                    return MemberAccessorToolkit.constant((Object)str);
                }
                return MemberAccessorToolkit.constant((Object)this.constant);
            }
            if ("stackTrace".equals(attribute.getIdentifier()) && this.constant instanceof IMCStackTrace) {
                return MemberAccessorToolkit.constant((Object)((IMCStackTrace)this.constant));
            }
            return null;
        }

        public String getIdentifier() {
            return "constantValueType";
        }

        public IType<?> getType() {
            return this;
        }
    }
}

