/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.util;

import java.util.Objects;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;

public final class ParserToolkit {
    public static final String INTERPRETED_TYPE_ID = "Interpreted";
    public static final String JIT_COMPILED_TYPE_ID = "JIT compiled";
    public static final String INLINED_TYPE_ID = "Inlined";
    public static final String NATIVE_TYPE_ID = "Native";
    public static final String CPP_TYPE_ID = "C++";
    public static final String KERNEL_TYPE_ID = "Kernel";
    public static final String UNKNOWN_TYPE_ID = "Unknown";
    public static final String C1_JIT_COMPILED_TYPE_ID = "C1 JIT compiled";
    public static final String C2_JIT_COMPILED_TYPE_ID = "C2 JIT compiled";
    public static final String FALCON_JIT_COMPILED_TYPE_ID = "Falcon JIT compiled";

    private ParserToolkit() {
        throw new Error("Don't");
    }

    public static <T> T get(T[] elements, int index) throws InvalidJfrFileException {
        if (index < 0 || index >= elements.length) {
            throw new InvalidJfrFileException();
        }
        return elements[index];
    }

    public static void assertValue(long value, long accepted) throws InvalidJfrFileException {
        if (value != accepted) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object accepted) throws InvalidJfrFileException {
        if (!Objects.equals(value, accepted)) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object ... accepted) throws InvalidJfrFileException {
        for (Object a : accepted) {
            if (!Objects.equals(a, value)) continue;
            return;
        }
        throw new InvalidJfrFileException(value + " is not among the expected values");
    }

    public static IMCFrame.Type parseFrameType(String type) {
        if (INTERPRETED_TYPE_ID.equals(type)) {
            return IMCFrame.Type.INTERPRETED;
        }
        if (JIT_COMPILED_TYPE_ID.equals(type)) {
            return IMCFrame.Type.JIT_COMPILED;
        }
        if (C1_JIT_COMPILED_TYPE_ID.equals(type)) {
            return IMCFrame.Type.C1_JIT_COMPILED;
        }
        if (C2_JIT_COMPILED_TYPE_ID.equals(type)) {
            return IMCFrame.Type.C2_JIT_COMPILED;
        }
        if (FALCON_JIT_COMPILED_TYPE_ID.equals(type)) {
            return IMCFrame.Type.FALCON_JIT_COMPILED;
        }
        if (INLINED_TYPE_ID.equals(type)) {
            return IMCFrame.Type.INLINED;
        }
        if (NATIVE_TYPE_ID.equals(type)) {
            return IMCFrame.Type.NATIVE;
        }
        if (CPP_TYPE_ID.equals(type)) {
            return IMCFrame.Type.CPP;
        }
        if (KERNEL_TYPE_ID.equals(type)) {
            return IMCFrame.Type.KERNEL;
        }
        if (UNKNOWN_TYPE_ID.equals(type)) {
            return IMCFrame.Type.UNKNOWN;
        }
        return IMCFrame.Type.cachedType((String)type);
    }
}

