/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import java.net.URI;
import java.net.URISyntaxException;
import org.openjdk.jmc.console.agent.manager.model.ICapturedValue;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class CapturedValue
implements ICapturedValue {
    private static final String DEFAULT_STRING_FIELD = "";
    private static final Object DEFAULT_OBJECT_TYPE = null;
    private static final String CONVERTER_REGEX = "([a-zA-Z_$][a-zA-Z0-9_$]*\\.)*([a-zA-Z_$][a-zA-Z0-9_$]*)";
    private static final String XML_TAG_CAPTURED_VALUE = "capturedvalue";
    private static final String XML_TAG_NAME = "name";
    private static final String XML_TAG_DESCRIPTION = "description";
    private static final String XML_TAG_CONTENT_TYPE = "contenttype";
    private static final String XML_TAG_RELATION_KEY = "relationkey";
    private static final String XML_TAG_CONVERTER = "converter";
    private String name = "";
    private String description = "";
    private ICapturedValue.ContentType contentType = (ICapturedValue.ContentType)((Object)DEFAULT_OBJECT_TYPE);
    private String relationKey = "";
    private String converter = "";

    CapturedValue() {
    }

    CapturedValue(Element element) {
        this();
        NodeList elements = element.getElementsByTagName(XML_TAG_NAME);
        if (elements.getLength() != 0) {
            this.name = elements.item(0).getTextContent();
        }
        if ((elements = element.getElementsByTagName(XML_TAG_DESCRIPTION)).getLength() != 0) {
            this.description = elements.item(0).getTextContent();
        }
        if ((elements = element.getElementsByTagName(XML_TAG_CONTENT_TYPE)).getLength() != 0) {
            this.contentType = ICapturedValue.ContentType.valueOf(elements.item(0).getTextContent());
        }
        if ((elements = element.getElementsByTagName(XML_TAG_RELATION_KEY)).getLength() != 0) {
            this.relationKey = elements.item(0).getTextContent();
        }
        if ((elements = element.getElementsByTagName(XML_TAG_CONVERTER)).getLength() != 0) {
            this.converter = elements.item(0).getTextContent();
        }
    }

    @Override
    public Element buildElement(Document document) {
        Element element = document.createElement(XML_TAG_CAPTURED_VALUE);
        if (this.name != null && !this.name.isEmpty()) {
            Element nameElement = document.createElement(XML_TAG_NAME);
            nameElement.setTextContent(this.name);
            element.appendChild(nameElement);
        }
        if (this.description != null && !this.description.isEmpty()) {
            Element descriptionElement = document.createElement(XML_TAG_DESCRIPTION);
            descriptionElement.setTextContent(this.description);
            element.appendChild(descriptionElement);
        }
        if (this.contentType != null) {
            Element contentTypeElement = document.createElement(XML_TAG_CONTENT_TYPE);
            contentTypeElement.setTextContent(this.contentType.toString());
            element.appendChild(contentTypeElement);
        }
        if (this.relationKey != null && !this.relationKey.isEmpty()) {
            Element relationKeyElement = document.createElement(XML_TAG_RELATION_KEY);
            relationKeyElement.setTextContent(this.relationKey);
            element.appendChild(relationKeyElement);
        }
        if (this.converter != null && !this.converter.isEmpty()) {
            Element converterElement = document.createElement(XML_TAG_CONVERTER);
            converterElement.setTextContent(this.converter);
            element.appendChild(converterElement);
        }
        return element;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ICapturedValue.ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(ICapturedValue.ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getRelationKey() {
        return this.relationKey;
    }

    @Override
    public void setRelationKey(String relationKey) {
        if (relationKey != null && !relationKey.isEmpty()) {
            relationKey = relationKey.trim();
            try {
                new URI(relationKey);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(Messages.CapturedValue_ERROR_RELATION_KEY_HAS_INCORRECT_SYNTAX);
            }
        }
        this.relationKey = relationKey;
    }

    @Override
    public String getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(String converter) {
        if (converter != null && !converter.isEmpty() && !(converter = converter.trim()).matches(CONVERTER_REGEX)) {
            throw new IllegalArgumentException(Messages.CapturedValue_ERROR_CONVERTER_HAS_INCORRECT_SYNTAX);
        }
        this.converter = converter;
    }

    protected void copyContentToWorkingCopy(CapturedValue copy) {
        copy.name = this.name;
        copy.description = this.description;
        copy.contentType = this.contentType;
        copy.relationKey = this.relationKey;
        copy.converter = this.converter;
    }
}

