/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import java.util.stream.Stream;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.console.agent.manager.model.ICapturedValue;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IField;
import org.openjdk.jmc.console.agent.manager.model.IMethodParameter;
import org.openjdk.jmc.console.agent.manager.model.IMethodReturnValue;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;

public class CapturedValueEditingPage
extends BaseWizardPage {
    private final IEvent event;
    private ICapturedValue capturedValue;
    private Text nameText;
    private Spinner indexSpinner;
    private Button isReturnValueButton;
    private Text expressionText;
    private Text descriptionText;
    private Combo contentTypeCombo;
    private Button contentTypeClearButton;
    private Text relationalKeyText;
    private Text converterText;

    public CapturedValueEditingPage(IEvent event, ICapturedValue capturedValue) {
        super(Messages.CapturedValueEditingPage_PAGE_NAME);
        this.event = event;
        this.capturedValue = capturedValue;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        if (this.capturedValue instanceof IMethodParameter || this.capturedValue instanceof IMethodReturnValue) {
            this.setTitle(Messages.CapturedValueEditingPage_MESSAGE_PARAMETER_OR_RETURN_VALUE_EDITING_PAGE_TITLE);
            this.setDescription(Messages.CapturedValueEditingPage_MESSAGE_PARAMETER_OR_RETURN_VALUE_EDITING_PAGE_DESCRIPTION);
        } else if (this.capturedValue instanceof IField) {
            this.setTitle(Messages.CapturedValueEditingPage_MESSAGE_FIELD_EDITING_PAGE_TITLE);
            this.setDescription(Messages.CapturedValueEditingPage_MESSAGE_FIELD_EDITING_PAGE_DESCRIPTION);
        } else {
            throw new IllegalStateException("captured value must be a an IMethodParameter, IMethodReturnValue or IFeild");
        }
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createConfigContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        CapturedValueEditingPage.createSeparator(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createMetaInfoContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.bindListeners();
        this.populateUi();
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
    }

    private Composite createConfigContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.nameText = CapturedValueEditingPage.createTextInput(container, cols, Messages.CapturedValueEditingPage_LABEL_NAME, Messages.CapturedValueEditingPage_MESSAGE_NAME_OF_THE_CAPTURING);
        if (this.capturedValue instanceof IField) {
            this.expressionText = CapturedValueEditingPage.createTextInput(container, cols, Messages.CapturedValueEditingPage_LABEL_EXPRESSION, Messages.CapturedValueEditingPage_MESSAGE_JAVA_PRIMARY_EXPRESSION_TO_BE_EVALUATED);
        } else {
            this.indexSpinner = CapturedValueEditingPage.createSpinnerInput(container, 3, Messages.CapturedValueEditingPage_LABEL_INDEX);
            this.isReturnValueButton = CapturedValueEditingPage.createCheckbox(container, Messages.CapturedValueEditingPage_LABEL_IS_RETURN_VALUE);
            this.isReturnValueButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 0));
        }
        this.descriptionText = CapturedValueEditingPage.createMultiTextInput(container, cols, Messages.CapturedValueEditingPage_LABEL_DESCRIPTION, Messages.CapturedValueEditingPage_MESSAGE_OPTIONAL_DESCRIPTION_OF_THIS_CAPTURING);
        return container;
    }

    private Composite createMetaInfoContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 8;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.contentTypeCombo = CapturedValueEditingPage.createComboInput(container, cols - 2, Messages.CapturedValueEditingPage_LABEL_CONTENT_TYPE, (String[])Stream.of(ICapturedValue.ContentType.values()).map(Enum::toString).toArray(String[]::new));
        this.contentTypeClearButton = CapturedValueEditingPage.createButton(container, Messages.CapturedValueEditingPage_LABEL_CLEAR);
        this.contentTypeClearButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 0));
        this.relationalKeyText = CapturedValueEditingPage.createTextInput(container, cols, Messages.CapturedValueEditingPage_LABEL_RELATIONAL_KEY, Messages.CapturedValueEditingPage_MESSAGE_RELATIONAL_KEY_DESCRIPTION);
        this.converterText = CapturedValueEditingPage.createTextInput(container, cols, Messages.CapturedValueEditingPage_LABEL_CONVERTER, Messages.CapturedValueEditingPage_MESSAGE_CONVERTER_DESCRIPTION);
        return container;
    }

    private void bindListeners() {
        this.nameText.addModifyListener(this.handleExceptionIfAny(e -> this.capturedValue.setName(this.nameText.getText())));
        if (this.indexSpinner != null) {
            this.indexSpinner.addModifyListener(this.handleExceptionIfAny(e -> ((IMethodParameter)this.capturedValue).setIndex(this.indexSpinner.getSelection())));
        }
        if (this.isReturnValueButton != null) {
            this.isReturnValueButton.addListener(13, e -> {
                this.indexSpinner.setEnabled(!this.isReturnValueButton.getSelection());
                if (this.isReturnValueButton.getSelection()) {
                    this.convertParameterToReturnValue();
                } else {
                    this.convertReturnValueToParameter();
                }
            });
        }
        if (this.expressionText != null) {
            this.expressionText.addModifyListener(this.handleExceptionIfAny(e -> ((IField)this.capturedValue).setExpression(this.expressionText.getText())));
        }
        this.descriptionText.addModifyListener(this.handleExceptionIfAny(e -> this.capturedValue.setDescription(this.descriptionText.getText())));
        this.contentTypeCombo.addModifyListener(this.handleExceptionIfAny(e -> this.capturedValue.setContentType(this.contentTypeCombo.getSelectionIndex() == -1 ? null : ICapturedValue.ContentType.valueOf(this.contentTypeCombo.getText()))));
        this.contentTypeClearButton.addListener(13, this.handleExceptionIfAny(e -> this.contentTypeCombo.deselectAll()));
        this.relationalKeyText.addModifyListener(this.handleExceptionIfAny(e -> this.capturedValue.setRelationKey(this.relationalKeyText.getText())));
        this.converterText.addModifyListener(this.handleExceptionIfAny(e -> this.capturedValue.setConverter(this.converterText.getText())));
    }

    private void populateUi() {
        CapturedValueEditingPage.setText(this.nameText, this.capturedValue.getName());
        if (this.indexSpinner != null) {
            this.indexSpinner.setSelection(this.capturedValue instanceof IMethodParameter ? ((IMethodParameter)this.capturedValue).getIndex() : 0);
            this.indexSpinner.setEnabled(this.capturedValue instanceof IMethodParameter);
        }
        if (this.isReturnValueButton != null) {
            this.isReturnValueButton.setSelection(this.capturedValue instanceof IMethodReturnValue);
        }
        if (this.expressionText != null) {
            CapturedValueEditingPage.setText(this.expressionText, ((IField)this.capturedValue).getExpression());
        }
        CapturedValueEditingPage.setText(this.descriptionText, this.capturedValue.getDescription());
        CapturedValueEditingPage.setText(this.contentTypeCombo, this.capturedValue.getContentType() == null ? null : this.capturedValue.getContentType().toString());
        CapturedValueEditingPage.setText(this.relationalKeyText, this.capturedValue.getRelationKey());
        CapturedValueEditingPage.setText(this.converterText, this.capturedValue.getConverter());
    }

    public ICapturedValue getResult() {
        return this.capturedValue;
    }

    private void convertParameterToReturnValue() {
        IMethodParameter parameter = (IMethodParameter)this.capturedValue;
        IMethodReturnValue returnValue = this.event.createMethodReturnValue();
        returnValue.setName(parameter.getName());
        returnValue.setDescription(parameter.getDescription());
        returnValue.setContentType(parameter.getContentType());
        returnValue.setRelationKey(parameter.getRelationKey());
        returnValue.setConverter(parameter.getConverter());
        this.capturedValue = returnValue;
    }

    private void convertReturnValueToParameter() {
        IMethodReturnValue returnValue = (IMethodReturnValue)this.capturedValue;
        IMethodParameter parameter = this.event.createMethodParameter();
        parameter.setIndex(0);
        parameter.setName(returnValue.getName());
        parameter.setDescription(returnValue.getDescription());
        parameter.setContentType(returnValue.getContentType());
        parameter.setRelationKey(returnValue.getRelationKey());
        parameter.setConverter(returnValue.getConverter());
        this.capturedValue = parameter;
    }
}

