/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jolokia;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.jolokia.ServerConnectionDescriptor;
import org.openjdk.jmc.rjmx.descriptorprovider.AbstractDescriptorProvider;
import org.openjdk.jmc.rjmx.descriptorprovider.IDescriptorListener;

public abstract class AbstractCachedDescriptorProvider
extends AbstractDescriptorProvider {
    private static final long LOCAL_REFRESH_INTERVAL = 20000L;
    private Scanner scanner;
    private Thread scannerThread;
    private final Map<String, ServerConnectionDescriptor> knownDescriptors = new HashMap<String, ServerConnectionDescriptor>();

    private void initialize() {
        this.scanner = new Scanner();
        this.scannerThread = new Thread((Runnable)this.scanner, this.getName());
        this.scannerThread.start();
    }

    protected abstract boolean isEnabled();

    protected abstract Map<String, ServerConnectionDescriptor> discoverJvms();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            if (this.m_descriptorListeners.size() == 0) {
                super.addDescriptorListener(l);
                this.initialize();
            } else {
                super.addDescriptorListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            super.removeDescriptorListener(l);
            if (this.m_descriptorListeners.size() == 0 && this.scanner != null) {
                this.scanner.shutdown();
                this.scannerThread.interrupt();
            }
        }
    }

    public void shutdown() {
        if (this.scanner != null) {
            this.scanner.shutdown();
        }
    }

    private class Scanner
    implements Runnable {
        boolean isRunning;

        private Scanner() {
        }

        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    this.scan();
                    Thread.sleep(20000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scan() {
            Map<String, ServerConnectionDescriptor> newOnes = AbstractCachedDescriptorProvider.this.discoverJvms();
            Map<String, ServerConnectionDescriptor> map = AbstractCachedDescriptorProvider.this.knownDescriptors;
            synchronized (map) {
                Iterator<Map.Entry<String, ServerConnectionDescriptor>> entryIterator = AbstractCachedDescriptorProvider.this.knownDescriptors.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<String, ServerConnectionDescriptor> entry = entryIterator.next();
                    if (newOnes.containsKey(entry.getKey())) continue;
                    entryIterator.remove();
                    AbstractCachedDescriptorProvider.this.onDescriptorRemoved(entry.getKey());
                }
                for (Map.Entry<String, ServerConnectionDescriptor> entry : newOnes.entrySet()) {
                    if (AbstractCachedDescriptorProvider.this.knownDescriptors.containsKey(entry.getKey())) continue;
                    AbstractCachedDescriptorProvider.this.onDescriptorDetected(entry.getValue(), entry.getValue().getPath(), entry.getValue().serviceUrl(), entry.getValue());
                }
                AbstractCachedDescriptorProvider.this.knownDescriptors.clear();
                AbstractCachedDescriptorProvider.this.knownDescriptors.putAll(newOnes);
            }
        }
    }
}

