/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jolokia;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.service.discovery.JolokiaDiscovery;
import org.openjdk.jmc.jolokia.AbstractCachedDescriptorProvider;
import org.openjdk.jmc.jolokia.JmcJolokiaPlugin;
import org.openjdk.jmc.jolokia.JolokiaAgentDescriptor;
import org.openjdk.jmc.jolokia.JolokiaDiscoverySettings;
import org.openjdk.jmc.jolokia.Messages;
import org.openjdk.jmc.jolokia.ServerConnectionDescriptor;
import org.openjdk.jmc.jolokia.preferences.PreferenceConstants;

public class JolokiaDiscoveryListener
extends AbstractCachedDescriptorProvider
implements PreferenceConstants {
    private JolokiaDiscoverySettings settings;
    private final JolokiaDiscovery jolokiaDiscovery;

    public JolokiaDiscoveryListener(JolokiaDiscoverySettings settings) {
        this.settings = settings;
        this.jolokiaDiscovery = new JolokiaDiscovery();
        this.jolokiaDiscovery.init(this.settings.getJolokiaContext());
    }

    public JolokiaDiscoveryListener() {
        this(JmcJolokiaPlugin.getDefault());
    }

    @Override
    protected Map<String, ServerConnectionDescriptor> discoverJvms() {
        HashMap<String, ServerConnectionDescriptor> found = new HashMap<String, ServerConnectionDescriptor>();
        if (!this.settings.shouldRunDiscovery()) {
            return found;
        }
        try {
            for (Object object : this.jolokiaDiscovery.lookupAgentsWithTimeoutAndMulticastAddress(this.settings.getDiscoveryTimeout(), this.settings.getMulticastGroup(), this.settings.getMulticastPort())) {
                try {
                    Map response = (Map)object;
                    JolokiaAgentDescriptor agentDescriptor = new JolokiaAgentDescriptor(response);
                    found.put(agentDescriptor.getGUID(), agentDescriptor);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        catch (IOException iOException) {}
        return found;
    }

    public String getDescription() {
        return Messages.JolokiaDiscoveryListener_Description;
    }

    public String getName() {
        return "jolokia";
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }
}

