/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.actions.internal;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.security.PersistentCredentials;
import org.openjdk.jmc.common.security.SecurityException;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.actions.internal.Messages;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;

public class TriggerActionMail
extends TriggerAction {
    public static final String XML_ELEMENT_EMAIL_FROM = "email_from";
    public static final String XML_ELEMENT_EMAIL_TO = "email_to";
    public static final String XML_ELEMENT_EMAIL_CC = "email_cc";
    private static final String MAILER = Messages.TriggerActionMail_MAIL_HEADER_MAILER;

    @Override
    public void handleNotificationEvent(TriggerEvent e) throws MessagingException {
        String subject = this.getSubject(e);
        this.sendEMail(subject, NotificationToolkit.prettyPrint(e));
    }

    public void sendEMail(String subject, String content) throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.starttls.enable", this.getSmtpSTARTTLS());
        Session session = Session.getInstance((Properties)props, null);
        UserPassword credentials = this.getSmtpCredentials();
        URLName urlName = this.createURLName(credentials);
        session.setPasswordAuthentication(urlName, new PasswordAuthentication(credentials.getUser(), credentials.getPassword()));
        if (Environment.isDebug()) {
            session.setDebug(true);
        }
        MimeMessage msg = new MimeMessage(session);
        if (this.getFrom() != null && this.getFrom().length() > 0) {
            msg.setFrom((Address)new InternetAddress(this.getFrom()));
        }
        if (this.getTo() != null && this.getTo().length() > 0) {
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
        }
        if (this.getCc() != null && this.getCc().length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.getCc(), (boolean)false));
        }
        msg.setSubject(subject);
        msg.setText(content);
        msg.setHeader("X-Mailer", MAILER);
        msg.setSentDate(new Date());
        Transport transport = session.getTransport(urlName);
        transport.connect();
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    private URLName createURLName(UserPassword credentials) {
        String protocol = this.getSmtpSSL() != false ? "smtps" : "smtp";
        return new URLName(protocol, this.getSmtpServer(), this.getSmtpPort().intValue(), null, credentials.getUser(), credentials.getPassword());
    }

    private String getSmtpServer() {
        return RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.smtp.server", "mail.example.org");
    }

    private UserPassword getSmtpCredentials() {
        try {
            UserPassword userPassword = this.getSecureSmtpCredentials();
            if (userPassword != null) {
                return userPassword;
            }
        }
        catch (SecurityException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load SMTP credentials", e);
        }
        return new UserPassword("", "");
    }

    private UserPassword getSecureSmtpCredentials() throws SecurityException {
        String key = RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.smtp.server.credentials", "");
        if (key != null && !"".equals(key)) {
            PersistentCredentials credentials = new PersistentCredentials(key);
            return new UserPassword(credentials.getUsername(), credentials.getPassword());
        }
        return null;
    }

    private Integer getSmtpPort() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getInt("rjmx.smtp.server.port", 25);
    }

    private Boolean getSmtpSSL() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getBoolean("rjmx.smtp.server.secure", false);
    }

    private Boolean getSmtpSTARTTLS() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getBoolean("rjmx.smtp.server.starttls.encryption", false);
    }

    private String getCc() {
        return this.getSetting(XML_ELEMENT_EMAIL_CC).getString();
    }

    private String getFrom() {
        return this.getSetting(XML_ELEMENT_EMAIL_FROM).getString();
    }

    private String getTo() {
        return this.getSetting(XML_ELEMENT_EMAIL_TO).getString();
    }

    private String getSubject(TriggerEvent e) {
        if (e.wasTriggered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_TRIGGERED, (Object)e.getRule().getName());
        }
        if (e.wasRecovered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_RECOVERED, (Object)e.getRule().getName());
        }
        return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_INVOKED, (Object)e.getRule().getName());
    }

    @Override
    public String toString() {
        return super.toString() + "{From: " + this.getFrom() + "\nTo: " + this.getTo() + "\nSMTP: " + this.getSmtpServer() + "}";
    }

    @Override
    public boolean isReady() {
        try {
            this.getSecureSmtpCredentials();
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static class UserPassword {
        private final String user;
        private final String password;

        private UserPassword(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

