/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.extension.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.openjdk.jmc.rjmx.triggers.ITriggerAction;
import org.openjdk.jmc.rjmx.triggers.ITriggerConstraint;
import org.openjdk.jmc.rjmx.triggers.IValueEvaluator;
import org.openjdk.jmc.rjmx.triggers.condition.internal.TriggerCondition;
import org.openjdk.jmc.rjmx.triggers.extension.internal.ExtensionLoader;
import org.openjdk.jmc.rjmx.triggers.extension.internal.TriggerComponent;
import org.openjdk.jmc.rjmx.triggers.internal.INotificationFactory;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationTrigger;
import org.openjdk.jmc.rjmx.triggers.internal.RegistryEntry;

public class TriggerFactory
implements INotificationFactory {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.triggers.extension.internal");
    private static final String XML_CLASS_ATTRIBUTE = "class";
    private static final String XML_TRIGGER_ACTIONS = "org.openjdk.jmc.rjmx.triggerActions";
    private static final String XML_TRIGGER_ACTION = "triggerAction";
    private static final String XML_TRIGGER_CONSTRAINTS = "org.openjdk.jmc.rjmx.triggerConstraints";
    private static final String XML_TRIGGER_CONSTRAINT = "triggerConstraint";
    private static final String XML_TRIGGER_EVALUATORS = "org.openjdk.jmc.rjmx.triggerEvaluators";
    private static final String XML_TRIGGER_EVALUATOR = "triggerEvaluator";
    private final NotificationRegistry notificationRegistry;
    private ExtensionLoader<TriggerComponent> m_constraints;
    private ExtensionLoader<TriggerComponent> m_actions;
    private ExtensionLoader<IValueEvaluator> m_evaluators;

    public TriggerFactory(NotificationRegistry notificationRegistry) {
        this.notificationRegistry = notificationRegistry;
    }

    public void initializeFactory() {
        this.getActionExtensions();
        this.getConstraintExtensions();
        this.getEvaluatorExtensions();
    }

    @Override
    public ITriggerConstraint createConstraint(String className) throws Exception {
        return (ITriggerConstraint)this.createObject(this.getConstraintExtensions().getConfigElement(className));
    }

    @Override
    public ITriggerAction createAction(String className) throws Exception {
        return (ITriggerAction)this.createObject(this.getActionExtensions().getConfigElement(className));
    }

    @Override
    public IValueEvaluator createEvaluator(String className) throws Exception {
        return (IValueEvaluator)this.createObject(this.getEvaluatorExtensions().getConfigElement(className));
    }

    protected Object createObject(IConfigurationElement element) {
        try {
            return element.createExecutableExtension(XML_CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Failed to create executable extension", e);
            return null;
        }
    }

    public synchronized ExtensionLoader<TriggerComponent> getActionExtensions() {
        if (this.m_actions == null) {
            this.m_actions = new ExtensionLoader(XML_TRIGGER_ACTIONS, XML_TRIGGER_ACTION);
            for (TriggerComponent prototype : this.m_actions.getPrototypes()) {
                RegistryEntry entry = this.createRegistryEntry(prototype);
                this.notificationRegistry.registerAction(entry);
            }
        }
        return this.m_actions;
    }

    public synchronized ExtensionLoader<TriggerComponent> getConstraintExtensions() {
        if (this.m_constraints == null) {
            this.m_constraints = new ExtensionLoader(XML_TRIGGER_CONSTRAINTS, XML_TRIGGER_CONSTRAINT);
            for (TriggerComponent prototype : this.m_constraints.getPrototypes()) {
                RegistryEntry entry = this.createRegistryEntry(prototype);
                this.notificationRegistry.registerConstraint(entry);
            }
        }
        return this.m_constraints;
    }

    public synchronized ExtensionLoader<IValueEvaluator> getEvaluatorExtensions() {
        if (this.m_evaluators == null) {
            this.m_evaluators = new ExtensionLoader(XML_TRIGGER_EVALUATORS, XML_TRIGGER_EVALUATOR);
        }
        return this.m_evaluators;
    }

    private RegistryEntry createRegistryEntry(TriggerComponent extension) {
        String description = extension.getDescription();
        String listName = extension.getName();
        Class<?> registeredClass = extension.getClass();
        Class<?> editorClass = extension.getClass();
        return new RegistryEntry(registeredClass, listName, description, editorClass);
    }

    @Override
    public NotificationTrigger createTrigger() {
        return new TriggerCondition();
    }
}

