/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;

public class ResultProvider
implements IResultValueProvider {
    private Map<TypedResult<?>, Object> resultMap = new HashMap();
    private Map<TypedCollectionResult<?>, Collection<?>> collectionResultMap = new HashMap();

    private void addResult(TypedResult<?> result, Object instance) {
        this.resultMap.put(result, instance);
    }

    private void addCollectionResult(TypedCollectionResult<?> result, Collection<?> collection) {
        this.collectionResultMap.put(result, collection);
    }

    public void addResults(IResult result) {
        IRule rule = result.getRule();
        if (rule.getResults() != null) {
            for (TypedResult<?> typedResult : rule.getResults()) {
                Object instance = result.getResult(typedResult);
                if (instance == null) continue;
                if (typedResult instanceof TypedCollectionResult) {
                    TypedCollectionResult typedCollectionResult = (TypedCollectionResult)typedResult;
                    Collection result2 = result.getResult(typedCollectionResult);
                    this.addCollectionResult(typedCollectionResult, result2);
                    continue;
                }
                this.addResult(typedResult, result.getResult(typedResult));
            }
        }
    }

    @Override
    public <T> T getResultValue(TypedResult<T> key) {
        Object result = this.resultMap.get(key);
        if (key.getResultClass() == null) {
            return (T)result;
        }
        return key.getResultClass().cast(result);
    }

    @Override
    public TypedResult<?> getResultByIdentifier(String identifier) {
        for (TypedResult<?> typedResult : this.resultMap.keySet()) {
            if (!typedResult.getIdentifier().equals(identifier)) continue;
            return typedResult;
        }
        for (TypedCollectionResult typedCollectionResult : this.collectionResultMap.keySet()) {
            if (!typedCollectionResult.getIdentifier().equals(identifier)) continue;
            return typedCollectionResult;
        }
        return null;
    }

    @Override
    public <T> Collection<T> getResultValue(TypedCollectionResult<T> result) {
        Collection<?> collection = this.collectionResultMap.get(result);
        if (collection != null) {
            ArrayList results = new ArrayList(collection.size());
            for (Object object : collection) {
                Class resultClass = result.getResultClass();
                results.add(resultClass == null ? object : resultClass.cast(object));
            }
            return Collections.unmodifiableCollection(results);
        }
        return Collections.emptyList();
    }
}

