/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.internal.IRuleProvider;

public class RuleRegistry {
    private static final Collection<IRule> RULES;

    private static Logger getLogger() {
        return Logger.getLogger("org.openjdk.jmc.flightrecorder.rules");
    }

    private RuleRegistry() {
        throw new InstantiationError();
    }

    public static Collection<IRule> getRules() {
        return RULES;
    }

    static {
        ServiceLoader<IRule> ruleLoader = ServiceLoader.load(IRule.class, IRule.class.getClassLoader());
        HashSet<IRule> rules = new HashSet<IRule>();
        Iterator<IRule> ruleIter = ruleLoader.iterator();
        while (ruleIter.hasNext()) {
            try {
                rules.add(ruleIter.next());
            }
            catch (ServiceConfigurationError e) {
                RuleRegistry.getLogger().log(Level.WARNING, "Could not create IRule instance specified in a JSL services file", e);
            }
        }
        ServiceLoader<IRuleProvider> providerLoader = ServiceLoader.load(IRuleProvider.class, IRuleProvider.class.getClassLoader());
        Iterator<IRuleProvider> providerIter = providerLoader.iterator();
        while (providerIter.hasNext()) {
            try {
                IRuleProvider provider = providerIter.next();
                for (IRule iRule : provider.getRules()) {
                    rules.add(iRule);
                }
            }
            catch (ServiceConfigurationError e) {
                RuleRegistry.getLogger().log(Level.WARNING, "Could not create IRuleProvider instance specified in a JSL services file", e);
            }
        }
        HashMap rulesByClass = new HashMap();
        Graph g = new Graph();
        for (IRule iRule : rules) {
            g.addVertex(iRule);
            rulesByClass.put(iRule.getClass(), iRule);
        }
        for (IRule iRule : rules) {
            DependsOn[] dependencies;
            for (DependsOn dependency : dependencies = (DependsOn[])iRule.getClass().getAnnotationsByType(DependsOn.class)) {
                g.addDependency((IRule)rulesByClass.get(dependency.value()), iRule);
            }
        }
        Collection<IRule> collection = g.getTopologicalOrder();
        RULES = Collections.unmodifiableCollection(collection);
    }

    private static class Graph {
        private final Map<IRule, Vertex> vertices = new HashMap<IRule, Vertex>();

        private Graph() {
        }

        Collection<IRule> getTopologicalOrder() {
            int permanentlyMarkedVertices = 0;
            ArrayList<IRule> orderedList = new ArrayList<IRule>();
            for (Vertex vertex : this.vertices.values()) {
                if (permanentlyMarkedVertices == this.vertices.size()) {
                    return orderedList;
                }
                this.visit(vertex, orderedList);
            }
            return orderedList;
        }

        void visit(Vertex vertex, List<IRule> orderedList) {
            if (vertex.isPermanentlyMarked()) {
                return;
            }
            if (vertex.isTemporarilyMarked()) {
                throw new RuntimeException("Non-DAG IRule dependency graph detected!");
            }
            vertex.setTemporarilyMark();
            for (Vertex v : vertex.edges) {
                this.visit(v, orderedList);
            }
            vertex.resetTemporaryMark();
            vertex.setPermanentlyMark();
            orderedList.add(0, vertex.rule);
        }

        void addVertex(IRule rule) {
            this.vertices.put(rule, new Vertex(rule));
        }

        void addDependency(IRule dependee, IRule depender) {
            Vertex vertex = new Vertex(depender);
            this.vertices.put(depender, vertex);
            this.vertices.get((Object)dependee).edges.add(vertex);
        }
    }

    private static class Vertex {
        private boolean temporaryMark = false;
        private boolean permanentMark = false;
        private final IRule rule;
        private final Collection<Vertex> edges = new ArrayList<Vertex>();

        Vertex(IRule rule) {
            this.rule = rule;
        }

        boolean isTemporarilyMarked() {
            return this.temporaryMark;
        }

        boolean isPermanentlyMarked() {
            return this.permanentMark;
        }

        void setTemporarilyMark() {
            this.temporaryMark = true;
        }

        void resetTemporaryMark() {
            this.temporaryMark = false;
        }

        void setPermanentlyMark() {
            this.permanentMark = true;
        }
    }
}

