/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree.traversal;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;

public class DFIterator<T>
implements Iterator<ITreeNode<T>> {
    private Deque<ITreeNode<T>> next = new LinkedList<ITreeNode<T>>();

    public DFIterator(ITreeNode<T> node) {
        this.next.add(node);
    }

    @Override
    public boolean hasNext() {
        return !this.next.isEmpty();
    }

    @Override
    public ITreeNode<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ITreeNode<T> currentNode = this.next.pop();
        ListIterator<ITreeNode<T>> iterator = currentNode.getChildren().listIterator(currentNode.getChildren().size());
        while (iterator.hasPrevious()) {
            ITreeNode<T> child = iterator.previous();
            this.next.push(child);
        }
        return currentNode;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removals!");
    }
}

