/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.common.DurationHdrHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.misc.BackgroundFractionDrawer;
import org.openjdk.jmc.ui.misc.DelegatingLabelProvider;
import org.openjdk.jmc.ui.misc.OptimisticComparator;

public class DurationPercentileTable {
    public static final String TABLE_NAME = "DurationPercentileTable";
    private static final String COL_ID_PERCENTILE = "DurationPercentileTable.percentile";
    private static final IQuantity[] PERCENTILES = new IQuantity[]{UnitLookup.NUMBER_UNITY.quantity(0.0), UnitLookup.NUMBER_UNITY.quantity(90.0), UnitLookup.NUMBER_UNITY.quantity(99.0), UnitLookup.NUMBER_UNITY.quantity(99.9), UnitLookup.NUMBER_UNITY.quantity(99.99), UnitLookup.NUMBER_UNITY.quantity(99.999), UnitLookup.NUMBER_UNITY.quantity(100.0)};
    private final DurationPercentileAggregator[] aggregators;
    private final ColumnManager manager;

    private DurationPercentileTable(ColumnManager manager, DurationPercentileAggregator[] aggregators) {
        this.manager = manager;
        this.aggregators = aggregators;
    }

    public void update(IItemCollection itemCol) {
        DurationPercentileTableModel model = new DurationPercentileTableModel(itemCol);
        ((Stream)Arrays.stream(this.aggregators).parallel()).forEach(model::addAggregate);
        List<DurationPercentileTableRow> rows = model.buildRows();
        this.updateColumnVisibilty(rows.get(0));
        this.manager.getViewer().setInput(rows);
    }

    private void updateColumnVisibilty(DurationPercentileTableRow row) {
        this.manager.getColumnStates().forEach(c -> {
            boolean shouldShow;
            String id = c.getColumn().getId();
            if (!COL_ID_PERCENTILE.equals(id) && (shouldShow = row.hasValue(id)) != c.isVisible()) {
                this.manager.setColumnHidden(id, !shouldShow);
            }
        });
    }

    public ColumnManager getManager() {
        return this.manager;
    }

    public IItemCollection getSelectedItems() {
        IStructuredSelection selection = this.manager.getViewer().getStructuredSelection();
        Object firstSelection = selection.getFirstElement();
        if (firstSelection instanceof DurationPercentileTableRow) {
            DurationPercentileTableRow row = (DurationPercentileTableRow)firstSelection;
            return row.getItemsForRow(this.aggregators);
        }
        return null;
    }

    private static class DurationPercentileAggregator
    extends Aggregators.AggregatorBase<Map<IQuantity, Map<String, IQuantity>>, DurationHdrHistogram.DurationItemConsumer> {
        private final DurationHdrHistogram histogram = new DurationHdrHistogram();
        private final String typeId;
        private final String durationColId;
        private final String countColId;

        public DurationPercentileAggregator(String typeId, String durationColId, String countColId) {
            super(null, null, (IType)UnitLookup.UNKNOWN);
            this.typeId = typeId;
            this.durationColId = durationColId;
            this.countColId = countColId;
        }

        public boolean acceptType(IType<IItem> type) {
            return this.typeId.equals(type.getIdentifier());
        }

        public DurationHdrHistogram.DurationItemConsumer newItemConsumer(IType<IItem> itemType) {
            return new DurationHdrHistogram.DurationItemConsumer(this.histogram, (IMemberAccessor<IQuantity, IItem>)JfrAttributes.DURATION.getAccessor(itemType));
        }

        public Map<IQuantity, Map<String, IQuantity>> getValue(Iterator<DurationHdrHistogram.DurationItemConsumer> source) {
            while (source.hasNext()) {
                source.next();
            }
            HashMap<IQuantity, Map<String, IQuantity>> result = new HashMap<IQuantity, Map<String, IQuantity>>();
            IQuantity[] iQuantityArray = PERCENTILES;
            int n = PERCENTILES.length;
            int n2 = 0;
            while (n2 < n) {
                IQuantity percentile = iQuantityArray[n2];
                HashMap<String, IQuantity> colValues = new HashMap<String, IQuantity>();
                if (!this.histogram.isEmpty()) {
                    Pair<IQuantity, IQuantity> data = this.histogram.getDurationAndCountAtPercentile(percentile);
                    colValues.put(this.durationColId, (IQuantity)data.left);
                    colValues.put(this.countColId, (IQuantity)data.right);
                }
                result.put(percentile, colValues);
                ++n2;
            }
            return result;
        }

        public IQuantity getItemCount() {
            long total = this.histogram.getTotalCount();
            return UnitLookup.NUMBER_UNITY.quantity(total);
        }

        public String getDurationColId() {
            return this.durationColId;
        }

        public String getCountColId() {
            return this.countColId;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public IQuantity getLowestEquivalentDuration(IQuantity duration) {
            return this.histogram.getLowestEquivalentDuration(duration);
        }

        public void resetHistogram() {
            this.histogram.reset();
        }
    }

    public static class DurationPercentileTableBuilder {
        private final List<IColumn> columns = new ArrayList<IColumn>();
        private final List<DurationPercentileAggregator> aggregators = new ArrayList<DurationPercentileAggregator>();

        public void addSeries(String durationColId, String durationColName, String countColId, String countColName, String typeId) {
            IColumn column = new ColumnBuilder(durationColName, durationColId, (IMemberAccessor)new ValueAccessor(durationColId)).style(131072).build();
            this.columns.add(column);
            Function<DurationPercentileTableRow, IQuantity> fractionFunc = row -> row.getCountFraction(countColId);
            column = new ColumnBuilder(countColName, countColId, (IMemberAccessor)new ValueAccessor(countColId)).style(131072).columnDrawer(BackgroundFractionDrawer.unchecked(fractionFunc)).build();
            this.columns.add(column);
            DurationPercentileAggregator aggregator = new DurationPercentileAggregator(typeId, durationColId, countColId);
            this.aggregators.add(aggregator);
        }

        public DurationPercentileTable build(Composite parent, TableSettings ts) {
            TableViewer tableViewer = new TableViewer(parent, 66306);
            tableViewer.getControl().setData("name", (Object)DurationPercentileTable.TABLE_NAME);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            if (UIPlugin.getDefault().getAccessibilityMode()) {
                FocusTracker.enableFocusTracking((Composite)tableViewer.getTable());
            }
            ArrayList<IColumn> columns = new ArrayList<IColumn>();
            ItemHistogram.KeyLabelProvider keyLP = new ItemHistogram.KeyLabelProvider((ContentType<?>)UnitLookup.NUMBER);
            PercentileAccessor cellAccessor = new PercentileAccessor();
            OptimisticComparator comp = new OptimisticComparator((IMemberAccessor)cellAccessor, (ILabelProvider)keyLP);
            columns.add(new ColumnBuilder(Messages.DurationPercentileTable_PERCENTILE_COL_NAME, DurationPercentileTable.COL_ID_PERCENTILE, (ColumnLabelProvider)new DelegatingLabelProvider((ColumnLabelProvider)keyLP, (IMemberAccessor)cellAccessor)).comparator((Comparator)comp).build());
            columns.addAll(this.columns);
            ColumnManager manager = ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)ts);
            DurationPercentileAggregator[] aggregatorsCopy = this.aggregators.toArray(new DurationPercentileAggregator[this.aggregators.size()]);
            return new DurationPercentileTable(manager, aggregatorsCopy);
        }
    }

    private static class DurationPercentileTableModel {
        private final IItemCollection items;
        private final Map<IQuantity, Map<String, IQuantity>> valuesByPercentile;
        private final Map<String, IQuantity> itemTotals;

        public DurationPercentileTableModel(IItemCollection items) {
            this.items = items;
            this.valuesByPercentile = new ConcurrentHashMap<IQuantity, Map<String, IQuantity>>();
            this.itemTotals = new ConcurrentHashMap<String, IQuantity>();
        }

        public void addAggregate(DurationPercentileAggregator aggregator) {
            aggregator.resetHistogram();
            Map newData = (Map)this.items.getAggregate((IAggregator)aggregator);
            this.addData(newData);
            String countCol = aggregator.getCountColId();
            IQuantity itemCount = aggregator.getItemCount();
            this.itemTotals.put(countCol, itemCount);
        }

        private void addData(Map<IQuantity, Map<String, IQuantity>> newValues) {
            newValues.forEach((key, val) -> {
                Map map = this.valuesByPercentile.merge((IQuantity)key, (Map<String, IQuantity>)val, (oldVal, newVal) -> {
                    oldVal.putAll(newVal);
                    return oldVal;
                });
            });
        }

        public List<DurationPercentileTableRow> buildRows() {
            ArrayList<DurationPercentileTableRow> rows = new ArrayList<DurationPercentileTableRow>();
            IQuantity[] iQuantityArray = PERCENTILES;
            int n = PERCENTILES.length;
            int n2 = 0;
            while (n2 < n) {
                IQuantity percentile = iQuantityArray[n2];
                DurationPercentileTableRow row = new DurationPercentileTableRow(percentile, this.valuesByPercentile.get(percentile), this.itemTotals, this.items);
                rows.add(row);
                ++n2;
            }
            return rows;
        }
    }

    private static class DurationPercentileTableRow {
        private final IQuantity percentile;
        private final Map<String, IQuantity> valuesByColId;
        private final Map<String, IQuantity> totalsById;
        private final IItemCollection items;

        public DurationPercentileTableRow(IQuantity percentile, Map<String, IQuantity> values, Map<String, IQuantity> totals, IItemCollection items) {
            this.percentile = percentile;
            this.valuesByColId = values;
            this.totalsById = totals;
            this.items = items;
        }

        public IQuantity getPercentile() {
            return this.percentile;
        }

        public IQuantity getValue(String columnId) {
            return this.valuesByColId.get(columnId);
        }

        public boolean hasValue(String columnId) {
            return this.valuesByColId.containsKey(columnId);
        }

        public IQuantity getCountFraction(String columnId) {
            IQuantity count = this.valuesByColId.get(columnId);
            IQuantity total = this.totalsById.get(columnId);
            double fraction = 0.0;
            if (count != null && total != null && total.longValue() > 0L) {
                fraction = count.doubleValue() / total.doubleValue();
            }
            return UnitLookup.NUMBER_UNITY.quantity(fraction);
        }

        public IItemCollection getItemsForRow(DurationPercentileAggregator[] aggregators) {
            IItemFilter filter = ((Stream)Arrays.stream(aggregators).parallel()).filter(a -> this.hasValue(a.getDurationColId())).map(a -> ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)a.getTypeId()), ItemFilters.moreOrEqual((ICanonicalAccessorFactory)JfrAttributes.DURATION, (Comparable)a.getLowestEquivalentDuration(this.getValue(a.getDurationColId())))})).reduce((iItemFilter, iItemFilter2) -> ItemFilters.or((IItemFilter[])new IItemFilter[]{iItemFilter, iItemFilter2})).orElse(ItemFilters.none());
            return this.items.apply(filter);
        }
    }

    private static class PercentileAccessor
    implements IMemberAccessor<IQuantity, Object> {
        private PercentileAccessor() {
        }

        public IQuantity getMember(Object inObject) {
            if (inObject instanceof DurationPercentileTableRow) {
                return ((DurationPercentileTableRow)inObject).getPercentile();
            }
            return null;
        }
    }

    private static class ValueAccessor
    implements IMemberAccessor<IQuantity, DurationPercentileTableRow> {
        private final String columnId;

        public ValueAccessor(String columnId) {
            this.columnId = columnId;
        }

        public IQuantity getMember(DurationPercentileTableRow inObject) {
            return inObject.getValue(this.columnId);
        }
    }
}

