/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.overview;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.HtmlResultGroup;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.HtmlResultProvider;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.RulesHtmlToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.JfrEditor;
import org.openjdk.jmc.flightrecorder.ui.overview.ResultOverview;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class ResultReportUi {
    private static final String OVERVIEW_MAKE_SCALABLE = "overview.makeScalable();";
    private static final String OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY = "overview.updatePageHeadersVisibility();";
    private static final Pattern HTML_ANCHOR_PATTERN = Pattern.compile("<a href=\"(.*?)\">(.*?)</a>");
    private static final String OPEN_BROWSER_WINDOW = "openWindowByUrl";
    private final HashMap<String, Boolean> resultExpandedStates = new HashMap();
    private Boolean showOk = false;
    private Boolean showIgnore = false;
    private Boolean isLoaded = false;
    private Browser browser;
    private IPageContainer editor;
    private Collection<HtmlResultGroup> descriptors;
    private boolean isSinglePage = false;
    private ConcurrentLinkedQueue<String> commandQueue = new ConcurrentLinkedQueue();
    private Collection<String> topics = RulesToolkit.getAllTopics();
    private Collection<IResult> results;
    private Runnable cmdExecRunnable = () -> {
        if (this.browser.isDisposed()) {
            return;
        }
        if (!this.isLoaded.booleanValue()) {
            throw new RuntimeException("Document not yet ready");
        }
        try {
            String cmd = this.commandQueue.poll();
            while (cmd != null) {
                this.browser.evaluate(cmd);
                cmd = this.commandQueue.poll();
            }
            this.browser.evaluate(OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY);
        }
        catch (IllegalArgumentException | SWTException e) {
            try {
                FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Could not update single result, redrawing html view. " + e.getMessage());
                String html = this.isSinglePage ? RulesHtmlToolkit.generateSinglePageHtml(this.results) : RulesHtmlToolkit.generateStructuredHtml((HtmlResultProvider)new PageContainerResultProvider(this.editor), this.descriptors, this.resultExpandedStates, (boolean)false);
                String adjustedHtml = ResultReportUi.adjustAnchorFollowAction(html);
                this.browser.setText(adjustedHtml);
            }
            catch (IOException e1) {
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not update Result Overview", e1);
            }
        }
    };

    private void openBrowserByUrl(String url, String title) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setText(title);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        this.initializeBrowser(display, browser, shell);
        shell.open();
        browser.setUrl(url);
    }

    private void initializeBrowser(final Display display, final Browser browser, final Shell shell) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                ResultReportUi.this.initializeBrowser(display, browser, shell);
                event.browser = browser;
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }

    private static String adjustAnchorFollowAction(String html) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = HTML_ANCHOR_PATTERN.matcher(html);
        while (m.find()) {
            map.put(m.group(1), m.group(2));
        }
        for (Map.Entry e : map.entrySet()) {
            html = html.replace((CharSequence)e.getKey(), ResultReportUi.openWindowMethod((String)e.getKey(), (String)e.getValue()));
        }
        return html;
    }

    private static String openWindowMethod(String url, String name) {
        return "#\" onclick=\"" + OPEN_BROWSER_WINDOW + "(" + "'" + url + "'" + ',' + "'" + name + "'" + ");return false;";
    }

    public ResultReportUi(boolean isSinglePage) {
        this.isSinglePage = isSinglePage;
    }

    public List<String> getHtml(IPageContainer editor) {
        ArrayList<String> overviewHtml = new ArrayList<String>(1);
        String adjustedHtml = ResultReportUi.adjustAnchorFollowAction(RulesHtmlToolkit.generateStructuredHtml((HtmlResultProvider)new PageContainerResultProvider(editor), this.descriptors, this.resultExpandedStates, (boolean)true));
        overviewHtml.add(adjustedHtml);
        return overviewHtml;
    }

    public void setShowOk(boolean showOk) {
        this.showOk = showOk;
        if (!this.isSinglePage) {
            try {
                this.browser.evaluate(String.format("overview.showOk(%b);", showOk));
                boolean allOk = this.editor.getRuleManager().getMaxSeverity(this.topics.toArray(new String[this.topics.size()])) == Severity.OK;
                this.browser.evaluate(String.format("overview.allOk(%b);", allOk));
            }
            catch (SWTException sWTException) {
                String html = RulesHtmlToolkit.generateStructuredHtml((HtmlResultProvider)new PageContainerResultProvider(this.editor), this.descriptors, this.resultExpandedStates, (boolean)false);
                String adjustedHtml = ResultReportUi.adjustAnchorFollowAction(html);
                this.browser.setText(adjustedHtml);
            }
        }
    }

    public void setShowIgnore(boolean showIgnore) {
        this.showIgnore = showIgnore;
        if (!this.isSinglePage) {
            try {
                this.browser.evaluate(String.format("overview.showIgnore(%b);", showIgnore));
            }
            catch (SWTException sWTException) {
                String html = RulesHtmlToolkit.generateStructuredHtml((HtmlResultProvider)new PageContainerResultProvider(this.editor), this.descriptors, this.resultExpandedStates, (boolean)false);
                String adjustedHtml = ResultReportUi.adjustAnchorFollowAction(html);
                this.browser.setText(adjustedHtml);
            }
        }
    }

    boolean getShowOk() {
        return this.showOk;
    }

    boolean getShowIgnore() {
        return this.showIgnore;
    }

    public void updateRule(IRule rule) {
        StringBuilder script = new StringBuilder();
        IResult result = this.editor.getRuleManager().getResult(rule);
        if (result == null) {
            return;
        }
        IQuantity score = (IQuantity)result.getResult(TypedResult.SCORE);
        String adjustedHtml = ResultReportUi.adjustAnchorFollowAction(RulesHtmlToolkit.getDescription((IResult)result));
        String quoteEscape = adjustedHtml.replaceAll("\\\"", "\\\\\"");
        String description = quoteEscape.replaceAll("\n", "</br>");
        script.append(String.format("overview.updateResult(\"%s\", %d, \"%s\");", result.getRule().getId(), Math.round(score == null ? result.getSeverity().getLimit() : score.doubleValue()), description));
        String[] topicsArray = this.topics.toArray(new String[this.topics.size()]);
        if (!this.isSinglePage) {
            boolean allOk = this.editor.getRuleManager().getMaxSeverity(topicsArray) == Severity.OK;
            script.append(String.format("overview.allOk(%b);", allOk));
        }
        this.commandQueue.add(script.toString());
        if (!this.isLoaded.booleanValue()) {
            return;
        }
        DisplayToolkit.safeAsyncExec((Runnable)this.cmdExecRunnable);
    }

    public void setResults(Collection<IResult> results) {
        this.results = results;
    }

    public boolean createHtmlOverview(final Browser browser, final IPageContainer editor, IState state) {
        this.browser = browser;
        this.editor = editor;
        this.descriptors = PageDescriptorResultGroup.build(FlightRecorderUI.getDefault().getPageManager().getRootPages());
        try {
            this.showOk = Boolean.valueOf(state.getChild("report").getChild("showOk").getAttribute("value"));
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.showIgnore = Boolean.valueOf(state.getChild("report").getChild("showIgnore").getAttribute("value"));
        }
        catch (NullPointerException nullPointerException) {}
        browser.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        try {
            String html = this.isSinglePage ? RulesHtmlToolkit.generateSinglePageHtml(this.results) : RulesHtmlToolkit.generateStructuredHtml((HtmlResultProvider)new PageContainerResultProvider(editor), this.descriptors, this.resultExpandedStates, (boolean)false);
            String adjustedHtml = ResultReportUi.adjustAnchorFollowAction(html);
            browser.setText(adjustedHtml, true);
            browser.setJavascriptEnabled(true);
            browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    new OpenWindowFunction(browser, ResultReportUi.OPEN_BROWSER_WINDOW);
                    new Linker(browser, "linker", ResultReportUi.this.descriptors, editor);
                    new Expander(browser, "expander");
                    browser.execute(String.format("overview.showOk(%b);", ResultReportUi.this.showOk));
                    browser.execute(String.format("overview.showIgnore(%b);", ResultReportUi.this.showIgnore));
                    if (ResultReportUi.this.isSinglePage) {
                        browser.execute(ResultReportUi.OVERVIEW_MAKE_SCALABLE);
                    }
                    if (!browser.getUrl().equals("about:blank")) {
                        ((ResultOverview)((JfrEditor)editor).getCurrentPageUI()).enableBrowserAction();
                        return;
                    }
                    browser.evaluate(ResultReportUi.OVERVIEW_UPDATE_PAGE_HEADERS_VISIBILITY);
                    ResultReportUi.this.isLoaded = true;
                    DisplayToolkit.safeAsyncExec((Runnable)ResultReportUi.this.cmdExecRunnable);
                }
            });
        }
        catch (IOException | IllegalArgumentException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not create Report Overview", e);
            return false;
        }
        return true;
    }

    public void saveTo(IWritableState state) {
        state.createChild("report").createChild("showOk").putString("value", this.showOk.toString());
        state.createChild("report").createChild("showIgnore").putString("value", this.showIgnore.toString());
    }

    private class Expander
    extends BrowserFunction {
        public Expander(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            ResultReportUi.this.resultExpandedStates.put(arguments[0].toString(), (Boolean)arguments[1]);
            return null;
        }
    }

    private static class Linker
    extends BrowserFunction {
        private Iterable<HtmlResultGroup> resultGroups;
        private IPageContainer editor;

        public Linker(Browser browser, String name, Iterable<HtmlResultGroup> resultGroups, IPageContainer editor) {
            super(browser, name);
            this.resultGroups = resultGroups;
            this.editor = editor;
        }

        public Object function(Object[] arguments) {
            if (arguments.length != 1 && !(arguments[0] instanceof String)) {
                return null;
            }
            String id = arguments[0].toString();
            for (HtmlResultGroup group : this.resultGroups) {
                if (group instanceof PageDescriptorResultGroup && id.equals(group.getId())) {
                    this.editor.navigateTo(((PageDescriptorResultGroup)group).getDescriptor());
                    return null;
                }
                if (!this.hasPageAsChild(group, id)) continue;
                return null;
            }
            return null;
        }

        private boolean hasPageAsChild(HtmlResultGroup parent, String id) {
            if (parent instanceof PageDescriptorResultGroup && id.equals(parent.getId())) {
                this.editor.navigateTo(((PageDescriptorResultGroup)parent).getDescriptor());
                return true;
            }
            if (!parent.hasChildren()) {
                return false;
            }
            for (HtmlResultGroup child : parent.getChildren()) {
                if (!this.hasPageAsChild(child, id)) continue;
                return true;
            }
            return false;
        }
    }

    public class OpenWindowFunction
    extends BrowserFunction {
        public OpenWindowFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            String url = String.valueOf(arguments[0]);
            String title = String.valueOf(arguments[1]);
            ResultReportUi.this.openBrowserByUrl(url, title);
            return null;
        }
    }

    private static class PageContainerResultProvider
    implements HtmlResultProvider {
        private IPageContainer editor;

        public PageContainerResultProvider(IPageContainer editor) {
            this.editor = editor;
        }

        public Collection<IResult> getResults(Collection<String> topics) {
            return this.editor.getRuleManager().getResults(topics);
        }
    }

    private static class PageDescriptorResultGroup
    implements HtmlResultGroup {
        private DataPageDescriptor descriptor;
        private List<HtmlResultGroup> children;

        public PageDescriptorResultGroup(DataPageDescriptor descriptor) {
            this.descriptor = descriptor;
            this.children = new ArrayList<HtmlResultGroup>();
            DataPageDescriptor[] dataPageDescriptorArray = descriptor.getChildren();
            int n = dataPageDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataPageDescriptor dpdChild = dataPageDescriptorArray[n2];
                this.children.add(new PageDescriptorResultGroup(dpdChild));
                ++n2;
            }
        }

        public List<HtmlResultGroup> getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public Collection<String> getTopics() {
            return Stream.of(this.descriptor.getTopics()).collect(Collectors.toList());
        }

        public String getId() {
            return Integer.toString(this.descriptor.hashCode());
        }

        public String getName() {
            return this.descriptor.getName();
        }

        public String getImage() {
            ImageDescriptor image = this.descriptor.getImageDescriptor();
            if (image == null) {
                return null;
            }
            ImageLoader loader = new ImageLoader();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            loader.data = new ImageData[]{image.getImageData(100)};
            loader.save((OutputStream)out, 5);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }

        public DataPageDescriptor getDescriptor() {
            return this.descriptor;
        }

        public static Collection<HtmlResultGroup> build(Collection<DataPageDescriptor> descriptors) {
            return descriptors.stream().map(dpd -> new PageDescriptorResultGroup((DataPageDescriptor)dpd)).collect(Collectors.toList());
        }
    }
}

