/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.ThreadGraphLanes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.QuantitySpanRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;

public class ThreadsPageLegacy
extends AbstractDataPage {
    private static final String THREAD_START_COL = "threadStart";
    private static final String THREAD_END_COL = "threadEnd";
    private static final String THREAD_DURATION_COL = "threadDuration";
    private static final String THREAD_LANE = "threadLane";
    private static final IItemFilter pageFilter = ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD);
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private FlavorSelector.FlavorSelectorState flavorSelectorState;
    private ColumnManager.SelectionState histogramSelectionState;
    private IItemFilter tableFilter;
    private IRange<IQuantity> visibleRange;

    static {
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_GROUP_NAME);
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_ID);
        HISTOGRAM.addColumn(THREAD_START_COL, Aggregators.min((String)Messages.JavaApplicationPage_COLUMN_THREAD_START, (String)Messages.JavaApplicationPage_COLUMN_THREAD_START_DESC, (String)"jdk.ThreadStart", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_END_COL, Aggregators.max((String)Messages.JavaApplicationPage_COLUMN_THREAD_END, (String)Messages.JavaApplicationPage_COLUMN_THREAD_END_DESC, (String)"jdk.ThreadEnd", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_DURATION_COL, ic -> {
            IQuantity threadStart = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadStart")).getAggregate(Aggregators.min((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            IQuantity threadEnd = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadEnd")).getAggregate(Aggregators.max((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            if (threadStart != null && threadEnd != null) {
                return threadEnd.subtract(threadStart);
            }
            return null;
        }, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION_DESC);
    }

    public ThreadsPageLegacy(IPageDefinition definition, StreamModel model, IPageContainer editor) {
        super(definition, model, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new ThreadsPageUi(parent, toolkit, editor, state);
    }

    public static class ThreadsPageLegacyFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ThreadsPage_NAME_LEGACY;
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"threads"};
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/threadgraph.png");
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition definition, StreamModel items, IPageContainer editor) {
            return new ThreadsPageLegacy(definition, items, editor);
        }
    }

    private class ThreadsPageUi
    extends ChartAndTableUI {
        private static final String THREADS_TABLE_FILTER = "threadsTableFilter";
        private static final String HIDE_THREAD = "hideThread";
        private static final String RESET_CHART = "resetChart";
        private Boolean isChartMenuActionsInit;
        private Boolean isChartModified;
        private Boolean reloadThreads;
        private IAction hideThreadAction;
        private IAction resetChartAction;
        private List<IXDataRenderer> threadRows;
        private MCContextMenuManager mm;
        private ThreadGraphLanes lanes;

        ThreadsPageUi(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
            super(pageFilter, ThreadsPageLegacy.this.getDataSource(), parent, toolkit, editor, state, ThreadsPageLegacy.this.getName(), pageFilter, ThreadsPageLegacy.this.getIcon(), ThreadsPageLegacy.this.flavorSelectorState, JfrAttributes.EVENT_THREAD);
            this.mm = (MCContextMenuManager)this.chartCanvas.getContextMenu();
            this.sash.setOrientation(256);
            this.addActionsToContextMenu(this.mm);
            this.lanes.updateContextMenu(this.mm, false);
            this.form.getToolBarManager().add(ActionToolkit.action(() -> this.lanes.openEditLanesDialog(this.mm, false), (String)Messages.ThreadsPage_EDIT_LANES, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif")));
            this.form.getToolBarManager().update(true);
            this.chartLegend.getControl().dispose();
            this.buildChart();
            this.table.getManager().setSelectionState(ThreadsPageLegacy.this.histogramSelectionState);
            this.tableFilterComponent.loadState(state.getChild(THREADS_TABLE_FILTER));
            this.chart.setVisibleRange((IQuantity)ThreadsPageLegacy.this.visibleRange.getStart(), (IQuantity)ThreadsPageLegacy.this.visibleRange.getEnd());
            this.onFilterChange(ThreadsPageLegacy.this.tableFilter);
        }

        private void hideThread(Object thread) {
            if (this.threadRows != null && this.threadRows.size() > 0 && thread instanceof IMCThread) {
                int index = this.indexOfThread(thread);
                if (index != -1) {
                    this.threadRows.remove(index);
                    this.reloadThreads = false;
                    this.buildChart();
                    if (!this.isChartModified.booleanValue()) {
                        this.isChartModified = true;
                        this.setResetChartActionEnablement(true);
                    }
                }
                if (this.threadRows.size() == 0) {
                    this.setHideThreadActionEnablement(false);
                }
            }
        }

        private int indexOfThread(Object thread) {
            int i = 0;
            while (i < this.threadRows.size() && thread != null) {
                if (this.threadRows.get(i) instanceof QuantitySpanRenderer && thread.equals(((QuantitySpanRenderer)this.threadRows.get(i)).getData())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void addActionsToContextMenu(MCContextMenuManager mm) {
            mm.add((IContributionItem)new Separator());
            IAction hideThreadAction = ActionToolkit.action(() -> this.hideThread(this.chartCanvas.getHoveredItemData()), (String)Messages.ThreadsPage_HIDE_THREAD_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("delete-16.png"));
            hideThreadAction.setId(HIDE_THREAD);
            this.hideThreadAction = hideThreadAction;
            mm.add(hideThreadAction);
            IAction resetChartAction = ActionToolkit.action(() -> this.resetChartToSelection(), (String)Messages.ThreadsPage_RESET_CHART_TO_SELECTION_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
            resetChartAction.setId(RESET_CHART);
            resetChartAction.setEnabled(this.isChartModified.booleanValue());
            this.resetChartAction = resetChartAction;
            mm.add(resetChartAction);
            this.isChartMenuActionsInit = true;
        }

        private void resetChartToSelection() {
            this.buildChart();
            this.isChartModified = false;
            this.setResetChartActionEnablement(false);
            this.setHideThreadActionEnablement(true);
        }

        private void setHideThreadActionEnablement(Boolean enabled) {
            this.hideThreadAction.setEnabled(enabled.booleanValue());
        }

        private void setResetChartActionEnablement(Boolean enabled) {
            this.resetChartAction.setEnabled(enabled.booleanValue());
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state, IAttribute<?> classifier) {
            ItemHistogram build = HISTOGRAM.buildWithoutBorder(parent, classifier, TableSettings.forState((IState)state));
            return build;
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection tableSelection) {
            boolean useDefaultSelection;
            ItemHistogram.HistogramSelection selection;
            IItemCollection selectedItems;
            List<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            if (tableSelection.getRowCount() == 0) {
                selectedItems = itemsInTable;
                selection = this.table.getAllRows();
            } else {
                selectedItems = tableSelection.getItems();
                selection = tableSelection;
            }
            boolean bl = useDefaultSelection = rows.size() > 1;
            if (this.lanes.getLaneDefinitions().stream().anyMatch(a -> a.isEnabled()) && selection.getRowCount() > 0) {
                if (this.reloadThreads.booleanValue()) {
                    this.threadRows = selection.getSelectedRows((object, items) -> this.lanes.buildThreadRenderer(object, (IItemCollection)items)).collect(Collectors.toList());
                    this.isChartModified = false;
                    if (this.isChartMenuActionsInit.booleanValue()) {
                        this.setResetChartActionEnablement(false);
                        this.setHideThreadActionEnablement(true);
                    }
                } else {
                    this.reloadThreads = true;
                }
                double threadsWeight = Math.sqrt(this.threadRows.size()) * 0.15;
                double otherRowWeight = Math.max(threadsWeight * 0.1, (1.0 - threadsWeight) / (double)rows.size());
                List weights = Stream.concat(Stream.generate(() -> otherRowWeight).limit(rows.size()), Stream.of(Double.valueOf(threadsWeight))).collect(Collectors.toList());
                rows.add(RendererToolkit.uniformRows(this.threadRows));
                useDefaultSelection = true;
                rows = Arrays.asList(RendererToolkit.weightedRows(rows, weights));
            }
            IXDataRenderer root = rows.size() == 1 ? (IXDataRenderer)rows.get(0) : RendererToolkit.uniformRows(rows);
            return useDefaultSelection ? new ItemRow(root, selectedItems.apply(this.lanes.getEnabledLanesFilter())) : root;
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            ThreadsPageLegacy.this.tableFilter = filter;
        }

        @Override
        public void saveTo(IWritableState state) {
            super.saveTo(state);
            this.tableFilterComponent.saveState(state.createChild(THREADS_TABLE_FILTER));
            this.lanes.saveTo(state);
            this.saveToLocal();
        }

        private void saveToLocal() {
            ThreadsPageLegacy.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
            ThreadsPageLegacy.this.histogramSelectionState = this.table.getManager().getSelectionState();
            ThreadsPageLegacy.this.visibleRange = this.chart.getVisibleRange();
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.isChartMenuActionsInit = false;
            this.isChartModified = false;
            this.reloadThreads = true;
            this.lanes = new ThreadGraphLanes(() -> ThreadsPageLegacy.this.getDataSource(), () -> this.buildChart());
            return this.lanes.initializeChartConfiguration(Stream.of(state.getChildren(ThreadsPageLegacy.THREAD_LANE)));
        }
    }
}

