/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.BucketBuilder;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.XYDataRenderer;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.misc.CompositeToolkit;

public class TlabPage
extends AbstractDataPage {
    private static final Color INSIDE_COLOR = new Color(0, 182, 0);
    private static final Color OUTSIDE_COLOR = new Color(164, 64, 255, 128);
    private static final IItemFilter TLAB_EVENTS = JdkFilters.ALLOC_ALL;
    private static final String INSIDE_SIZE = "insideSize";
    private static final String OUTSIDE_SIZE = "outsideSize";
    private static final String INSIDE_COUNT_COL = "insideCount";
    private static final String OUTSIDE_COUNT_COL = "outsideCount";
    private static final String AVERAGE_INSIDE_SIZE_COL = "averageInsideSize";
    private static final String AVERAGE_OUTSIDE_SIZE_COL = "averageOutsideSize";
    private static final String TOTAL_INSIDE_SIZE_COL = "totalInsideSize";
    private static final String TOTAL_INSIDE_SIZE_PERCENT_COL = "totalInsideSizePercent";
    private static final String TOTAL_OUTSIDE_SIZE_COL = "totalOutsideSize";
    private static final String TOTAL_OUTSIDE_SIZE_PERCENT_COL = "totalOutsideSizePercent";
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IRange<IQuantity> visibleRange;
    private IItemFilter tableFilter;
    private ColumnManager.SelectionState tableState;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addColumn(INSIDE_COUNT_COL, JdkAggregators.INSIDE_TLAB_COUNT);
        HISTOGRAM.addColumn(OUTSIDE_COUNT_COL, JdkAggregators.OUTSIDE_TLAB_COUNT);
        HISTOGRAM.addColumn(AVERAGE_INSIDE_SIZE_COL, JdkAggregators.ALLOC_INSIDE_TLAB_AVG);
        HISTOGRAM.addColumn(AVERAGE_OUTSIDE_SIZE_COL, JdkAggregators.ALLOC_OUTSIDE_TLAB_AVG);
        HISTOGRAM.addColumn(TOTAL_INSIDE_SIZE_COL, JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
        HISTOGRAM.addPercentageColumn(TOTAL_INSIDE_SIZE_PERCENT_COL, JdkAggregators.ALLOC_INSIDE_TLAB_SUM, Messages.TlabPage_INSIDE_TLAB_SUM_PERCENTAGE, Messages.TlabPage_INSIDE_TLAB_SUM_PERCENTAGE_DESC);
        HISTOGRAM.addColumn(TOTAL_OUTSIDE_SIZE_COL, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
        HISTOGRAM.addPercentageColumn(TOTAL_OUTSIDE_SIZE_PERCENT_COL, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, Messages.TlabPage_OUTSIDE_TLAB_SUM_PERCENTAGE, Messages.TlabPage_OUTSIDE_TLAB_SUM_PERCENTAGE_DESC);
    }

    private static String selectionCount(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " (" + Messages.TlabPage_SELECTED_ONE + ")";
            }
        }
        return " (" + NLS.bind((String)Messages.TlabPage_SELECTED_MANY, (Object)count) + ")";
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new TlabUI(parent, toolkit, editor, state);
    }

    public TlabPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    private class TlabChartTable
    extends ChartAndTableUI {
        private static final String TLAB_TABLE_FILTER = "tlabTableFilter";
        private IAction insideSizeAction;
        private IAction outsideSizeAction;

        TlabChartTable(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state, IAttribute<?> classifier) {
            super(TLAB_EVENTS, TlabPage.this.getDataSource(), parent, toolkit, pageContainer, state, TlabPage.this.getName(), TlabPage.this.tableFilter, TlabPage.this.getIcon(), TlabPage.this.flavorSelectorState, classifier);
            TlabPage.this.addResultActions(this.form);
            this.tableFilterComponent.loadState(state.getChild(TLAB_TABLE_FILTER));
            this.chart.setVisibleRange((IQuantity)TlabPage.this.visibleRange.getStart(), (IQuantity)TlabPage.this.visibleRange.getEnd());
            this.chart.addVisibleRangeListener(r -> {
                IRange iRange = TlabPage.this.visibleRange = r;
            });
            this.table.getManager().setSelectionState(TlabPage.this.tableState);
        }

        @Override
        public void saveTo(IWritableState state) {
            super.saveTo(state);
            this.tableFilterComponent.saveState(state.createChild(TLAB_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            TlabPage.this.tableState = this.table.getManager().getSelectionState();
            TlabPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state, IAttribute<?> classifier) {
            return HISTOGRAM.buildWithoutBorder(parent, classifier, TableSettings.forState((IState)state));
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection selection) {
            IItemCollection selectedItems = selection.getRowCount() == 0 ? itemsInTable : selection.getItems();
            String selectionCount = TlabPage.selectionCount(selection.getRowCount());
            IItemCollection filter = selectedItems.apply(JdkFilters.ALLOC_ALL);
            XYDataRenderer renderer = new XYDataRenderer((IQuantity)UnitLookup.MEMORY.getDefaultUnit().quantity(0L), Messages.TlabPage_ROW_TLAB_ALLOCATIONS, Messages.TlabPage_ROW_TLAB_ALLOCATIONS_DESC);
            if (this.insideSizeAction.isChecked()) {
                renderer.addBarChart(JdkAggregators.ALLOC_INSIDE_TLAB_SUM.getName(), BucketBuilder.aggregatorSeries(filter, JdkAggregators.ALLOC_INSIDE_TLAB_SUM, (IAttribute<IQuantity>)JfrAttributes.END_TIME), AWTChartToolkit.staticColor((Color)INSIDE_COLOR));
            }
            if (this.outsideSizeAction.isChecked()) {
                renderer.addBarChart(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM.getName(), BucketBuilder.aggregatorSeries(filter, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, (IAttribute<IQuantity>)JfrAttributes.END_TIME), AWTChartToolkit.staticColor((Color)OUTSIDE_COLOR));
            }
            return new ItemRow(Messages.TlabPage_ROW_TLAB_ALLOCATIONS + selectionCount, null, (IXDataRenderer)renderer, filter);
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            TlabPage.this.tableFilter = filter;
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.insideSizeAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOC_INSIDE_TLAB_SUM, TlabPage.INSIDE_SIZE, INSIDE_COLOR, b -> this.buildChart());
            this.outsideSizeAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, TlabPage.OUTSIDE_SIZE, OUTSIDE_COLOR, b -> this.buildChart());
            return Arrays.asList(this.insideSizeAction, this.outsideSizeAction);
        }
    }

    public static class TlabPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.TlabPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/allocations.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"tlab"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new TlabPage(dpd, items, editor);
        }
    }

    private class TlabSummaryUI
    implements IPageUI {
        protected Form form;

        TlabSummaryUI(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.display(parent, toolkit, pageContainer, state);
        }

        public void display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.form = DataPageToolkit.createForm(parent, toolkit, TlabPage.this.getName(), TlabPage.this.getIcon());
            SashForm container = new SashForm(this.form.getBody(), 256);
            container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
            Section insideSummarySection = CompositeToolkit.createSection((Composite)container, (FormToolkit)toolkit, (String)Messages.TlabPage_SUMMARY_TAB_INSIDE_ALLOCATION);
            ItemAggregateViewer insideSummary = new ItemAggregateViewer((Composite)insideSummarySection, toolkit);
            insideSummary.addAggregate(JdkAggregators.INSIDE_TLAB_COUNT);
            insideSummary.addAggregate(JdkAggregators.ALLOC_INSIDE_TLAB_MAX);
            insideSummary.addAggregate(JdkAggregators.ALLOC_INSIDE_TLAB_MIN);
            insideSummary.addAggregate(JdkAggregators.ALLOC_TLAB_AVG);
            insideSummary.addAggregate(JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
            insideSummarySection.setClient(insideSummary.getControl());
            Section outsideSummarySection = CompositeToolkit.createSection((Composite)container, (FormToolkit)toolkit, (String)Messages.TlabPage_SUMMARY_TAB_OUTSIDE_ALLOCATION);
            ItemAggregateViewer outsideSummary = new ItemAggregateViewer((Composite)outsideSummarySection, toolkit);
            outsideSummary.addAggregate(JdkAggregators.OUTSIDE_TLAB_COUNT);
            outsideSummary.addAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_MAX);
            outsideSummary.addAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_MIN);
            outsideSummary.addAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_AVG);
            outsideSummary.addAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
            outsideSummarySection.setClient(outsideSummary.getControl());
            insideSummary.setValues(TlabPage.this.getDataSource().getItems());
            outsideSummary.setValues(TlabPage.this.getDataSource().getItems());
            TlabPage.this.addResultActions(this.form);
        }

        public Form getComponent() {
            return this.form;
        }

        public void saveTo(IWritableState state) {
        }
    }

    private class TlabUI
    implements IPageUI {
        private CTabFolder tabFolder;
        private TlabChartTable threadsCT;
        private TlabChartTable methodsCT;
        private TlabChartTable classCT;
        private TlabSummaryUI summaryCT;
        private int tabFolderIndex = 0;

        public TlabUI(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
            this.tabFolder = new CTabFolder(parent, 1024);
            this.threadsCT = new TlabChartTable((Composite)this.tabFolder, toolkit, editor, state, JfrAttributes.EVENT_THREAD);
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.threadsCT.getComponent(), Messages.TlabPage_THREADS_TAB_NAME);
            this.methodsCT = new TlabChartTable((Composite)this.tabFolder, toolkit, editor, state, JdkAttributes.STACK_TRACE_TOP_METHOD);
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.methodsCT.getComponent(), Messages.TlabPage_METHODS_TAB_NAME);
            this.classCT = new TlabChartTable((Composite)this.tabFolder, toolkit, editor, state, JdkAttributes.ALLOCATION_CLASS);
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.classCT.getComponent(), Messages.TlabPage_CLASS_TAB_NAME);
            this.summaryCT = new TlabSummaryUI((Composite)this.tabFolder, toolkit, editor, state);
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.summaryCT.getComponent(), Messages.TlabPage_SUMMARY_TAB_NAME);
            this.tabFolder.setSelection(this.tabFolderIndex);
        }

        public void saveTo(IWritableState state) {
            this.threadsCT.saveTo(state);
            this.methodsCT.saveTo(state);
            this.classCT.saveTo(state);
            this.summaryCT.saveTo(state);
            this.saveToLocal();
        }

        private void saveToLocal() {
            this.tabFolderIndex = this.tabFolder.getSelectionIndex();
        }
    }
}

