/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jolokia.server.core.service.api.AgentDetails;
import org.json.simple.JSONObject;

abstract class AbstractDiscoveryMessage {
    public static final int MAX_MSG_SIZE = 8972;
    protected static final String MESSAGE_TYPE = "type";
    private MessageType type;
    private AgentDetails agentDetails;

    AbstractDiscoveryMessage() {
    }

    protected final void setType(MessageType pType) {
        this.type = pType;
    }

    protected final void setAgentDetails(AgentDetails pAgentDetails) {
        this.agentDetails = pAgentDetails;
    }

    public boolean isQuery() {
        return this.type == MessageType.QUERY;
    }

    public boolean isResponse() {
        return this.type == MessageType.RESPONSE;
    }

    public byte[] getData() {
        byte[] ret;
        JSONObject respond = new JSONObject();
        respond.put((Object)MESSAGE_TYPE, (Object)this.type.toString().toLowerCase());
        if (this.agentDetails != null) {
            respond.putAll((Map)this.agentDetails.toJSONObject());
        }
        if ((ret = this.getBytes(respond.toJSONString())).length > 8972) {
            throw new IllegalArgumentException("Message to send is larger (" + ret.length + " bytes) than maximum size of 8972 bytes.");
        }
        return ret;
    }

    public AgentDetails getAgentDetails() {
        return this.agentDetails;
    }

    protected byte[] getBytes(String pRespond) {
        return pRespond.getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return "{type=" + this.type + ", agentDetails=" + this.agentDetails + "}";
    }

    public static enum MessageType {
        QUERY,
        RESPONSE;

    }
}

