/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import org.openjdk.jmc.joverflow.descriptors.ArrayBasedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionDescriptors;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.util.MiscUtils;

class BarArrayHandler {
    private final JavaHeapObject[] elements;
    private final int outerDim;
    private final CollectionDescriptors colDescriptors;

    static BarArrayHandler createInstance(CollectionInstanceDescriptor colDesc, CollectionDescriptors colDescriptors) {
        JavaClass clazz = colDesc.getClassDescriptor().getClazz();
        if (!BarArrayHandler.isArrayListOrVector(clazz)) {
            return null;
        }
        int numEls = colDesc.getNumElements();
        if (numEls <= 1) {
            return null;
        }
        ArrayBasedCollectionDescriptor arrayColDesc = (ArrayBasedCollectionDescriptor)colDesc;
        JavaObjectArray elsArray = arrayColDesc.getElementsArray();
        if (elsArray == null) {
            return null;
        }
        JavaHeapObject[] elements = elsArray.getElements();
        return new BarArrayHandler(elements, numEls, colDescriptors);
    }

    static BarArrayHandler createInstance(JavaHeapObject[] elements, CollectionDescriptors colDescriptors) {
        if (elements.length <= 1) {
            return null;
        }
        return new BarArrayHandler(elements, elements.length, colDescriptors);
    }

    private BarArrayHandler(JavaHeapObject[] elements, int numEls, CollectionDescriptors colDescriptors) {
        this.elements = elements;
        this.outerDim = numEls;
        this.colDescriptors = colDescriptors;
    }

    int calculateOverhead() {
        Snapshot snapshot = this.colDescriptors.getSnapshot();
        int ptrSize = snapshot.getPointerSize();
        int arrHeaderSize = snapshot.getArrayHeaderSize();
        int maxInnerDim = 0;
        int minInnerDim = Integer.MAX_VALUE;
        int numNonNullEls = 0;
        JavaClass subArrayClazz = null;
        int oldInnerArraysOvhd = 0;
        int elementSize = 0;
        int subCollectionObjSize = 0;
        int i = 0;
        while (i < this.outerDim) {
            JavaHeapObject line = this.elements[i];
            if (line != null) {
                int subArrayLen;
                JavaClass clazz = line.getClazz();
                if (subArrayClazz != null) {
                    if (clazz != subArrayClazz) {
                        return 0;
                    }
                } else {
                    subArrayClazz = clazz;
                    if (!clazz.isArray()) {
                        subCollectionObjSize = clazz.getInstanceSize();
                    }
                }
                if (line instanceof JavaObjectArray) {
                    JavaObjectArray objSubArray = (JavaObjectArray)line;
                    subArrayLen = objSubArray.getLength();
                    elementSize = ptrSize;
                } else if (line instanceof JavaValueArray) {
                    JavaValueArray valueSubArray = (JavaValueArray)line;
                    subArrayLen = valueSubArray.getLength();
                    if (elementSize == 0) {
                        elementSize = valueSubArray.getElementSize();
                    }
                } else {
                    if (!BarArrayHandler.isArrayListOrVector(clazz)) {
                        return 0;
                    }
                    CollectionInstanceDescriptor subColDesc = this.colDescriptors.getDescriptor((JavaObject)line);
                    subArrayLen = subColDesc.getNumElements();
                    elementSize = ptrSize;
                }
                ++numNonNullEls;
                if (subArrayLen > maxInnerDim) {
                    maxInnerDim = subArrayLen;
                }
                if (subArrayLen < minInnerDim) {
                    minInnerDim = subArrayLen;
                }
                int unalignedLineSize = subArrayLen * elementSize + arrHeaderSize;
                int alignedLineSize = MiscUtils.getAlignedObjectSize(unalignedLineSize, snapshot.getObjectAlignment());
                oldInnerArraysOvhd += arrHeaderSize + (alignedLineSize - unalignedLineSize);
            }
            ++i;
        }
        if (numNonNullEls == 0) {
            return 0;
        }
        if (maxInnerDim >= this.outerDim) {
            return 0;
        }
        int outerPtrOvhd = (this.outerDim - maxInnerDim) * ptrSize;
        int innerColOvhd = (this.outerDim - maxInnerDim) * subCollectionObjSize;
        int unalignedLineSize = this.outerDim * elementSize + arrHeaderSize;
        int alignedLineSize = MiscUtils.getAlignedObjectSize(unalignedLineSize, snapshot.getObjectAlignment());
        int newInnerArraysOvhd = (arrHeaderSize + alignedLineSize - unalignedLineSize) * maxInnerDim;
        int innerArraysOvhd = oldInnerArraysOvhd - newInnerArraysOvhd;
        int ovhd = outerPtrOvhd + innerColOvhd + innerArraysOvhd;
        return ovhd;
    }

    private static boolean isArrayListOrVector(JavaClass clazz) {
        return clazz.isOrSubclassOf("java.util.ArrayList") || clazz.isOrSubclassOf("java.util.Vector");
    }
}

