/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import org.openjdk.jmc.joverflow.descriptors.CollectionDescriptors;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.stats.HeapScaner;
import org.openjdk.jmc.joverflow.stats.InterimRefChainStack;
import org.openjdk.jmc.joverflow.stats.ProblemChecker;
import org.openjdk.jmc.joverflow.stats.TwoHandIndexContainer;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.util.FastStack;

class DepthFirstHeapScaner
extends HeapScaner {
    private final ProblemChecker objHandler;
    private final FastStack<JavaThing[]> fieldsOrArrayElsStack;
    private final InterimRefChainStack refChain = (InterimRefChainStack)this.getRefChain();
    private boolean optimizeForLocality = false;

    DepthFirstHeapScaner(Snapshot snapshot, ProblemChecker objHandler, ProblemRecorder problemRecorder, CollectionDescriptors colDescriptors) {
        super(snapshot, new InterimRefChainStack(problemRecorder, colDescriptors));
        this.objHandler = objHandler;
        this.fieldsOrArrayElsStack = new FastStack(256);
    }

    @Override
    protected void scanObjectsFromRootObj(JavaHeapObject obj) {
        while (obj != null) {
            if (obj.setVisitedIfNot()) {
                ++this.currentProcessedObjNo;
                if (this.cancelled) {
                    throw new HprofParsingCancelledException.Runtime();
                }
                JavaClass clazz = obj.getClazz();
                this.refChain.push(obj);
                if (clazz.isString()) {
                    this.objHandler.handleString((JavaObject)obj);
                    this.refChain.pop();
                } else if (obj instanceof JavaObject) {
                    JavaObject javaObj = (JavaObject)obj;
                    JavaThing[] fields = javaObj.getFields();
                    this.objHandler.handleInstance(javaObj, fields);
                    int[] bannedFieldIndices = clazz.getBannedFieldIndices();
                    if (bannedFieldIndices != null) {
                        int[] nArray = bannedFieldIndices;
                        int n = bannedFieldIndices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int bannedFieldIdx = nArray[n2];
                            fields[bannedFieldIdx] = null;
                            ++n2;
                        }
                    }
                    this.refChain.pushIndexContainer(new TwoHandIndexContainer());
                    this.fieldsOrArrayElsStack.push(fields);
                } else if (obj instanceof JavaClass) {
                    JavaThing[] staticFields = ((JavaClass)obj).getStaticValues();
                    this.refChain.pushIndexContainer(new TwoHandIndexContainer());
                    this.fieldsOrArrayElsStack.push(staticFields);
                } else if (obj instanceof JavaObjectArray) {
                    JavaObjectArray objArray = (JavaObjectArray)obj;
                    JavaHeapObject[] elements = objArray.getElements();
                    this.objHandler.handleObjectArray(objArray, elements);
                    this.refChain.pushIndexContainer(new TwoHandIndexContainer());
                    this.fieldsOrArrayElsStack.push(elements);
                } else {
                    this.objHandler.handleValueArray((JavaValueArray)obj);
                    this.refChain.pop();
                }
            }
            obj = this.getNextObjToScan(obj);
        }
    }

    private JavaHeapObject getNextObjToScan(JavaHeapObject oldObj) {
        long oldObjOfsInFile = -1L;
        JavaHeapObject obj = null;
        while (!this.fieldsOrArrayElsStack.isEmpty()) {
            JavaThing[] fieldsOrElements = this.fieldsOrArrayElsStack.peek();
            TwoHandIndexContainer curIdxContainer = (TwoHandIndexContainer)this.refChain.getCurrentIndexContainer();
            int nextIdx = curIdxContainer.incrementAndGetBase();
            while (nextIdx < fieldsOrElements.length) {
                JavaThing objThing = fieldsOrElements[nextIdx];
                if (objThing != null && objThing instanceof JavaHeapObject) {
                    obj = (JavaHeapObject)objThing;
                    if (!obj.isVisited()) {
                        if (this.optimizeForLocality && obj instanceof JavaLazyReadObject) {
                            long l = oldObjOfsInFile = oldObj instanceof JavaLazyReadObject ? ((JavaLazyReadObject)oldObj).getObjOfsInFile() : -1L;
                            if (oldObjOfsInFile != -1L) {
                                curIdxContainer.setBase(nextIdx - 1);
                                break;
                            }
                        }
                        curIdxContainer.setBase(nextIdx);
                        curIdxContainer.set(nextIdx);
                        return obj;
                    }
                    obj = null;
                }
                ++nextIdx;
            }
            if (obj == null) {
                this.fieldsOrArrayElsStack.pop();
                this.refChain.pop2();
                continue;
            }
            long curObjOfsInFile = ((JavaLazyReadObject)obj).getObjOfsInFile();
            long minDistance = Math.abs(curObjOfsInFile - oldObjOfsInFile);
            int bestIdx = nextIdx++;
            int nCheckedFields = 0;
            while (nextIdx < fieldsOrElements.length && nCheckedFields < 8) {
                JavaThing objThing = fieldsOrElements[nextIdx];
                if (objThing != null && objThing instanceof JavaHeapObject && !(obj = (JavaHeapObject)objThing).isVisited()) {
                    if (!(obj instanceof JavaLazyReadObject)) {
                        curIdxContainer.set(nextIdx);
                        return obj;
                    }
                    ++nCheckedFields;
                    curObjOfsInFile = ((JavaLazyReadObject)obj).getObjOfsInFile();
                    long distance = Math.abs(curObjOfsInFile - oldObjOfsInFile);
                    if (distance < minDistance) {
                        bestIdx = nextIdx;
                        minDistance = distance;
                    }
                }
                ++nextIdx;
            }
            curIdxContainer.set(bestIdx);
            return (JavaHeapObject)fieldsOrElements[bestIdx];
        }
        return obj;
    }
}

