/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.descriptors.WeakHashMapDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.util.SimpleIdentitySet;

class WeakMapHandler {
    private final WeakHashMapDescriptor colDesc;

    static WeakMapHandler createInstance(CollectionInstanceDescriptor colDesc) {
        JavaClass clazz = colDesc.getClassDescriptor().getClazz();
        if (!clazz.isOrSubclassOf("java.util.WeakHashMap")) {
            return null;
        }
        if (colDesc.getNumElements() == 0) {
            return null;
        }
        return new WeakMapHandler(colDesc);
    }

    private WeakMapHandler(CollectionInstanceDescriptor colDesc) {
        this.colDesc = (WeakHashMapDescriptor)colDesc;
    }

    Result calculateOverhead() {
        JavaHeapObject[][] keysAndValues = this.colDesc.getKeysAndValues();
        if (keysAndValues[0].length == 0) {
            return null;
        }
        JavaHeapObject[] keys = keysAndValues[0];
        SimpleIdentitySet<JavaHeapObject> keySet = new SimpleIdentitySet<JavaHeapObject>(keys.length);
        JavaHeapObject[] javaHeapObjectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject key = javaHeapObjectArray[n2];
            if (key != null) {
                keySet.add(key);
            }
            ++n2;
        }
        JavaHeapObject[] values = keysAndValues[1];
        int ovhd = 0;
        String valueTypeAndFieldSample = null;
        JavaHeapObject[] javaHeapObjectArray2 = values;
        int n3 = values.length;
        int n4 = 0;
        while (n4 < n3) {
            JavaHeapObject value = javaHeapObjectArray2[n4];
            if (value instanceof JavaObject) {
                JavaObject valueObj = (JavaObject)value;
                if (valueObj.getClazz().isOrSubclassOf("java.lang.ref.WeakReference")) break;
                JavaThing[] fields = valueObj.getFields(false);
                int i = 0;
                while (i < fields.length) {
                    JavaHeapObject field;
                    JavaThing fieldThing = fields[i];
                    if (fieldThing != null && fieldThing instanceof JavaHeapObject && keySet.contains(field = (JavaHeapObject)fieldThing)) {
                        ovhd += field.getSize() + valueObj.getSize();
                        if (valueTypeAndFieldSample != null) break;
                        valueTypeAndFieldSample = WeakMapHandler.getStringForValueAndField(valueObj, i);
                        break;
                    }
                    ++i;
                }
            } else if (value instanceof JavaObjectArray) {
                JavaHeapObject[] elements;
                JavaHeapObject[] javaHeapObjectArray3 = elements = ((JavaObjectArray)value).getElements();
                int n5 = elements.length;
                int n6 = 0;
                while (n6 < n5) {
                    JavaHeapObject element = javaHeapObjectArray3[n6];
                    if (element != null && !element.getClazz().isOrSubclassOf("java.lang.ref.WeakReference") && keySet.contains(element)) {
                        ovhd += element.getSize() + value.getSize();
                        if (valueTypeAndFieldSample != null) break;
                        valueTypeAndFieldSample = value.getClazz().getName();
                        break;
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        if (ovhd > 0) {
            return new Result(ovhd, valueTypeAndFieldSample);
        }
        return null;
    }

    private static String getStringForValueAndField(JavaObject value, int fieldIdx) {
        JavaClass clazz = value.getClazz();
        return clazz.getName() + "." + clazz.getFieldForInstance(fieldIdx).getName();
    }

    static class Result {
        final int overhead;
        final String valueTypeAndFieldSample;

        Result(int overhead, String valueTypeAndFieldSample) {
            this.overhead = overhead;
            this.valueTypeAndFieldSample = valueTypeAndFieldSample;
        }
    }
}

