/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.support;

import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.support.ClassAndSizeCombo;
import org.openjdk.jmc.joverflow.support.Constants;

public class ClassAndOvhdCombo
extends ClassAndSizeCombo {
    private final Constants.ProblemKind problemKind;

    ClassAndOvhdCombo(JavaClass clazz, Constants.ProblemKind problemKind, int numInstances, int ovhd) {
        super(clazz, numInstances, ovhd);
        this.problemKind = problemKind;
    }

    public Constants.ProblemKind getProblemKind() {
        return this.problemKind;
    }

    public int getOverhead() {
        return this.getSizeOrOvhd();
    }

    @Override
    public ClassAndOvhdCombo clone() {
        return (ClassAndOvhdCombo)super.clone();
    }

    public static class Extended
    extends ClassAndOvhdCombo {
        private long totalNumElements;
        private int maxNumElements;

        Extended(JavaClass collectionClazz, Constants.ProblemKind problemKind, int numInstances, int ovhd, long numElementsInCollection, int maxNumElements) {
            super(collectionClazz, problemKind, numInstances, ovhd);
            this.totalNumElements = numElementsInCollection;
            this.maxNumElements = maxNumElements;
        }

        void addInstances(int nInstances, int ovhd, long totalNumElements, int maxNumElements) {
            super.addInstances(nInstances, ovhd);
            this.totalNumElements += totalNumElements;
            if (maxNumElements > this.maxNumElements) {
                this.maxNumElements = maxNumElements;
            }
        }

        public long getTotalNumElements() {
            return this.totalNumElements;
        }

        public float getAverageNumElements() {
            return (float)((double)this.totalNumElements / (double)this.getNumInstances());
        }

        public int getMaxNumElements() {
            return this.maxNumElements;
        }
    }
}

