/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.util;

public class MiscUtils {
    public static int getAlignedObjectSize(int size, int objAlignment) {
        if ((size & objAlignment - 1) == 0) {
            return size;
        }
        return (size & ~(objAlignment - 1)) + objAlignment;
    }

    public static String toHex(long addr) {
        return "0x" + Long.toHexString(addr);
    }

    public static String removeEndLinesAndAddQuotes(String s, int maxLen) {
        if (maxLen > 0 && ((String)s).length() > maxLen) {
            s = ((String)s).substring(0, maxLen - 16) + " ...[length " + ((String)s).length() + "]";
        }
        if (((String)s).indexOf(10) == -1 && ((String)s).indexOf(13) == -1) {
            return "\"" + (String)s + "\"";
        }
        char[] dst = new char[((String)s).length() * 2 + 2];
        dst[0] = 34;
        int dstIdx = 1;
        int len = ((String)s).length();
        int i = 0;
        while (i < len) {
            char c = ((String)s).charAt(i);
            if (c == '\n') {
                dst[dstIdx++] = 92;
                dst[dstIdx++] = 110;
            } else if (c == '\r') {
                dst[dstIdx++] = 92;
                dst[dstIdx++] = 114;
            } else {
                dst[dstIdx++] = c;
            }
            ++i;
        }
        dst[dstIdx++] = 34;
        return new String(dst, 0, dstIdx);
    }

    public static String asCommaSeparatedList(String[] strings) {
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder sb = new StringBuilder(strings.length * 10);
        sb.append(strings[0]);
        int i = 1;
        while (i < strings.length) {
            sb.append(", ");
            sb.append(strings[i]);
            ++i;
        }
        return sb.toString();
    }
}

