/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ext;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiServicesJmxProviderProxy
implements JMXConnectorProvider {
    private final BundleContext context = FrameworkUtil.getBundle(OsgiServicesJmxProviderProxy.class).getBundleContext();

    @Override
    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        JMXConnectorProvider realProvider = this.extendEnv(serviceURL, environment);
        if (realProvider == null) {
            throw new MalformedURLException("No OSGi service for JMX protocol " + serviceURL.getProtocol() + " was found.");
        }
        return realProvider.newJMXConnector(serviceURL, environment);
    }

    public JMXConnectorProvider extendEnv(JMXServiceURL serviceURL, Map<String, Object> environment) {
        String filter = "(protocol=" + serviceURL.getProtocol() + ")";
        try {
            Collection refs = this.context.getServiceReferences(JMXConnectorProvider.class, filter);
            for (ServiceReference ref : refs) {
                JMXConnectorProvider provider = (JMXConnectorProvider)this.context.getService(ref);
                if (provider == null) continue;
                String[] stringArray = ref.getPropertyKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    Object value = ref.getProperty(key);
                    String property = OsgiServicesJmxProviderProxy.getIfPrefixed("environment:", key);
                    if (property != null) {
                        environment.put(property, value);
                    }
                    if ((property = OsgiServicesJmxProviderProxy.getIfPrefixed("system:", key)) != null) {
                        OsgiServicesJmxProviderProxy.ensureSystemProperty(property, value.toString(), "|");
                    }
                    ++n2;
                }
                ClassLoader loader = provider.getClass().getClassLoader();
                environment.put("jmx.remote.default.class.loader", loader);
                environment.put("jmx.remote.protocol.provider.class.loader", loader);
                return provider;
            }
        }
        catch (InvalidSyntaxException e) {
            Logger.getLogger("org.openjdk.jmc.rjmx.ext").log(Level.WARNING, "Bad protocol syntax", e);
        }
        return null;
    }

    private static String getIfPrefixed(String prefix, String candidate) {
        if (candidate.startsWith(prefix)) {
            return candidate.substring(prefix.length());
        }
        return null;
    }

    private static void ensureSystemProperty(String key, String include, String separator) {
        String org = System.getProperty(key);
        if (org == null) {
            System.setProperty(key, include);
            return;
        }
        if ((separator + org + separator).indexOf(separator + include + separator) < 0) {
            System.setProperty(key, org + separator + include);
        }
    }
}

