/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.internal.SyntheticNotificationEntry;
import org.openjdk.jmc.rjmx.common.internal.SyntheticNotificationMBean;

public class SyntheticNotificationRepository {
    private final Map<ObjectName, Set<SyntheticNotificationEntry>> mbeans = new HashMap<ObjectName, Set<SyntheticNotificationEntry>>();
    private final MBeanServer server = MBeanServerFactory.newMBeanServer();
    private final MBeanServerConnection compoundServer;

    public SyntheticNotificationRepository(MBeanServerConnection compoundServer) {
        this.compoundServer = compoundServer;
    }

    public String[] getDomains() {
        return this.server.getDomains();
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.server.getObjectInstance(name);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.server.queryMBeans(name, query);
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.server.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public boolean hasNotification(ObjectName name) {
        Set<SyntheticNotificationEntry> entries = this.mbeans.get(name);
        return entries != null;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.server.getMBeanInfo(name);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.server.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.server.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.server.removeNotificationListener(name, listener, filter, handback);
    }

    public void initializeFromExtensions(List<SyntheticNotificationEntry> notificationCandidates) {
        boolean hasResolved = true;
        while (!notificationCandidates.isEmpty() && hasResolved) {
            hasResolved = false;
            Iterator<SyntheticNotificationEntry> iterator = notificationCandidates.iterator();
            while (iterator.hasNext()) {
                SyntheticNotificationEntry candidate = iterator.next();
                if (!candidate.getNotification().hasResolvedDependencies(this.compoundServer)) continue;
                hasResolved = true;
                iterator.remove();
                this.registerEntry(candidate);
            }
        }
        this.registerMBeans();
    }

    private void registerMBeans() {
        for (Map.Entry<ObjectName, Set<SyntheticNotificationEntry>> notificationEntry : this.mbeans.entrySet()) {
            ObjectName objectName = notificationEntry.getKey();
            try {
                SyntheticNotificationMBean mbean = this.createMBean(objectName);
                for (SyntheticNotificationEntry entry : notificationEntry.getValue()) {
                    entry.getNotification().init(mbean);
                    entry.getNotification().init(this.compoundServer, entry.getNotificationDescriptor().getDataPath(), entry.getMessage());
                }
            }
            catch (Exception e) {
                RJMXCorePlugin.getDefault().getLogger().log(Level.SEVERE, "Failed to register synthetic notification mbean " + objectName.toString(), e);
            }
        }
    }

    private SyntheticNotificationMBean createMBean(ObjectName name) throws Exception {
        Set<SyntheticNotificationEntry> entries = this.mbeans.get(name);
        SyntheticNotificationMBean mbean = new SyntheticNotificationMBean(entries.toArray(new SyntheticNotificationEntry[entries.size()]));
        this.server.registerMBean(mbean, name);
        return mbean;
    }

    private void registerEntry(SyntheticNotificationEntry entry) {
        Set<SyntheticNotificationEntry> notificationEntries = this.mbeans.get(entry.getNotificationDescriptor().getObjectName());
        if (notificationEntries == null) {
            notificationEntries = new HashSet<SyntheticNotificationEntry>();
            this.mbeans.put(entry.getNotificationDescriptor().getObjectName(), notificationEntries);
        }
        notificationEntries.add(entry);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.server.isInstanceOf(name, className);
    }

    public void dispose() {
        for (Set<SyntheticNotificationEntry> notificationEntrySet : this.mbeans.values()) {
            for (SyntheticNotificationEntry entry : notificationEntrySet) {
                try {
                    entry.getNotification().stop();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

