/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription;

import java.util.Objects;
import org.openjdk.jmc.rjmx.common.messages.internal.Messages;
import org.openjdk.jmc.rjmx.common.subscription.MRI;

public class MRIValueEvent {
    public static final Object UNAVAILABLE_VALUE = new UnavailableValue();
    private final long m_timestamp;
    private final Object m_value;
    private final MRI m_mri;

    public MRIValueEvent(MRI mri, long timestamp, Object value) {
        this.m_mri = mri;
        this.m_timestamp = timestamp;
        this.m_value = value;
    }

    public final MRI getMRI() {
        return this.m_mri;
    }

    public final long getTimestamp() {
        return this.m_timestamp;
    }

    public final Object getValue() {
        return this.m_value;
    }

    public String toString() {
        return this.m_mri.getQualifiedName() + " " + this.getValue() + "@" + this.m_timestamp;
    }

    public boolean equals(Object theOtherGuy) {
        if (theOtherGuy == null || this.getClass() != theOtherGuy.getClass()) {
            return false;
        }
        MRIValueEvent otherEvent = (MRIValueEvent)theOtherGuy;
        if (this.m_timestamp != otherEvent.m_timestamp || this.m_mri.equals(otherEvent.m_mri)) {
            return false;
        }
        return Objects.equals(this.m_value, otherEvent.m_value);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int)(this.m_timestamp ^ this.m_timestamp >>> 32);
        hash = 31 * hash + this.m_mri.hashCode();
        hash = 31 * hash + (this.m_value == null ? 0 : this.m_value.hashCode());
        return hash;
    }

    private static class UnavailableValue {
        private UnavailableValue() {
        }

        public String toString() {
            return "[" + Messages.getString("LABEL_NOT_AVAILABLE") + "]";
        }
    }
}

