/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.SimpleAffineTransform;

public class SubdividedQuantityRange
implements IRange<IQuantity> {
    private final IQuantity rangeStart;
    private final IQuantity rangeEnd;
    private final int pixelExtent;
    private final IQuantity subdividerStart;
    private final IQuantity subdividerDelta;
    private final int numSubdividers;
    private final IQuantity quantityExtent;
    private final IUnit refUnit;
    private final IScalarAffineTransform refToSubdividerTransform;
    private final IScalarAffineTransform subdividerToRefTransform;
    private final IScalarAffineTransform refToPixelTransform;
    private final IScalarAffineTransform pixelToRefTransform;
    private final IScalarAffineTransform subdividerToPixelTransform;

    public SubdividedQuantityRange(IQuantity rangeStart, IQuantity rangeEnd, int pixelExtent, int minPixelsPerSubdivider) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.quantityExtent = rangeEnd.subtract(rangeStart);
        this.pixelExtent = pixelExtent;
        IRange firstBucket = rangeStart.getType().getFirstBucket(rangeStart, rangeEnd, (double)pixelExtent / (double)minPixelsPerSubdivider);
        this.subdividerStart = (IQuantity)firstBucket.getStart();
        this.subdividerDelta = (IQuantity)firstBucket.getExtent();
        this.numSubdividers = 2 + (int)(this.quantityExtent.doubleValue() / this.subdividerDelta.doubleValueIn(this.quantityExtent.getUnit()));
        this.refUnit = this.subdividerStart.getUnit();
        Number negOffsetInRef = this.subdividerStart.numberValueIn(this.refUnit);
        double divisor = this.subdividerDelta.doubleValueIn((IUnit)this.refUnit.getDeltaUnit());
        this.refToSubdividerTransform = SimpleAffineTransform.createWithNegPreOffset((double)(1.0 / divisor), (Number)negOffsetInRef);
        this.subdividerToRefTransform = this.refToSubdividerTransform.invert();
        negOffsetInRef = rangeStart.numberValueIn(this.refUnit);
        divisor = this.quantityExtent.doubleValueIn((IUnit)this.refUnit.getDeltaUnit()) / (double)pixelExtent;
        this.refToPixelTransform = SimpleAffineTransform.createWithNegPreOffset((double)(1.0 / divisor), (Number)negOffsetInRef);
        this.pixelToRefTransform = this.refToPixelTransform.invert();
        this.subdividerToPixelTransform = this.refToPixelTransform.concat(this.subdividerToRefTransform);
    }

    public SubdividedQuantityRange(int numSubdividers, IQuantity rangeStart, IQuantity rangeEnd, int pixelExtent) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.quantityExtent = rangeEnd.subtract(rangeStart);
        this.pixelExtent = pixelExtent;
        this.subdividerStart = rangeStart;
        this.subdividerDelta = this.quantityExtent.multiply(1.0 / (double)numSubdividers);
        this.numSubdividers = numSubdividers;
        this.refUnit = this.subdividerStart.getUnit();
        Number negOffsetInRef = this.subdividerStart.numberValueIn(this.refUnit);
        double divisor = this.subdividerDelta.doubleValueIn((IUnit)this.refUnit.getDeltaUnit());
        this.refToSubdividerTransform = SimpleAffineTransform.createWithNegPreOffset((double)(1.0 / divisor), (Number)negOffsetInRef);
        this.subdividerToRefTransform = this.refToSubdividerTransform.invert();
        negOffsetInRef = rangeStart.numberValueIn(this.refUnit);
        divisor = this.quantityExtent.doubleValueIn((IUnit)this.refUnit.getDeltaUnit()) / (double)pixelExtent;
        this.refToPixelTransform = SimpleAffineTransform.createWithNegPreOffset((double)(1.0 / divisor), (Number)negOffsetInRef);
        this.pixelToRefTransform = this.refToPixelTransform.invert();
        this.subdividerToPixelTransform = this.refToPixelTransform.concat(this.subdividerToRefTransform);
    }

    private SubdividedQuantityRange(IQuantity rangeStart, IQuantity rangeEnd, int pixelExtent) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.quantityExtent = rangeEnd.subtract(rangeStart);
        this.pixelExtent = pixelExtent;
        this.subdividerStart = rangeStart;
        this.subdividerDelta = this.quantityExtent.multiply(1.0 / (double)pixelExtent);
        this.numSubdividers = pixelExtent;
        this.refUnit = this.subdividerStart.getUnit();
        Number negOffsetInRef = this.subdividerStart.numberValueIn(this.refUnit);
        double divisor = this.subdividerDelta.doubleValueIn((IUnit)this.refUnit.getDeltaUnit());
        this.refToSubdividerTransform = SimpleAffineTransform.createWithNegPreOffset((double)(1.0 / divisor), (Number)negOffsetInRef);
        this.subdividerToRefTransform = this.refToSubdividerTransform.invert();
        this.refToPixelTransform = this.refToSubdividerTransform;
        this.pixelToRefTransform = this.subdividerToRefTransform;
        this.subdividerToPixelTransform = DecimalScaleFactor.get((int)0);
    }

    public SubdividedQuantityRange copyWithPixelSubdividers() {
        return new SubdividedQuantityRange(this.rangeStart, this.rangeEnd, this.pixelExtent);
    }

    public IQuantity getStart() {
        return this.rangeStart;
    }

    public IQuantity getEnd() {
        return this.rangeEnd;
    }

    public IQuantity getCenter() {
        return this.rangeStart.add(this.rangeEnd.subtract(this.rangeStart).multiply(0.5));
    }

    public IQuantity getExtent() {
        return this.quantityExtent;
    }

    public boolean isPoint() {
        return this.quantityExtent.doubleValue() == 0.0;
    }

    public String displayUsing(String formatHint) {
        return this.rangeStart.getType().getRangeFormatter(formatHint).format((Object)this);
    }

    public int getPixelExtent() {
        return this.pixelExtent;
    }

    public int getNumSubdividers() {
        return this.numSubdividers;
    }

    public IQuantity getSubdivider(int subdivider) {
        return this.refUnit.quantity(this.subdividerToRefTransform.targetNumber((long)subdivider));
    }

    public double getSubdividerPixel(int subdivider) {
        return this.subdividerToPixelTransform.targetValue((double)subdivider);
    }

    public int getFloorSubdivider(IQuantity value) {
        return this.toSubdividerTransform(value.getUnit()).targetIntFloor(value.numberValue());
    }

    public int getFloorSubdividerAtPixel(Number pixel) {
        return this.subdividerToPixelTransform.invert().targetIntFloor(pixel);
    }

    public int getClosestSubdividerAtPixel(Number pixel) {
        return (int)Math.round(this.subdividerToPixelTransform.invert().targetNumber(pixel).doubleValue());
    }

    public double getPixel(IQuantity value) {
        if (value == null) {
            return Double.NaN;
        }
        return this.toPixelTransform(value.getUnit()).targetNumber(value.numberValue()).doubleValue();
    }

    public IQuantity getQuantityAtPixel(Number pixel) {
        return this.refUnit.quantity(this.pixelToRefTransform.targetNumber(pixel));
    }

    public IScalarAffineTransform toSubdividerTransform(IUnit unit) {
        return this.refToSubdividerTransform.concat(unit.valueTransformTo(this.refUnit));
    }

    public IScalarAffineTransform toPixelTransform(IUnit unit) {
        return this.refToPixelTransform.concat(unit.valueTransformTo(this.refUnit));
    }
}

