/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.column;

import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.handlers.CopySelectionAction;
import org.openjdk.jmc.ui.misc.CopySettings;
import org.openjdk.jmc.ui.misc.FormatToolkit;

class CopyColumnsAction
implements Function<IStructuredSelection, Stream<String>> {
    private final Function<Boolean, Stream<? extends IColumn>> columns;

    CopyColumnsAction(Function<Boolean, Stream<? extends IColumn>> columns) {
        this.columns = columns;
    }

    static IAction build(StructuredViewer viewer, Function<Boolean, Stream<? extends IColumn>> columns) {
        return new CopySelectionAction(viewer, new CopyColumnsAction(columns));
    }

    @Override
    public Stream<String> apply(IStructuredSelection selection) {
        boolean shouldCopyOnlyVisible = CopySettings.getInstance().shouldCopyOnlyVisible();
        boolean raw = CopySettings.getInstance().shouldCopyAsRawData();
        Function<Stream<String>, String> rowFormatter = FormatToolkit.getPreferredRowFormatter();
        Function<Object, String> objectFormatter = o -> (String)rowFormatter.apply(this.columns.apply(shouldCopyOnlyVisible).map(c -> CopyColumnsAction.formatObject(o, c, raw)));
        Stream<String> strings = FormatToolkit.formatSelection(selection, objectFormatter);
        if (CopySettings.getInstance().shouldCopyColumnHeaders()) {
            return Stream.concat(Stream.of(rowFormatter.apply(this.columns.apply(shouldCopyOnlyVisible).map(IColumn::getName))), strings);
        }
        return strings;
    }

    private static String formatObject(Object o, IColumn column, boolean raw) {
        IMemberAccessor<?, Object> cellAccessor = column.getCellAccessor();
        if (raw && cellAccessor != null) {
            Object cell = cellAccessor.getMember(o);
            if (cell instanceof IQuantity) {
                return ((IQuantity)cell).persistableString();
            }
            return cell == null ? "" : TypeHandling.getValueString((Object)cell);
        }
        return column.getLabelProvider().getText(o);
    }
}

