/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.ChartTextCanvas;
import org.openjdk.jmc.ui.misc.Messages;

public class ChartLaneHeightControls
extends Composite {
    private Button decHeightBtn;
    private Button incHeightBtn;
    private Button overviewBtn;
    private ChartCanvas chartCanvas;
    private ChartTextCanvas textCanvas;
    private static final int ADJUST_AMOUNT = 3;

    public ChartLaneHeightControls(Composite parent) {
        super(parent, 0);
        GridLayout gl = new GridLayout(3, true);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.initDecreaseHeightButton();
        this.initIncreaseHeightButton();
        this.initOverviewButton();
    }

    private void initDecreaseHeightButton() {
        this.decHeightBtn = new Button((Composite)this, 8);
        this.decHeightBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.decHeightBtn.setImage(UIPlugin.getDefault().getImage("fa-minus-16.png"));
        this.decHeightBtn.setToolTipText(Messages.ChartLaneHeightControls_LANE_HEIGHT_DECREASE_TOOLTIP);
        this.decHeightBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChartLaneHeightControls.this.adjustLaneHeight(-3);
            }
        });
        this.decHeightBtn.setEnabled(false);
    }

    private void initIncreaseHeightButton() {
        this.incHeightBtn = new Button((Composite)this, 8);
        this.incHeightBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.incHeightBtn.setToolTipText(Messages.ChartLaneHeightControls_LANE_HEIGHT_INCREASE_TOOLTIP);
        this.incHeightBtn.setImage(UIPlugin.getDefault().getImage("fa-plus-16.png"));
        this.incHeightBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChartLaneHeightControls.this.adjustLaneHeight(3);
            }
        });
    }

    private void initOverviewButton() {
        this.overviewBtn = new Button((Composite)this, 2);
        this.overviewBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.overviewBtn.setToolTipText(Messages.ChartLaneHeightControls_OVERVIEW_BUTTON_TOOLTIP);
        this.overviewBtn.setImage(UIPlugin.getDefault().getImage("adress.gif"));
        this.overviewBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ChartLaneHeightControls.this.overviewBtn.getSelection()) {
                    ChartLaneHeightControls.this.chartCanvas.restoreLaneHeight();
                    ChartLaneHeightControls.this.chartCanvas.redrawChart();
                    if (ChartLaneHeightControls.this.textCanvas != null) {
                        ChartLaneHeightControls.this.textCanvas.restoreLaneHeight();
                        ChartLaneHeightControls.this.textCanvas.redrawChartText();
                    }
                } else {
                    ChartLaneHeightControls.this.chartCanvas.setOverviewLaneHeight();
                    ChartLaneHeightControls.this.chartCanvas.redrawChart();
                    if (ChartLaneHeightControls.this.textCanvas != null) {
                        ChartLaneHeightControls.this.textCanvas.setOverviewLaneHeight();
                        ChartLaneHeightControls.this.textCanvas.redrawChartText();
                    }
                }
            }
        });
    }

    private void adjustLaneHeight(int amount) {
        this.chartCanvas.adjustLaneHeight(amount);
        this.chartCanvas.redrawChart();
        if (this.textCanvas != null) {
            this.textCanvas.adjustLaneHeight(amount);
            this.textCanvas.redrawChartText();
        }
        if (this.chartCanvas.isLaneHeightMinimumSize()) {
            this.decHeightBtn.setEnabled(false);
        } else {
            this.decHeightBtn.setEnabled(true);
        }
        if (this.overviewBtn.getSelection()) {
            this.overviewBtn.setSelection(false);
        }
    }

    void resetLaneHeightToMinimum() {
        this.chartCanvas.resetLaneHeight();
        if (this.textCanvas != null) {
            this.textCanvas.resetLaneHeight();
        }
        this.decHeightBtn.setEnabled(false);
        this.overviewBtn.setSelection(false);
    }

    void setChartCanvas(ChartCanvas chartCanvas) {
        this.chartCanvas = chartCanvas;
    }

    void setTextCanvas(ChartTextCanvas textCanvas) {
        this.textCanvas = textCanvas;
    }
}

