/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.concurrent.Executor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayToolkit {
    private static final Executor IN_DISPLAY_THREAD_EXECUTOR = DisplayToolkit::safeAsyncExec;

    public static void placeDialogInCenter(Shell parent, Shell shell) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static void dispose(Widget widget) {
        if (DisplayToolkit.isSafe(widget)) {
            widget.dispose();
        }
    }

    public static void dispose(Resource resource) {
        if (DisplayToolkit.isSafe(resource)) {
            resource.dispose();
        }
    }

    public static void safeAsyncExec(Widget widget, Runnable runnable) {
        new SafeWidgetRunnable(runnable, widget).asyncExec();
    }

    public static void safeSyncExec(Widget widget, Runnable runnable) {
        new SafeWidgetRunnable(runnable, widget).syncExec();
    }

    public static void safeAsyncExec(Runnable runnable) {
        new SafeDisplayRunnable(runnable, Display.getDefault()).asyncExec();
    }

    public static void safeSyncExec(Runnable runnable) {
        new SafeDisplayRunnable(runnable, Display.getDefault()).syncExec();
    }

    public static void safeAsyncExec(Display display, Runnable runnable) {
        new SafeDisplayRunnable(runnable, display).asyncExec();
    }

    public static void safeSyncExec(Display display, Runnable runnable) {
        new SafeDisplayRunnable(runnable, display).syncExec();
    }

    public static void safeTimerExec(final Display display, final int milliseconds, final Runnable runnable) {
        DisplayToolkit.safeSyncExec(display, new Runnable(){

            @Override
            public void run() {
                new SafeDisplayRunnable(runnable, display).timerExec(milliseconds);
            }
        });
    }

    public static boolean isSafe(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static boolean isSafe(Resource resource) {
        return resource != null && !resource.isDisposed();
    }

    public static Executor inDisplayThread() {
        return IN_DISPLAY_THREAD_EXECUTOR;
    }

    public static class SafeDisplayRunnable
    extends SafeRunnable {
        private final Display m_display;

        public SafeDisplayRunnable(Runnable runnable, Display display) {
            super(runnable);
            this.m_display = display;
        }

        public static boolean isSafe(Display display) {
            return display != null && !display.isDisposed();
        }

        @Override
        protected Display getDisplay() {
            return this.m_display;
        }

        @Override
        protected boolean isSafe() {
            return SafeDisplayRunnable.isSafe(this.m_display);
        }
    }

    public static abstract class SafeRunnable
    implements Runnable {
        protected final Runnable m_runnable;

        public SafeRunnable(Runnable runnable) {
            this.m_runnable = runnable;
        }

        @Override
        public void run() {
            if (this.isSafe()) {
                this.m_runnable.run();
            }
        }

        protected abstract boolean isSafe();

        protected abstract Display getDisplay();

        protected void asyncExec() {
            if (this.isSafe()) {
                this.getDisplay().asyncExec((Runnable)this);
            }
        }

        protected void syncExec() {
            if (this.isSafe()) {
                this.getDisplay().syncExec((Runnable)this);
            }
        }

        protected void timerExec(int millis) {
            if (this.isSafe()) {
                this.getDisplay().timerExec(millis, (Runnable)this);
            }
        }
    }

    public static class SafeWidgetRunnable
    extends SafeRunnable {
        private final Widget m_widget;

        public SafeWidgetRunnable(Runnable runnable, Widget widget) {
            super(runnable);
            this.m_widget = widget;
        }

        @Override
        protected boolean isSafe() {
            if (DisplayToolkit.isSafe(this.m_widget)) {
                return SafeDisplayRunnable.isSafe(this.m_widget.getDisplay());
            }
            return false;
        }

        @Override
        protected Display getDisplay() {
            return this.m_widget.getDisplay();
        }
    }
}

