/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.core.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MouseInputListenerWorkaroundForToolTipEnabledComponent
extends MouseAdapter {
    private final JComponent destination;

    public MouseInputListenerWorkaroundForToolTipEnabledComponent(JComponent destination) {
        this.destination = destination;
    }

    public void install(JComponent jComponentWithToolTip) {
        jComponentWithToolTip.addMouseMotionListener(this);
        jComponentWithToolTip.addMouseListener(this);
    }

    private void dispatch(MouseEvent e) {
        this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, this.destination));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatch(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dispatch(e);
    }
}

