/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.JScrollPaneWithBackButton;
import io.github.bric3.fireplace.core.ui.MouseInputListenerWorkaroundForToolTipEnabledComponent;
import io.github.bric3.fireplace.flamegraph.FlamegraphRenderEngine;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameFontProvider;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameRenderer;
import io.github.bric3.fireplace.flamegraph.FrameTextsProvider;
import io.github.bric3.fireplace.flamegraph.ZoomTarget;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlamegraphView<T> {
    private static final String OWNER_KEY = "flamegraphOwner";
    public static final String SHOW_STATS = "flamegraph.show_stats";
    @NotNull
    private final FlamegraphCanvas<T> canvas;
    @NotNull
    public final JComponent component;
    @NotNull
    private final FlamegraphHoveringScrollPaneMouseListener<T> scrollPaneListener;
    @NotNull
    private FrameModel<T> framesModel = FrameModel.empty();

    public static <T> Optional<FlamegraphView<@NotNull T>> from(@NotNull JComponent component) {
        return Optional.ofNullable((FlamegraphView)component.getClientProperty(OWNER_KEY));
    }

    public FlamegraphView() {
        this.canvas = new FlamegraphCanvas(this);
        this.setRenderConfiguration(FrameTextsProvider.of(frameBox -> frameBox.actualNode.toString()), FrameColorProvider.defaultColorProvider(f -> UIManager.getColor("Button.background")), FrameFontProvider.defaultFontProvider());
        this.canvas.putClientProperty(OWNER_KEY, this);
        this.scrollPaneListener = new FlamegraphHoveringScrollPaneMouseListener<T>(this.canvas);
        JScrollPane scrollPane = this.createScrollPane();
        scrollPane.putClientProperty(OWNER_KEY, this);
        JLayer<JScrollPane> layeredScrollPane = JScrollPaneWithBackButton.create(() -> {
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
            this.scrollPaneListener.install(scrollPane);
            new MouseInputListenerWorkaroundForToolTipEnabledComponent(scrollPane).install(this.canvas);
            this.canvas.setupListeners(scrollPane);
            return scrollPane;
        });
        this.canvas.addPropertyChangeListener("mode", evt -> {
            Mode mode = (Mode)((Object)((Object)evt.getNewValue()));
            layeredScrollPane.firePropertyChange("backToDirection", -1, mode == Mode.ICICLEGRAPH ? 1 : 5);
        });
        this.component = this.wrap(layeredScrollPane, bg -> {
            scrollPane.setBorder(null);
            scrollPane.setBackground((Color)bg);
            scrollPane.getVerticalScrollBar().setBackground((Color)bg);
            scrollPane.getHorizontalScrollBar().setBackground((Color)bg);
            this.canvas.setBackground((Color)bg);
        });
    }

    @NotNull
    private JScrollPane createScrollPane() {
        final JScrollPane jScrollPane = new JScrollPane(this.canvas);
        JViewport viewport = new JViewport(){

            @Override
            protected LayoutManager createLayoutManager() {
                return new ViewportLayout(){
                    private final Dimension oldViewPortSize = new Dimension();
                    private final Dimension flamegraphSize = new Dimension();
                    private final Point flamegraphLocation = new Point();

                    @Override
                    public void layoutContainer(Container parent) {
                        int newPolicy;
                        JViewport vp = (JViewport)parent;
                        FlamegraphCanvas canvas = (FlamegraphCanvas)vp.getView();
                        int oldVpWidth = this.oldViewPortSize.width;
                        Dimension vpSize = vp.getSize(this.oldViewPortSize);
                        int horizontalScrollBarPolicy = jScrollPane.getHorizontalScrollBarPolicy();
                        double lastScaleFactor = canvas.zoomModel.getLastScaleFactor();
                        int n = newPolicy = lastScaleFactor == 1.0 ? 31 : 30;
                        if (horizontalScrollBarPolicy != newPolicy) {
                            jScrollPane.setHorizontalScrollBarPolicy(newPolicy);
                        }
                        if (vpSize.width != oldVpWidth) {
                            canvas.updateFlamegraphDimension(this.flamegraphSize, (int)((double)vpSize.width / lastScaleFactor));
                            vp.setViewSize(this.flamegraphSize);
                            int oldFlamegraphX = Math.abs(this.flamegraphLocation.x);
                            if (oldFlamegraphX > 0) {
                                double positionRatio = canvas.zoomModel.getLastUserInteractionStartX();
                                this.flamegraphLocation.x = Math.abs((int)(positionRatio * (double)this.flamegraphSize.width));
                                this.flamegraphLocation.y = Math.abs(this.flamegraphLocation.y);
                                vp.setViewPosition(this.flamegraphLocation);
                            }
                        } else {
                            super.layoutContainer(parent);
                            vp.getSize(this.oldViewPortSize);
                            canvas.getSize(this.flamegraphSize);
                            canvas.getLocation(this.flamegraphLocation);
                        }
                    }
                };
            }
        };
        jScrollPane.setViewport(viewport);
        jScrollPane.setViewportView(this.canvas);
        return jScrollPane;
    }

    @NotNull
    private JPanel wrap(@NotNull JComponent owner, final @NotNull @NotNull Consumer<@NotNull Color> configureBorderAndBackground) {
        JPanel wrapper = new JPanel(new BorderLayout()){

            @Override
            public void updateUI() {
                super.updateUI();
                configureBorderAndBackground.accept(this.getBackground());
            }

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
                configureBorderAndBackground.accept(bg);
            }
        };
        wrapper.setBorder(null);
        wrapper.add(owner);
        wrapper.putClientProperty(OWNER_KEY, this);
        return wrapper;
    }

    public void configureCanvas(@NotNull @NotNull Consumer<@NotNull JComponent> canvasConfigurer) {
        Objects.requireNonNull(canvasConfigurer).accept(this.canvas);
    }

    public void setFrameColorProvider(@NotNull @NotNull FrameColorProvider<@NotNull T> frameColorProvider) {
        this.canvas.getFlamegraphRenderEngine().getFrameRenderer().setFrameColorProvider(frameColorProvider);
    }

    @NotNull
    public @NotNull FrameColorProvider<@NotNull T> getFrameColorProvider() {
        return this.canvas.getFlamegraphRenderEngine().getFrameRenderer().getFrameColorProvider();
    }

    public void setFrameFontProvider(@NotNull @NotNull FrameFontProvider<@NotNull T> frameFontProvider) {
        this.canvas.getFlamegraphRenderEngine().getFrameRenderer().setFrameFontProvider(frameFontProvider);
    }

    @NotNull
    public @NotNull FrameFontProvider<@NotNull T> getFrameFontProvider() {
        return this.canvas.getFlamegraphRenderEngine().getFrameRenderer().getFrameFontProvider();
    }

    public void setFrameTextsProvider(@NotNull @NotNull FrameTextsProvider<@NotNull T> frameTextsProvider) {
        this.canvas.getFlamegraphRenderEngine().getFrameRenderer().setFrameTextsProvider(frameTextsProvider);
    }

    @NotNull
    public @NotNull FrameTextsProvider<@NotNull T> getFrameTextsProvider() {
        return this.canvas.getFlamegraphRenderEngine().getFrameRenderer().getFrameTextsProvider();
    }

    public void setFrameGapEnabled(boolean frameGapEnabled) {
        this.canvas.getFlamegraphRenderEngine().getFrameRenderer().setDrawingFrameGap(frameGapEnabled);
    }

    public boolean isFrameGapEnabled() {
        return this.canvas.getFlamegraphRenderEngine().getFrameRenderer().isDrawingFrameGap();
    }

    public void setMinimapShadeColorSupplier(@NotNull @NotNull Supplier<@NotNull Color> minimapShadeColorSupplier) {
        this.canvas.setMinimapShadeColorSupplier(Objects.requireNonNull(minimapShadeColorSupplier));
    }

    public void setShowMinimap(boolean showMinimap) {
        this.canvas.showMinimap(showMinimap);
    }

    public boolean isShowMinimap() {
        return this.canvas.isShowMinimap();
    }

    public void setShowHoveredSiblings(boolean showHoveredSiblings) {
        this.canvas.getFlamegraphRenderEngine().setShowHoveredSiblings(showHoveredSiblings);
    }

    public boolean isShowHoveredSiblings() {
        return this.canvas.getFlamegraphRenderEngine().isShowHoveredSiblings();
    }

    public void setMode(@NotNull Mode mode) {
        this.canvas.setMode(mode);
    }

    @NotNull
    public Mode getMode() {
        return this.canvas.getMode();
    }

    public void setTooltipComponentSupplier(@NotNull @NotNull Supplier<@NotNull JToolTip> tooltipComponentSupplier) {
        this.canvas.setTooltipComponentSupplier(Objects.requireNonNull(tooltipComponentSupplier));
    }

    public void setPopupConsumer(@NotNull @NotNull BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull MouseEvent> consumer) {
        this.canvas.setPopupConsumer(Objects.requireNonNull(consumer));
    }

    public void setSelectedFrameConsumer(@NotNull @NotNull BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull MouseEvent> consumer) {
        this.canvas.setSelectedFrameConsumer(Objects.requireNonNull(consumer));
    }

    public void setHoverListener(@NotNull @NotNull HoverListener<@NotNull T> hoverListener) {
        this.scrollPaneListener.setHoverListener(hoverListener);
    }

    public void setModel(@NotNull @NotNull FrameModel<@NotNull T> frameModel) {
        this.framesModel = Objects.requireNonNull(frameModel);
        this.canvas.setModel(frameModel);
        this.canvas.invalidate();
        this.component.revalidate();
        this.component.repaint();
    }

    public void setRenderConfiguration(@NotNull @NotNull FrameTextsProvider<@NotNull T> frameTextsProvider, @NotNull @NotNull FrameColorProvider<@NotNull T> frameColorProvider, @NotNull @NotNull FrameFontProvider<@NotNull T> frameFontProvider) {
        FlamegraphRenderEngine<T> flamegraphRenderEngine = new FlamegraphRenderEngine<T>(new FrameRenderer<T>(frameTextsProvider, frameColorProvider, frameFontProvider)).init(this.framesModel);
        this.canvas.setFlamegraphRenderEngine(flamegraphRenderEngine);
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    public void setTooltipTextFunction(@NotNull @NotNull BiFunction<@NotNull FrameModel<@NotNull T>, FrameBox<@NotNull T>, String> tooltipTextFunction) {
        this.canvas.setToolTipTextFunction(Objects.requireNonNull(tooltipTextFunction));
    }

    public void clear() {
        this.framesModel = FrameModel.empty();
        this.canvas.getFlamegraphRenderEngine().reset();
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    @NotNull
    public @NotNull FrameModel<@NotNull T> getFrameModel() {
        return this.framesModel;
    }

    @NotNull
    public @NotNull List<@NotNull FrameBox<@NotNull T>> getFrames() {
        return this.framesModel.frames;
    }

    public <V> void putClientProperty(@NotNull String key, V value) {
        this.canvas.putClientProperty(Objects.requireNonNull(key), value);
    }

    public <V> V getClientProperty(@NotNull String key) {
        return (V)this.canvas.getClientProperty(Objects.requireNonNull(key));
    }

    public void requestRepaint() {
        this.canvas.revalidate();
        this.canvas.repaint();
        this.canvas.triggerMinimapGeneration();
    }

    public void overrideZoomAction(@NotNull ZoomAction zoomActionOverride) {
        Objects.requireNonNull(zoomActionOverride);
        this.canvas.zoomActionOverride = zoomActionOverride;
    }

    public void resetZoom() {
        FlamegraphView.zoom(this.canvas, this.canvas.getResetZoomTarget());
    }

    public void zoomTo(@NotNull @NotNull FrameBox<@NotNull T> frame) {
        FlamegraphView.zoom(this.canvas, this.canvas.getFrameZoomTarget(frame));
    }

    private static <T> void zoom(@NotNull @NotNull FlamegraphCanvas<@NotNull T> canvas, @Nullable ZoomTarget<@NotNull T> zoomTarget) {
        if (zoomTarget == null) {
            return;
        }
        if (canvas.getMode() == Mode.FLAMEGRAPH) {
            Rectangle visibleRect = canvas.getVisibleRect();
            JViewport viewPort = (JViewport)SwingUtilities.getUnwrappedParent(canvas);
            JScrollPane scrollPane = (JScrollPane)viewPort.getParent();
            JScrollBar hsb = scrollPane.getHorizontalScrollBar();
            if (!hsb.isVisible() && visibleRect.getWidth() < zoomTarget.getWidth()) {
                Rectangle modifiedRect = zoomTarget.getTargetBounds();
                modifiedRect.y -= hsb.getPreferredSize().height;
                zoomTarget = new ZoomTarget(modifiedRect, zoomTarget.targetFrame);
            }
        }
        canvas.zoomModel.recordLastPositionFromZoomTarget(canvas, zoomTarget);
        if (canvas.zoomActionOverride == null || !canvas.zoomActionOverride.zoom(canvas, zoomTarget)) {
            canvas.zoom(zoomTarget);
        }
    }

    public void highlightFrames(@NotNull @NotNull Set<@NotNull FrameBox<@NotNull T>> framesToHighlight, @NotNull String searched) {
        Objects.requireNonNull(framesToHighlight);
        Objects.requireNonNull(searched);
        this.canvas.getFlamegraphRenderEngine().setHighlightFrames(framesToHighlight, searched);
        this.canvas.repaint();
    }

    static class FlamegraphCanvas<T>
    extends JPanel
    implements ZoomableComponent<T> {
        public static final String GRAPH_MODE_PROPERTY = "mode";
        public static final String SHOW_MINIMAP_PROPERTY = "minimap";
        public static final String FRAME_MODEL_PROPERTY = "frameModel";
        @Nullable
        private Image minimap;
        @Nullable
        private JToolTip toolTip;
        private FlamegraphRenderEngine<@NotNull T> flamegraphRenderEngine;
        private @Nullable BiFunction<@NotNull FrameModel<@NotNull T>, @NotNull FrameBox<@NotNull T>, @NotNull String> tooltipToTextFunction;
        @NotNull
        private Dimension flamegraphDimension = new Dimension();
        private final Rectangle minimapBounds = new Rectangle(50, 50, 200, 100);
        private final int minimapInset = 10;
        private @Nullable Supplier<@NotNull Color> minimapShadeColorSupplier = null;
        private boolean showMinimap = true;
        private @Nullable Supplier<@NotNull JToolTip> tooltipComponentSupplier;
        @Nullable
        private ZoomAction zoomActionOverride;
        private @Nullable BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull MouseEvent> popupConsumer;
        private @Nullable BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull MouseEvent> selectedFrameConsumer;
        @NotNull
        private final @NotNull FlamegraphView<@NotNull T> flamegraphView;
        private final ZoomModel<T> zoomModel = new ZoomModel();
        private long lastDrawTime;

        public FlamegraphCanvas(@NotNull @NotNull FlamegraphView<@NotNull T> flamegraphView) {
            this.flamegraphView = flamegraphView;
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            final FlamegraphCanvas fgCanvas = this;
            Container parent = SwingUtilities.getUnwrappedParent(fgCanvas);
            if (parent instanceof JViewport) {
                final JViewport viewport = (JViewport)parent;
                JScrollPane scrollPane = (JScrollPane)viewport.getParent();
                JScrollBar vsb = scrollPane.getVerticalScrollBar();
                vsb.addComponentListener(new ComponentAdapter(){
                    private int frameModelHashCode = 0;

                    @Override
                    public void componentShown(ComponentEvent e) {
                        if (fgCanvas.flamegraphRenderEngine != null && !fgCanvas.flamegraphRenderEngine.getFrameModel().frames.isEmpty()) {
                            int newHashCode = fgCanvas.flamegraphRenderEngine.getFrameModel().hashCode();
                            if (newHashCode == this.frameModelHashCode) {
                                return;
                            }
                            this.frameModelHashCode = newHashCode;
                        }
                        SwingUtilities.invokeLater(() -> {
                            int canvasWidth = fgCanvas.getWidth();
                            if (canvasWidth == 0) {
                                return;
                            }
                            fgCanvas.setSize(viewport2.getViewRect().width, this.getHeight());
                        });
                    }
                });
                this.installMinimapTriggers(fgCanvas, vsb);
                this.installVerticalScrollBarListeners(fgCanvas, vsb);
            }
        }

        private void installVerticalScrollBarListeners(FlamegraphCanvas<T> fgCanvas, JScrollBar vsb) {
            fgCanvas.addPropertyChangeListener(GRAPH_MODE_PROPERTY, evt -> SwingUtilities.invokeLater(() -> {
                int value = vsb.getValue();
                Rectangle bounds = fgCanvas.getBounds();
                Rectangle visibleRect = fgCanvas.getVisibleRect();
                switch (fgCanvas.getMode().ordinal()) {
                    case 1: {
                        vsb.setValue(value == vsb.getMaximum() ? vsb.getMinimum() : bounds.height - Math.abs(bounds.y) - visibleRect.height);
                        break;
                    }
                    case 0: {
                        vsb.setValue(value == vsb.getMinimum() ? vsb.getMaximum() : bounds.height - visibleRect.height - value);
                    }
                }
            }));
        }

        private void installMinimapTriggers(FlamegraphCanvas<T> fgCanvas, JScrollBar vsb) {
            PropertyChangeListener triggerMinimapOnPropertyChange = evt -> {
                String propertyName = evt.getPropertyName();
                if (!(propertyName.equals("preferredSize") || propertyName.equals(GRAPH_MODE_PROPERTY) || propertyName.equals(FRAME_MODEL_PROPERTY) || propertyName.equals(SHOW_MINIMAP_PROPERTY))) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (fgCanvas.isVisible()) {
                        fgCanvas.triggerMinimapGeneration();
                    }
                });
            };
            fgCanvas.addPropertyChangeListener(triggerMinimapOnPropertyChange);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension oldFlamegraphDimension = this.flamegraphDimension;
            Dimension preferredSize = new Dimension(10, 10);
            int flamegraphWidth = this.getWidth();
            if (this.flamegraphRenderEngine == null || flamegraphWidth == 0 || this.getGraphics() == null) {
                this.flamegraphDimension = preferredSize;
                this.firePropertyChange("preferredSize", oldFlamegraphDimension, preferredSize);
                return preferredSize;
            }
            int flamegraphHeight = this.flamegraphRenderEngine.computeVisibleFlamegraphHeight((Graphics2D)this.getGraphics(), flamegraphWidth, true);
            preferredSize.width = Math.max(preferredSize.width, flamegraphWidth);
            preferredSize.height = Math.max(preferredSize.height, flamegraphHeight);
            if (!this.flamegraphDimension.equals(preferredSize)) {
                this.flamegraphDimension = preferredSize;
                this.firePropertyChange("preferredSize", oldFlamegraphDimension, preferredSize);
            }
            return preferredSize;
        }

        @NotNull
        protected Dimension updateFlamegraphDimension(@NotNull Dimension dimension, int flamegraphWidth) {
            int flamegraphHeight = this.flamegraphRenderEngine.computeVisibleFlamegraphHeight((Graphics2D)this.getGraphics(), flamegraphWidth, true);
            dimension.width = flamegraphWidth;
            dimension.height = flamegraphHeight;
            return dimension;
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            long start = System.currentTimeMillis();
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle visibleRect = this.getVisibleRect();
            if (this.flamegraphRenderEngine == null) {
                String message = "No data to display";
                Font font = g2.getFont();
                Rectangle2D bounds = g2.getFontMetrics(font).getStringBounds(message, g2);
                int xx = visibleRect.x + (int)(((double)visibleRect.width - bounds.getWidth()) / 2.0);
                int yy = visibleRect.y + (int)(((double)visibleRect.height + bounds.getHeight()) / 2.0);
                g2.drawString(message, xx, yy);
                g2.dispose();
                return;
            }
            this.flamegraphRenderEngine.paint(g2, this.getBounds(), visibleRect);
            this.paintMinimap(g2, visibleRect);
            this.lastDrawTime = System.currentTimeMillis() - start;
            this.paintDetails(g2);
            g2.dispose();
        }

        private void paintDetails(@NotNull Graphics2D g2) {
            if (this.getClientProperty(FlamegraphView.SHOW_STATS) == Boolean.TRUE) {
                Rectangle viewRect = this.getVisibleRect();
                Rectangle bounds = this.getBounds();
                double zoomFactor = bounds.getWidth() / viewRect.getWidth();
                String stats = "Canvas (" + bounds.getWidth() + ", " + bounds.getHeight() + ") Zoom Factor " + zoomFactor + " Coordinate (" + viewRect.getX() + ", " + viewRect.getY() + ") View (" + viewRect.getWidth() + ", " + viewRect.getHeight() + "), Visible " + this.flamegraphRenderEngine.getVisibleDepth() + " Draw time: " + this.lastDrawTime + " ms";
                int frameTextPadding = 3;
                double w = viewRect.getWidth();
                int h = 16;
                double x = viewRect.getX();
                double y = this.getMode() == Mode.ICICLEGRAPH ? viewRect.getY() + viewRect.getHeight() - (double)h : viewRect.getY();
                g2.setColor(new Color(-1539293120, true));
                g2.fillRect((int)x, (int)y, (int)w, h);
                g2.setColor(Color.YELLOW);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.drawString(stats, (int)(x + (double)frameTextPadding), (int)(y + (double)h - (double)frameTextPadding));
            }
        }

        private void paintMinimap(@NotNull Graphics g, @NotNull Rectangle visibleRect) {
            if (this.showMinimap && this.minimap != null) {
                Graphics2D g2 = (Graphics2D)g.create(visibleRect.x + this.minimapBounds.x, visibleRect.y + visibleRect.height - this.minimapBounds.height - this.minimapBounds.y, this.minimapBounds.width + 20, this.minimapBounds.height + 20);
                g2.setColor(this.getBackground());
                int minimapRadius = 10;
                g2.fillRoundRect(1, 1, this.minimapBounds.width + 20 - 1, this.minimapBounds.height + 20 - 1, minimapRadius, minimapRadius);
                g2.drawImage(this.minimap, 10, 10, null);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setColor(this.getForeground());
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawRoundRect(1, 1, this.minimapBounds.width + 20 - 2, this.minimapBounds.height + 20 - 2, minimapRadius, minimapRadius);
                double zoomZoneScaleX = (double)this.minimapBounds.width / (double)this.flamegraphDimension.width;
                double zoomZoneScaleY = (double)this.minimapBounds.height / (double)this.flamegraphDimension.height;
                int x = (int)((double)visibleRect.x * zoomZoneScaleX);
                int y = (int)((double)visibleRect.y * zoomZoneScaleY);
                int w = Math.min((int)((double)visibleRect.width * zoomZoneScaleX), this.minimapBounds.width);
                int h = Math.min((int)((double)visibleRect.height * zoomZoneScaleY), this.minimapBounds.height);
                Area zoomZone = new Area(new Rectangle(10, 10, this.minimapBounds.width, this.minimapBounds.height));
                zoomZone.subtract(new Area(new Rectangle(x + 10, y + 10, w, h)));
                Color color = this.minimapShadeColorSupplier == null ? new Color(this.getBackground().getRGB() & 0x90FFFFFF, true) : this.minimapShadeColorSupplier.get();
                g2.setColor(color);
                g2.fill(zoomZone);
                g2.setColor(this.getForeground());
                g2.setStroke(new BasicStroke(1.0f));
                g2.drawRect(x + 10, y + 10, w, h);
                g2.dispose();
            }
        }

        @Override
        @Nullable
        public String getToolTipText(@NotNull MouseEvent e) {
            if (this.isInsideMinimap(e.getPoint())) {
                return "";
            }
            return super.getToolTipText(e);
        }

        public boolean isInsideMinimap(@NotNull Point point) {
            if (!this.showMinimap) {
                return false;
            }
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle rectangle = new Rectangle(visibleRect.x + this.minimapBounds.y, visibleRect.y + visibleRect.height - this.minimapBounds.height - this.minimapBounds.y, this.minimapBounds.width + 20, this.minimapBounds.height + 20);
            return rectangle.contains(point);
        }

        public void setToolTipText(FrameBox<T> frame) {
            if (this.tooltipToTextFunction == null) {
                return;
            }
            this.setToolTipText(this.tooltipToTextFunction.apply(this.flamegraphView.framesModel, frame));
        }

        @Override
        @NotNull
        public JToolTip createToolTip() {
            if (this.tooltipComponentSupplier == null) {
                return super.createToolTip();
            }
            if (this.toolTip == null) {
                this.toolTip = this.tooltipComponentSupplier.get();
                this.toolTip.setComponent(this);
            }
            return this.toolTip;
        }

        private void triggerMinimapGeneration() {
            if (!this.showMinimap || this.flamegraphRenderEngine == null) {
                this.repaintMinimapArea();
                return;
            }
            CompletableFuture.runAsync(() -> {
                int height = this.flamegraphRenderEngine.computeVisibleFlamegraphMinimapHeight(this.minimapBounds.width);
                if (height <= 1) {
                    return;
                }
                GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsConfiguration c = e.getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage minimapImage = c.createCompatibleImage(this.minimapBounds.width, height, 3);
                Graphics2D minimapGraphics = minimapImage.createGraphics();
                minimapGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                minimapGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                minimapGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                Rectangle bounds = new Rectangle(this.minimapBounds.width, height);
                this.flamegraphRenderEngine.paintMinimap(minimapGraphics, bounds);
                minimapGraphics.dispose();
                SwingUtilities.invokeLater(() -> this.setMinimapImage(minimapImage));
            }).handle((__, t) -> {
                if (t != null) {
                    System.getLogger(FlamegraphCanvas.class.getName()).log(System.Logger.Level.ERROR, "Error generating minimap, no thumbnail", (Throwable)t);
                }
                return null;
            });
        }

        private void setMinimapImage(@NotNull BufferedImage minimapImage) {
            this.minimap = minimapImage.getScaledInstance(this.minimapBounds.width, this.minimapBounds.height, 4);
            this.repaintMinimapArea();
        }

        private void repaintMinimapArea() {
            Rectangle visibleRect = this.getVisibleRect();
            this.repaint(visibleRect.x + this.minimapBounds.x, visibleRect.y + visibleRect.height - this.minimapBounds.height - this.minimapBounds.y, this.minimapBounds.width + 20, this.minimapBounds.height + 20);
        }

        public void setupListeners(final @NotNull JScrollPane scrollPane) {
            MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
                private Point pressedPoint;

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    if (e.getClickCount() != 1 || e.getButton() != 1) {
                        return;
                    }
                    if (selectedFrameConsumer == null) {
                        return;
                    }
                    FlamegraphCanvas canvas = this;
                    flamegraphRenderEngine.getFrameAt((Graphics2D)canvas.getGraphics(), canvas.getBounds(), e.getPoint()).ifPresent(frame -> selectedFrameConsumer.accept((FrameBox<FrameBox>)frame, e));
                }

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (this.isInsideMinimap(e.getPoint())) {
                            this.processMinimapMouseEvent(e);
                            this.pressedPoint = e.getPoint();
                        } else {
                            this.pressedPoint = null;
                        }
                        return;
                    }
                    this.handlePopup(e);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent e) {
                    this.handlePopup(e);
                }

                private void handlePopup(@NotNull MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        return;
                    }
                    if (popupConsumer == null) {
                        return;
                    }
                    FlamegraphCanvas canvas = this;
                    flamegraphRenderEngine.getFrameAt((Graphics2D)canvas.getGraphics(), canvas.getBounds(), e.getPoint()).ifPresent(frame -> popupConsumer.accept((FrameBox<FrameBox>)frame, e));
                }

                @Override
                public void mouseDragged(@NotNull MouseEvent e) {
                    if (this.isInsideMinimap(e.getPoint()) && this.pressedPoint != null) {
                        this.processMinimapMouseEvent(e);
                    }
                }

                private void processMinimapMouseEvent(@NotNull MouseEvent e) {
                    Point pt = e.getPoint();
                    if (!(e.getComponent() instanceof FlamegraphCanvas)) {
                        return;
                    }
                    Rectangle visibleRect = ((FlamegraphCanvas)e.getComponent()).getVisibleRect();
                    double zoomZoneScaleX = (double)minimapBounds.width / (double)flamegraphDimension.width;
                    double zoomZoneScaleY = (double)minimapBounds.height / (double)flamegraphDimension.height;
                    double h = (double)(pt.x - (visibleRect.x + minimapBounds.x)) / zoomZoneScaleX;
                    BoundedRangeModel horizontalBarModel = scrollPane.getHorizontalScrollBar().getModel();
                    horizontalBarModel.setValue((int)h - horizontalBarModel.getExtent());
                    double v = (double)(pt.y - (visibleRect.y + visibleRect.height - minimapBounds.height - minimapBounds.y)) / zoomZoneScaleY;
                    BoundedRangeModel verticalBarModel = scrollPane.getVerticalScrollBar().getModel();
                    verticalBarModel.setValue((int)v - verticalBarModel.getExtent());
                }

                @Override
                public void mouseMoved(@NotNull MouseEvent e) {
                    this.setCursor(this.isInsideMinimap(e.getPoint()) ? Cursor.getPredefinedCursor(System.getProperty("os.name").startsWith("Mac") ? 12 : 13) : Cursor.getDefaultCursor());
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            new UserPositionRecorder(this).install(scrollPane);
        }

        void setFlamegraphRenderEngine(@NotNull @NotNull FlamegraphRenderEngine<@NotNull T> flamegraphRenderEngine) {
            this.flamegraphRenderEngine = flamegraphRenderEngine;
        }

        @NotNull
        @NotNull FlamegraphRenderEngine<@NotNull T> getFlamegraphRenderEngine() {
            return this.flamegraphRenderEngine;
        }

        public void setToolTipTextFunction(@NotNull @NotNull BiFunction<@NotNull FrameModel<@NotNull T>, FrameBox<@NotNull T>, @NotNull String> tooltipTextFunction) {
            this.tooltipToTextFunction = tooltipTextFunction;
        }

        public void setTooltipComponentSupplier(@NotNull @NotNull Supplier<@NotNull JToolTip> tooltipComponentSupplier) {
            this.tooltipComponentSupplier = tooltipComponentSupplier;
        }

        public void setMinimapShadeColorSupplier(@NotNull @NotNull Supplier<@NotNull Color> minimapShadeColorSupplier) {
            this.minimapShadeColorSupplier = minimapShadeColorSupplier;
        }

        public void showMinimap(boolean showMinimap) {
            if (this.showMinimap == showMinimap) {
                return;
            }
            this.showMinimap = showMinimap;
            this.firePropertyChange(SHOW_MINIMAP_PROPERTY, !showMinimap, showMinimap);
        }

        public boolean isShowMinimap() {
            return this.showMinimap;
        }

        public void setMode(@NotNull Mode mode) {
            Mode oldMode = this.getMode();
            if (oldMode == mode) {
                return;
            }
            this.getFlamegraphRenderEngine().setIcicle(Mode.ICICLEGRAPH == mode);
            this.firePropertyChange(GRAPH_MODE_PROPERTY, (Object)oldMode, (Object)mode);
        }

        @NotNull
        public Mode getMode() {
            return this.getFlamegraphRenderEngine().isIcicle() ? Mode.ICICLEGRAPH : Mode.FLAMEGRAPH;
        }

        public void setModel(@NotNull @NotNull FrameModel<@NotNull T> frameModel) {
            FrameModel<T> oldModel = this.getFlamegraphRenderEngine().getFrameModel();
            if (frameModel == oldModel) {
                return;
            }
            this.getFlamegraphRenderEngine().init(frameModel);
            this.firePropertyChange(FRAME_MODEL_PROPERTY, oldModel, frameModel);
        }

        public void setPopupConsumer(@NotNull @NotNull BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull MouseEvent> consumer) {
            this.popupConsumer = consumer;
        }

        public void setSelectedFrameConsumer(@NotNull @NotNull BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull MouseEvent> consumer) {
            this.selectedFrameConsumer = consumer;
        }

        public @Nullable ZoomTarget<@NotNull T> getResetZoomTarget() {
            Graphics2D graphics = (Graphics2D)this.getGraphics();
            if (graphics == null) {
                return null;
            }
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle bounds = this.getBounds();
            int newHeight = this.flamegraphRenderEngine.computeVisibleFlamegraphHeight(graphics, visibleRect.width);
            return new ZoomTarget(0, this.getMode() == Mode.FLAMEGRAPH ? -(bounds.height - visibleRect.height) : 0, visibleRect.width, newHeight, null);
        }

        public @Nullable ZoomTarget<@NotNull T> getFrameZoomTarget(@NotNull FrameBox<T> frame) {
            Graphics2D graphics = (Graphics2D)this.getGraphics();
            if (graphics == null) {
                return null;
            }
            return this.flamegraphRenderEngine.calculateZoomTargetFrame(graphics, this.getBounds(), this.getVisibleRect(), frame, 2, 0);
        }

        @Override
        public void zoom(@NotNull @NotNull ZoomTarget<@NotNull T> zoomTarget) {
            this.setBounds(zoomTarget.getTargetBounds());
        }
    }

    private static class FlamegraphHoveringScrollPaneMouseListener<T>
    implements MouseInputListener,
    FocusListener {
        private Point pressedPoint;
        private final FlamegraphCanvas<T> canvas;
        private Rectangle hoveredFrameRectangle;
        private HoverListener<T> hoverListener;
        private FrameBox<T> hoveredFrame;
        private final Rectangle tmpBounds = new Rectangle();

        public FlamegraphHoveringScrollPaneMouseListener(@NotNull @NotNull FlamegraphCanvas<@NotNull T> canvas) {
            this.canvas = canvas;
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e.getSource() instanceof JScrollPane && this.pressedPoint != null) {
                JScrollPane scrollPane = (JScrollPane)e.getComponent();
                JViewport viewPort = scrollPane.getViewport();
                if (viewPort == null) {
                    return;
                }
                int dx = e.getX() - this.pressedPoint.x;
                int dy = e.getY() - this.pressedPoint.y;
                Point viewPortViewPosition = viewPort.getViewPosition();
                viewPort.setViewPosition(new Point(Math.max(0, viewPortViewPosition.x - dx), Math.max(0, viewPortViewPosition.y - dy)));
                this.pressedPoint = e.getPoint();
                e.consume();
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.canvas.isInsideMinimap(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.canvas))) {
                    this.pressedPoint = null;
                    return;
                }
                this.pressedPoint = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            this.pressedPoint = null;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) && e.getSource() instanceof JScrollPane) {
                return;
            }
            JScrollPane scrollPane = (JScrollPane)e.getComponent();
            JViewport viewPort = scrollPane.getViewport();
            scrollPane.requestFocus();
            Point latestMouseLocation = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(latestMouseLocation, this.canvas);
            if (this.canvas.isInsideMinimap(latestMouseLocation)) {
                return;
            }
            if (e.getClickCount() == 2) {
                this.canvas.getFlamegraphRenderEngine().calculateZoomTargetForFrameAt((Graphics2D)this.canvas.getGraphics(), this.canvas.getBounds(this.tmpBounds), this.canvas.getVisibleRect(), latestMouseLocation).ifPresent(zoomTarget -> FlamegraphView.zoom(this.canvas, zoomTarget));
                return;
            }
            this.canvas.getFlamegraphRenderEngine().toggleSelectedFrameAt((Graphics2D)viewPort.getView().getGraphics(), this.canvas.getBounds(this.tmpBounds), latestMouseLocation, (frame, r) -> this.canvas.repaint());
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e.getSource() instanceof JScrollPane) {
                JScrollPane source = (JScrollPane)e.getSource();
                this.hoveredFrameRectangle = null;
                this.hoveredFrame = null;
                this.canvas.getFlamegraphRenderEngine().stopHover((Graphics2D)this.canvas.getGraphics(), this.canvas.getBounds(this.tmpBounds), this.canvas::repaint);
                this.canvas.repaint();
                Point latestMouseLocation = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(latestMouseLocation, source);
                if (this.hoverListener != null && !source.getBounds(this.tmpBounds).contains(latestMouseLocation)) {
                    this.hoverListener.onStopHover(this.hoveredFrame, null, e);
                }
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Point latestMouseLocation = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(latestMouseLocation, this.canvas);
            if (this.canvas.isInsideMinimap(latestMouseLocation)) {
                if (this.hoverListener != null) {
                    this.hoverListener.onStopHover(this.hoveredFrame, this.hoveredFrameRectangle, e);
                }
                return;
            }
            if (this.hoveredFrameRectangle != null && this.hoveredFrameRectangle.contains(latestMouseLocation)) {
                if (this.hoverListener != null) {
                    this.hoverListener.onFrameHover(this.hoveredFrame, this.hoveredFrameRectangle, e);
                }
                return;
            }
            FlamegraphRenderEngine<T> fgp = this.canvas.getFlamegraphRenderEngine();
            Graphics2D canvasGraphics = (Graphics2D)this.canvas.getGraphics();
            Rectangle canvasBounds = this.canvas.getBounds(this.tmpBounds);
            fgp.getFrameAt(canvasGraphics, canvasBounds, latestMouseLocation).ifPresentOrElse(frame -> {
                fgp.hoverFrame((FrameBox<T>)frame, canvasGraphics, canvasBounds, this.canvas::repaint);
                this.canvas.setToolTipText((FrameBox<T>)frame);
                this.hoveredFrameRectangle = fgp.getFrameRectangle(canvasGraphics, canvasBounds, (FrameBox<T>)frame);
                this.hoveredFrame = frame;
                if (this.hoverListener != null) {
                    this.hoverListener.onFrameHover((FrameBox<T>)frame, this.hoveredFrameRectangle, e);
                }
            }, () -> {
                fgp.stopHover(canvasGraphics, canvasBounds, this.canvas::repaint);
                Rectangle prevHoveredFrameRectangle = this.hoveredFrameRectangle;
                FrameBox<T> prevHoveredFrame = this.hoveredFrame;
                this.hoveredFrameRectangle = null;
                this.hoveredFrame = null;
                if (this.hoverListener != null) {
                    this.hoverListener.onStopHover(prevHoveredFrame, prevHoveredFrameRectangle, e);
                }
            });
        }

        public void setHoverListener(HoverListener<T> hoveringListener) {
            this.hoverListener = hoveringListener;
        }

        @Override
        public void focusGained(@NotNull FocusEvent e) {
        }

        @Override
        public void focusLost(@NotNull FocusEvent e) {
        }

        public void install(@NotNull JScrollPane sp) {
            sp.addMouseListener(this);
            sp.addMouseMotionListener(this);
            sp.addFocusListener(this);
        }
    }

    public static enum Mode {
        FLAMEGRAPH,
        ICICLEGRAPH;

    }

    public static interface HoverListener<T> {
        default public void onStopHover(@Nullable FrameBox<@NotNull T> previousHoveredFrame, @Nullable Rectangle prevHoveredFrameRectangle, @NotNull MouseEvent e) {
        }

        public void onFrameHover(@NotNull @NotNull FrameBox<@NotNull T> var1, @NotNull Rectangle var2, @NotNull MouseEvent var3);

        @NotNull
        public static Point getPointLeveledToFrameDepth(@NotNull MouseEvent mouseEvent, @NotNull Rectangle frameRect) {
            JScrollPane scrollPane = (JScrollPane)mouseEvent.getComponent();
            Component canvas = scrollPane.getViewport().getView();
            FlamegraphView ownerFg = FlamegraphView.from(scrollPane).orElseThrow(() -> new IllegalStateException("Cannot find FlamegraphView owner"));
            Point pointOnCanvas = SwingUtilities.convertPoint(scrollPane, mouseEvent.getPoint(), canvas);
            pointOnCanvas.y = frameRect.y;
            return SwingUtilities.convertPoint(canvas, pointOnCanvas, ownerFg.component);
        }
    }

    public static interface ZoomAction {
        public <T> boolean zoom(@NotNull ZoomableComponent<T> var1, @NotNull ZoomTarget<T> var2);
    }

    @ApiStatus.Experimental
    private static class ZoomModel<T> {
        @Nullable
        private ZoomTarget<T> currentZoomTarget = null;
        private double lastUserInteractionStartX = 0.0;
        private double lastUserInteractionEndX = 0.0;
        private double lastScaleFactor = 1.0;
        private final Rectangle canvasVisibleRect = new Rectangle();

        private ZoomModel() {
        }

        public void recordLastPositionFromZoomTarget(JPanel canvas, @Nullable ZoomTarget<T> currentZoomTarget) {
            this.currentZoomTarget = currentZoomTarget;
            if (currentZoomTarget == null || currentZoomTarget.targetFrame == null) {
                this.lastUserInteractionStartX = 0.0;
                this.lastUserInteractionEndX = 1.0;
                this.lastScaleFactor = 1.0;
            } else {
                this.lastUserInteractionStartX = currentZoomTarget.targetFrame.startX;
                this.lastUserInteractionEndX = currentZoomTarget.targetFrame.endX;
                canvas.computeVisibleRect(this.canvasVisibleRect);
                this.lastScaleFactor = FlamegraphRenderEngine.getScaleFactor(this.canvasVisibleRect.width, currentZoomTarget.getWidth(), 1.0);
            }
        }

        public void recordLastPositionFromUserInteraction(JPanel canvas) {
            int width = canvas.getWidth();
            canvas.computeVisibleRect(this.canvasVisibleRect);
            this.lastUserInteractionStartX = (double)this.canvasVisibleRect.x / (double)width;
            this.lastUserInteractionEndX = ((double)this.canvasVisibleRect.x + (double)this.canvasVisibleRect.width) / (double)width;
            this.lastScaleFactor = FlamegraphRenderEngine.getScaleFactor(this.canvasVisibleRect.width, width, 1.0);
        }

        @Nullable
        public ZoomTarget<T> getCurrentZoomTarget() {
            return this.currentZoomTarget;
        }

        private double getLastUserInteractionStartX() {
            return this.lastUserInteractionStartX;
        }

        private double getLastUserInteractionEndX() {
            return this.lastUserInteractionEndX;
        }

        private double getLastUserInteractionWidthX() {
            return this.lastUserInteractionEndX - this.lastUserInteractionStartX;
        }

        public double getLastScaleFactor() {
            return this.lastScaleFactor;
        }
    }

    public static interface ZoomableComponent<T> {
        public void zoom(@NotNull ZoomTarget<T> var1);

        public int getWidth();

        public int getHeight();

        @NotNull
        public Point getLocation();
    }

    private static class UserPositionRecorder
    extends MouseAdapter {
        private final FlamegraphCanvas<?> canvas;

        public <T> UserPositionRecorder(FlamegraphCanvas<T> canvas) {
            this.canvas = canvas;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.canvas.zoomModel.recordLastPositionFromUserInteraction(this.canvas);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.canvas.zoomModel.recordLastPositionFromUserInteraction(this.canvas);
        }

        public void install(JScrollPane scrollPane) {
            scrollPane.addMouseListener(this);
            scrollPane.addMouseWheelListener(this);
            scrollPane.getHorizontalScrollBar().addMouseListener(this);
            final KeyStroke[] registeredKeyStrokes = scrollPane.getRegisteredKeyStrokes();
            scrollPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    for (KeyStroke keyStroke : registeredKeyStrokes) {
                        if (e.getKeyCode() != keyStroke.getKeyCode() || e.getModifiersEx() != keyStroke.getModifiers()) continue;
                        canvas.zoomModel.recordLastPositionFromUserInteraction(canvas);
                        break;
                    }
                }
            });
        }
    }
}

