/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import java.util.StringJoiner;

public abstract class FrameRenderingFlags {
    public static final int MINIMAP_MODE = 1;
    public static final int HIGHLIGHTING = 2;
    public static final int HIGHLIGHTED_FRAME = 4;
    public static final int HOVERED = 8;
    public static final int HOVERED_SIBLING = 16;
    public static final int FOCUSING = 32;
    public static final int FOCUSED_FRAME = 64;
    public static final int PARTIAL_FRAME = 128;

    public static int toFlags(boolean minimapMode, boolean highlightingOn, boolean highlighted, boolean hovered, boolean hoveredSibling, boolean focusing, boolean focusedFrame, boolean partialFrame) {
        return (minimapMode ? 1 : 0) | (highlightingOn ? 2 : 0) | (highlighted ? 4 : 0) | (hovered ? 8 : 0) | (hoveredSibling ? 16 : 0) | (focusing ? 32 : 0) | (focusedFrame ? 64 : 0) | (partialFrame ? 128 : 0);
    }

    public static String toString(int flags) {
        StringJoiner sb = new StringJoiner(", ", "[", "]");
        if ((flags & 1) != 0) {
            sb.add("minimapMode");
        }
        if ((flags & 2) != 0) {
            sb.add("highlighting");
        }
        if ((flags & 4) != 0) {
            sb.add("highlighted");
        }
        if ((flags & 8) != 0) {
            sb.add("hovered");
        }
        if ((flags & 0x10) != 0) {
            sb.add("hovered sibling");
        }
        if ((flags & 0x20) != 0) {
            sb.add("focusing");
        }
        if ((flags & 0x40) != 0) {
            sb.add("focused");
        }
        if ((flags & 0x80) != 0) {
            sb.add("partial");
        }
        return sb.toString();
    }

    public static boolean isMinimapMode(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isHighlighting(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isHighlightedFrame(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isHovered(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isHoveredSibling(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isFocusing(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isFocusedFrame(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isPartialFrame(int flags) {
        return (flags & 0x80) != 0;
    }

    private FrameRenderingFlags() {
    }
}

