/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.rjmx.ui.attributes.QuantityInputDialog;
import org.openjdk.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;

public class SetUnitMenuManager
extends MenuManager {
    private final IConnectionHandle m_connection;
    IMenuManager m_supermenu;
    Collection<ReadOnlyMRIAttribute> m_selectedAttributes = Collections.emptyList();
    Map<String, Action> m_unitActions;
    private final Map<KindOfQuantity<?>, CustomUnitAction> m_customActions;
    Action m_rawAction;

    public SetUnitMenuManager(ISelectionProvider selectionProvider, IConnectionHandle connection, IMenuManager supermenu) {
        super(Messages.SetUnitMenuManager_SET_UNIT_MENU_ITEM);
        this.setVisible(false);
        this.m_connection = connection;
        this.m_supermenu = supermenu;
        this.m_unitActions = new HashMap<String, Action>();
        this.m_customActions = new HashMap();
        this.m_rawAction = new Action(Messages.SetUnitMenuManager_RAW_VALUE_MENU_ITEM){

            public void run() {
                SetUnitMenuManager.this.setUnit(SetUnitMenuManager.this.m_selectedAttributes, null);
                SetUnitMenuManager.this.uncheckAllUnitActions();
                this.setChecked(true);
            }
        };
        this.add((IAction)this.m_rawAction);
        for (KindOfQuantity contentType : UnitLookup.getKindsOfQuantity()) {
            String label = NLS.bind((String)Messages.SetUnitMenuManager_KIND_OF_QUANTITY_BY_MULTIPLYING_WITH_MSG, (Object)contentType.getName());
            MenuManager typeManager = new MenuManager(label);
            for (final IUnit unit : contentType.getCommonUnits()) {
                Action action = new Action(unit.getLocalizedDescription(), 2){

                    public void run() {
                        SetUnitMenuManager.this.setUnit(SetUnitMenuManager.this.m_selectedAttributes, unit);
                        SetUnitMenuManager.this.uncheckAllUnitActions();
                        this.setChecked(true);
                    }
                };
                this.m_unitActions.put(UnitLookup.getUnitIdentifier((IUnit)unit), action);
                typeManager.add((IAction)action);
            }
            if (contentType instanceof LinearKindOfQuantity) {
                LinearKindOfQuantity kindOfQuantity = (LinearKindOfQuantity)contentType;
                CustomUnitAction action = new CustomUnitAction(kindOfQuantity);
                this.m_customActions.put((KindOfQuantity<?>)kindOfQuantity, action);
                typeManager.add((IAction)action);
            }
            this.add((IContributionItem)typeManager);
        }
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IMRIMetadataService infoService = (IMRIMetadataService)SetUnitMenuManager.this.m_connection.getServiceOrNull(IMRIMetadataService.class);
                if (infoService != null && SetUnitMenuManager.this.selectionIsNumeric(infoService, event)) {
                    SetUnitMenuManager.this.m_selectedAttributes = SetUnitMenuManager.this.selectedAttributes(event);
                    SetUnitMenuManager.this.checkSelectedUnitAction(infoService);
                    SetUnitMenuManager.this.setVisible(true);
                } else {
                    SetUnitMenuManager.this.setVisible(false);
                }
                SetUnitMenuManager.this.m_supermenu.update(true);
            }
        });
    }

    private void setUnit(Collection<ReadOnlyMRIAttribute> m_selectedAttributes, IUnit unit) {
        IMRIMetadataService infoService;
        String unitIdentifier = null;
        if (unit != null) {
            unitIdentifier = UnitLookup.getUnitIdentifier((IUnit)unit);
        }
        if ((infoService = (IMRIMetadataService)this.m_connection.getServiceOrNull(IMRIMetadataService.class)) != null) {
            for (ReadOnlyMRIAttribute attribute : m_selectedAttributes) {
                infoService.setMetadata(attribute.getMRI(), "UnitString", unitIdentifier);
            }
        }
    }

    private Collection<ReadOnlyMRIAttribute> selectedAttributes(SelectionChangedEvent event) {
        ArrayList<ReadOnlyMRIAttribute> attributes = new ArrayList<ReadOnlyMRIAttribute>();
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof ReadOnlyMRIAttribute)) continue;
            attributes.add((ReadOnlyMRIAttribute)((Object)selectedObject));
        }
        return attributes;
    }

    /*
     * Unable to fully structure code
     */
    private boolean selectionIsNumeric(IMRIMetadataService infoService, SelectionChangedEvent event) {
        selection = (StructuredSelection)event.getSelection();
        selectionIterator = selection.iterator();
        if (selectionIterator.hasNext()) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            selectedObject = selectionIterator.next();
            if (selectedObject instanceof ReadOnlyMRIAttribute) {
                attribute = (ReadOnlyMRIAttribute)selectedObject;
                if (MRIMetadataToolkit.isNumerical((IMRIMetadata)infoService.getMetadata(attribute.getMRI()))) continue;
                return false;
            }
            return false;
lbl11:
            // 2 sources

            ** while (selectionIterator.hasNext())
        }
lbl12:
        // 1 sources

        return true;
    }

    private void checkSelectedUnitAction(IMRIMetadataService infoService) {
        HashSet<String> selectedUnits = new HashSet<String>();
        for (ReadOnlyMRIAttribute attribute : this.m_selectedAttributes) {
            selectedUnits.add(infoService.getMetadata(attribute.getMRI()).getUnitString());
        }
        this.uncheckAllUnitActions();
        if (selectedUnits.size() == 1) {
            for (String selectedUnit : selectedUnits) {
                CustomUnitAction custAction;
                IUnit unit;
                Action action;
                Action action2 = action = selectedUnit == null ? this.m_rawAction : this.m_unitActions.get(selectedUnit);
                if (action == null && (unit = UnitLookup.getUnitOrNull((String)selectedUnit)) instanceof LinearUnit && (custAction = this.m_customActions.get(unit.getContentType())) != null) {
                    custAction.setUnit((LinearUnit)unit);
                    action = custAction;
                }
                if (action == null) continue;
                action.setChecked(true);
            }
        }
    }

    private void uncheckAllUnitActions() {
        this.m_rawAction.setChecked(false);
        for (Action action : this.m_unitActions.values()) {
            action.setChecked(false);
        }
        for (Action action : this.m_customActions.values()) {
            action.setChecked(false);
        }
    }

    private class CustomUnitAction
    extends Action {
        private final LinearKindOfQuantity kindOfQuantity;
        private LinearUnit unit;

        private CustomUnitAction(LinearKindOfQuantity kindOfQuantity) {
            super(Messages.SetUnitMenuManager_CUSTOM_UNIT_MENU_ITEM, 2);
            this.kindOfQuantity = kindOfQuantity;
        }

        private void setUnit(LinearUnit unit) {
            this.unit = unit;
            if (unit != null) {
                this.setText(NLS.bind((String)Messages.SetUnitMenuManager_CUSTOM_UNIT_MENU_ITEM_MSG, (Object)unit.getLocalizedDescription()));
            } else {
                this.setText(Messages.SetUnitMenuManager_CUSTOM_UNIT_MENU_ITEM);
            }
        }

        public void run() {
            LinearUnit initialUnit = this.unit != null ? this.unit : this.kindOfQuantity.getDefaultUnit();
            ITypedQuantity initialQuantity = initialUnit.asWellKnownQuantity();
            Shell shell = Display.getCurrent().getActiveShell();
            ITypedQuantity<LinearUnit> quantity = QuantityInputDialog.promptForCustomUnit(shell, (ITypedQuantity<LinearUnit>)initialQuantity);
            if (quantity != null) {
                String id = quantity.persistableString();
                LinearUnit newUnit = this.kindOfQuantity.getCachedUnit((Object)id);
                if (newUnit == null) {
                    newUnit = this.kindOfQuantity.makeCustomUnit(quantity);
                }
                SetUnitMenuManager.this.setUnit(SetUnitMenuManager.this.m_selectedAttributes, (IUnit)newUnit);
                SetUnitMenuManager.this.uncheckAllUnitActions();
                this.setUnit(newUnit);
                this.setChecked(true);
            }
        }
    }
}

