/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.internal.AttributeConfiguratorWizardPage;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionContentModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionViewModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectorWizardPage;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSelectionContentListener;

public class AttributeSelectorWizard
extends Wizard {
    private final AttributeSelectionViewModel m_viewModel;
    private AttributeSelectionContentModel m_selectorModel;

    public AttributeSelectorWizard(AttributeSelectionViewModel viewModel) {
        this.setDialogSettings(RJMXUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(viewModel.getWizardTitle());
        this.m_viewModel = viewModel;
    }

    public void setInput(AttributeSelectionContentModel selectorModel) {
        this.m_selectorModel = selectorModel;
    }

    public void addPages() {
        this.addPage((IWizardPage)new AttributeSelectorWizardPage(this.m_viewModel, this.m_selectorModel));
        this.addPage((IWizardPage)new AttributeConfiguratorWizardPage(this.m_viewModel, this.m_selectorModel));
        this.m_selectorModel.addListener(new IAttributeSelectionContentListener(){

            @Override
            public void selectionChanged(AttributeSelectionContentModel selectorModel) {
                MRI[] selectedAttributes;
                if (AttributeSelectorWizard.this.m_selectorModel != null && (selectedAttributes = selectorModel.getSelectedAttributes()).length > 0) {
                    boolean linkConfigurePage = false;
                    IMRIMetadataService metadataService = AttributeSelectorWizard.this.m_selectorModel.getMetadataService();
                    MRI[] mRIArray = selectedAttributes;
                    int n = selectedAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IUnit unit;
                        MRI mri = mRIArray[n2];
                        IMRIMetadata metadata = metadataService.getMetadata(mri);
                        if (MRIMetadataToolkit.isNumerical((IMRIMetadata)metadata) && (unit = UnitLookup.getUnitOrNull((String)metadata.getUnitString())) == null) {
                            linkConfigurePage = true;
                        }
                        ++n2;
                    }
                    if (linkConfigurePage) {
                        AttributeSelectorWizard.this.getAttributeSelectorWizardPage().setNextPage((IWizardPage)AttributeSelectorWizard.this.getAttributeConfiguratorWizardPage());
                    } else {
                        AttributeSelectorWizard.this.getAttributeSelectorWizardPage().setNextPage(null);
                    }
                }
            }
        });
    }

    private AttributeSelectorWizardPage getAttributeSelectorWizardPage() {
        return (AttributeSelectorWizardPage)this.getPage("org.openjdk.jmc.rjmx.attribute.selection");
    }

    private AttributeConfiguratorWizardPage getAttributeConfiguratorWizardPage() {
        return (AttributeConfiguratorWizardPage)this.getPage("org.openjdk.jmc.rjmx.attribute.configuration");
    }

    public MRI[] getSelectedAttributes() {
        return this.m_selectorModel.getSelectedAttributes();
    }

    public boolean performFinish() {
        this.m_selectorModel.commitUnitChanges();
        return true;
    }
}

