/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.action;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;
import org.openjdk.jmc.alert.AlertObject;
import org.openjdk.jmc.alert.AlertPlugin;
import org.openjdk.jmc.alert.NotificationUIToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.action.Messages;
import org.openjdk.jmc.console.ui.notification.action.TriggerActionRecordingToolkit;
import org.openjdk.jmc.flightrecorder.configuration.FlightRecorderException;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.flightrecorder.configuration.recording.RecordingOptionsBuilder;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.triggers.IActivatableTriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;
import org.openjdk.jmc.ui.MCPathEditorInput;
import org.openjdk.jmc.ui.WorkbenchToolkit;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.common.util.StatusFactory;

public class TriggerActionStartTimeBoundRecording
extends TriggerAction
implements IActivatableTriggerAction {
    public static final int MAX_CONTINUOUS_ERROR_COUNT = 10;
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            NotificationPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        this.startTimeBoundRecording(service, event);
    }

    private void startTimeBoundRecording(IFlightRecorderService service, TriggerEvent event) throws FlightRecorderException {
        IQuantity duration = this.getSetting("timerange").getQuantity();
        try {
            RecordingOptionsBuilder b = new RecordingOptionsBuilder((IRecorderConfigurationService)service);
            b.duration(duration);
            Object name = this.getSetting("name").getString();
            if (++this.recordingNumber > 1) {
                name = (String)name + " " + this.recordingNumber;
            }
            b.name((String)name);
            MCFile path = IDESupportToolkit.createFileResource((String)this.getSetting("recordingfilename").getFileName());
            IRecordingDescriptor descriptor = service.start(b.build(), TriggerActionRecordingToolkit.getTemplate("Profiling", service));
            boolean open = this.getSetting("open").getBoolean();
            if (!descriptor.isContinuous()) {
                new WaitAndOpenJob(service, descriptor, event, path, open).schedule(duration.clampedLongValueIn((IUnit)UnitLookup.MILLISECOND));
            }
        }
        catch (QuantityConversionException e) {
            throw new FlightRecorderException(null, (Throwable)e);
        }
    }

    private File dumpFile(IProgressMonitor monitor, IFlightRecorderService service, IRecordingDescriptor descriptor, MCFile path) throws IOException, FlightRecorderException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = service.openStream(descriptor, false);){
            return IDESupportToolkit.writeToUniqueFile((MCFile)path, (InputStream)stream, (IProgressMonitor)monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void showAlert(File file, TriggerEvent event) {
        AlertObject ao = new AlertObject(event.getCreationTime(), event.getSource().getServerDescriptor().getDisplayName(), event.getRule(), NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.TriggerActionStartTimeBoundRecording_MESSAGE_RECORDING_SUCCESSFUL_PATH, (Object)file.getPath())), null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.supportsJfrAction(handle);
    }

    public boolean isActivatable(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.isActivatableJfrAction(handle);
    }

    private class WaitAndOpenJob
    extends Job {
        private final IFlightRecorderService m_service;
        private IRecordingDescriptor m_descriptor;
        private final MCFile m_path;
        private int m_updateErrorCount;
        private final boolean m_open;
        private final TriggerEvent m_event;

        public WaitAndOpenJob(IFlightRecorderService service, IRecordingDescriptor descriptor, TriggerEvent event, MCFile path, boolean open) {
            super(descriptor.getName());
            this.m_updateErrorCount = 0;
            this.m_service = service;
            this.m_descriptor = descriptor;
            this.m_event = event;
            this.m_path = path;
            this.m_open = open;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String triggerMessage;
            block8: {
                triggerMessage = NotificationToolkit.prettyPrint((TriggerEvent)this.m_event);
                try {
                    this.m_descriptor = this.m_service.getUpdatedRecordingDescription(this.m_descriptor);
                    this.m_updateErrorCount = 0;
                }
                catch (FlightRecorderException e) {
                    NotificationPlugin.getDefault().getLogger().severe("Problem updating a flight recording on the " + this.m_descriptor.getName() + " JVM");
                    if (++this.m_updateErrorCount <= 10) break block8;
                    return StatusFactory.createErr((String)NLS.bind((String)("\n" + triggerMessage + "\n" + Messages.TriggerActionStartTimeBoundRecording_UPDATE_STATUS_ERROR_MSG), (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
                }
            }
            if (this.m_descriptor.getState() != IRecordingDescriptor.RecordingState.STOPPED) {
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
            try {
                File writtenFile = TriggerActionStartTimeBoundRecording.this.dumpFile(monitor, this.m_service, this.m_descriptor, this.m_path);
                if (this.m_open) {
                    WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(writtenFile, false));
                } else {
                    TriggerActionStartTimeBoundRecording.this.showAlert(writtenFile, this.m_event);
                }
                return StatusFactory.createOk((String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)this.m_descriptor.getName()));
            }
            catch (FlightRecorderException e) {
                return StatusFactory.createErr((String)NLS.bind((String)("\n" + triggerMessage + "\n" + Messages.TriggerActionStartTimeBoundRecording_SERVICE_ERROR_MSG), (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
            catch (IOException e) {
                return StatusFactory.createErr((String)NLS.bind((String)("\n" + triggerMessage + "\n" + Messages.TriggerActionStartTimeBoundRecording_IO_ERROR_MSG), (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
        }
    }
}

