/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.labelingrules;

import java.util.HashMap;
import org.openjdk.jmc.common.labelingrules.NameConverter;
import org.openjdk.jmc.common.messages.internal.Messages;

final class Constants {
    private static final HashMap<String, Object> constants = new HashMap();
    private static final Constants instance = new Constants();

    static Constants getInstance() {
        return instance;
    }

    public Constants() {
        this.initDefaultConstants();
    }

    private void initDefaultConstants() {
        for (NameConverter.ValueArrayInfo info : NameConverter.ValueArrayInfo.values()) {
            this.setConstant(info.getValueName(), info.getMatchExpression());
        }
        this.setConstant("StrConstDebug", Messages.getString("NameConverter_DEBUG"));
        this.setConstant("StrConstJVMJRockit", Messages.getString("NameConverter_JVM_TYPE_JROCKIT"));
        this.setConstant("StrConstJVMZing", Messages.getString("NameConverter_JVM_TYPE_ZING"));
        this.setConstant("StrConstJVMUnknown", Messages.getString("NameConverter_JVM_TYPE_UNKNOWN"));
    }

    public void setConstant(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("You may not add a variable which has a value that is null!");
        }
        constants.put(key, value);
    }

    public Object getConstant(String key) {
        return constants.get(key);
    }

    public boolean containsConstant(String key) {
        return constants.containsKey(key);
    }
}

