/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.TypedUnit;

public abstract class QuantityRange<U extends TypedUnit<U>>
implements IRange<IQuantity> {
    protected final ITypedQuantity<U> start;

    private QuantityRange(ITypedQuantity<U> start) {
        this.start = start;
    }

    public static <U extends TypedUnit<U>> IRange<IQuantity> createPoint(IQuantity start) {
        ITypedQuantity typedStart = (ITypedQuantity)start;
        return new Point(typedStart);
    }

    public static <U extends TypedUnit<U>> IRange<IQuantity> createWithEnd(IQuantity start, IQuantity end) {
        if (start.getType() != end.getType()) {
            throw new IllegalArgumentException(start.persistableString() + " and " + end.persistableString() + " needs to be of the same kind");
        }
        ITypedQuantity typedStart = (ITypedQuantity)start;
        ITypedQuantity typedEnd = (ITypedQuantity)end;
        return new WithEnd(typedStart, typedEnd);
    }

    public static <U extends TypedUnit<U>> IRange<IQuantity> createWithExtent(IQuantity start, ITypedQuantity<LinearUnit> extent) {
        ITypedQuantity typedStart = (ITypedQuantity)start;
        if (typedStart.getUnit().getDeltaUnit().getContentType() != extent.getType()) {
            throw new IllegalArgumentException(start.persistableString() + " and " + extent.persistableString() + " needs to be of compatible kinds");
        }
        return new WithExtent(typedStart, extent);
    }

    public static IDisplayable createInfinite(final IQuantity start, final IQuantity end) {
        if (start != null) {
            if (end != null) {
                return QuantityRange.createWithEnd(start, end);
            }
            return new IDisplayable(){

                @Override
                public String displayUsing(String formatHint) {
                    return start.displayUsing(formatHint) + " \u2013 \u221e";
                }
            };
        }
        if (end != null) {
            return new IDisplayable(){

                @Override
                public String displayUsing(String formatHint) {
                    return " -\u221e \u2013" + end.displayUsing(formatHint);
                }
            };
        }
        return new IDisplayable(){

            @Override
            public String displayUsing(String formatHint) {
                return " -\u221e \u2013 \u221e";
            }
        };
    }

    public static IRange<IQuantity> intersection(IRange<IQuantity> a, IRange<IQuantity> b) {
        IQuantity maxStart = a.getStart().compareTo(b.getStart()) > 0 ? a.getStart() : b.getStart();
        IQuantity minEnd = a.getEnd().compareTo(b.getEnd()) > 0 ? b.getEnd() : a.getEnd();
        return minEnd.compareTo(maxStart) >= 0 ? QuantityRange.createWithEnd(maxStart, minEnd) : null;
    }

    public static IRange<IQuantity> union(IRange<IQuantity> a, IRange<IQuantity> b) {
        IQuantity maxEnd;
        IQuantity minEnd;
        IQuantity maxStart;
        IQuantity minStart;
        if (a.getStart().compareTo(b.getStart()) < 0) {
            minStart = a.getStart();
            maxStart = b.getStart();
        } else {
            minStart = b.getStart();
            maxStart = a.getStart();
        }
        if (a.getEnd().compareTo(b.getEnd()) < 0) {
            minEnd = a.getEnd();
            maxEnd = b.getEnd();
        } else {
            minEnd = b.getEnd();
            maxEnd = a.getEnd();
        }
        if (minEnd.compareTo(maxStart) < 0) {
            return null;
        }
        return QuantityRange.createWithEnd(minStart, maxEnd);
    }

    @Override
    public ITypedQuantity<U> getStart() {
        return this.start;
    }

    @Override
    public abstract ITypedQuantity<U> getEnd();

    @Override
    public String displayUsing(String formatHint) {
        return ((KindOfQuantity)this.start.getType()).getRangeFormatter(formatHint).format(this);
    }

    private static class Point<U extends TypedUnit<U>>
    extends QuantityRange<U> {
        private Point(ITypedQuantity<U> start) {
            super(start);
        }

        @Override
        public ITypedQuantity<U> getEnd() {
            return this.start;
        }

        @Override
        public IQuantity getCenter() {
            return this.start;
        }

        @Override
        public IQuantity getExtent() {
            return this.start.getUnit().getDeltaUnit().quantity(0L);
        }

        @Override
        public boolean isPoint() {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof Point && this.start.equals(((Point)obj).start);
        }

        public int hashCode() {
            return this.start.hashCode();
        }
    }

    private static class WithEnd<U extends TypedUnit<U>>
    extends QuantityRange<U> {
        private final ITypedQuantity<U> end;

        private WithEnd(ITypedQuantity<U> start, ITypedQuantity<U> end) {
            super(start);
            this.end = end;
        }

        @Override
        public ITypedQuantity<U> getEnd() {
            return this.end;
        }

        @Override
        public IQuantity getCenter() {
            return this.start.add((ITypedQuantity<LinearUnit>)this.end.subtract(this.start).multiply(0.5));
        }

        @Override
        public ITypedQuantity<LinearUnit> getExtent() {
            return this.end.subtract(this.start);
        }

        @Override
        public boolean isPoint() {
            return this.start.compareTo(this.end) == 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WithEnd) {
                WithEnd other = (WithEnd)obj;
                return this.start.equals(other.start) && this.end.equals(other.end);
            }
            return false;
        }

        public int hashCode() {
            return this.start.hashCode() + this.end.hashCode();
        }
    }

    private static class WithExtent<U extends TypedUnit<U>>
    extends QuantityRange<U> {
        private final ITypedQuantity<LinearUnit> extent;

        private WithExtent(ITypedQuantity<U> start, ITypedQuantity<LinearUnit> extent) {
            super(start);
            this.extent = extent;
        }

        @Override
        public ITypedQuantity<U> getEnd() {
            return this.start.add(this.extent);
        }

        @Override
        public IQuantity getCenter() {
            return this.start.add((ITypedQuantity<LinearUnit>)this.extent.multiply(0.5));
        }

        @Override
        public ITypedQuantity<LinearUnit> getExtent() {
            return this.extent;
        }

        @Override
        public boolean isPoint() {
            return this.extent.doubleValue() == 0.0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WithExtent) {
                WithExtent other = (WithExtent)obj;
                return this.start.equals(other.start) && this.extent.equals(other.extent);
            }
            return false;
        }

        public int hashCode() {
            return this.start.hashCode() + this.extent.hashCode();
        }
    }
}

