/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui;

import java.util.stream.Stream;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.openjdk.jmc.joverflow.ui.JOverflowEditor;
import org.openjdk.jmc.joverflow.ui.JOverflowUi;
import org.openjdk.jmc.joverflow.ui.Messages;
import org.openjdk.jmc.joverflow.ui.TreemapAction;
import org.openjdk.jmc.joverflow.ui.TreemapPage;

public class TreemapPageBookView
extends PageBookView {
    private TreemapAction[] treemapActions;

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(Messages.TreemapPageBookView_NO_JOVERFLOW_EDITOR_SELECTED);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (!(part instanceof JOverflowEditor)) {
            return null;
        }
        JOverflowEditor editor = (JOverflowEditor)part;
        TreemapPage page = new TreemapPage(editor, this.treemapActions);
        editor.addUiLoadedListener(ui -> ui.addModelListener(page));
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        JOverflowUi ui;
        if (part instanceof JOverflowEditor && (ui = ((JOverflowEditor)part).getJOverflowUi()) != null) {
            ui.removeModelListener((TreemapPage)pageRecord.page);
        }
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof JOverflowEditor;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.treemapActions = new TreemapAction[]{new TreemapAction(TreemapAction.TreemapActionType.ZOOM_IN), new TreemapAction(TreemapAction.TreemapActionType.ZOOM_OUT), new TreemapAction(TreemapAction.TreemapActionType.ZOOM_RESET)};
        Stream.of(this.treemapActions).forEach(action -> action.setEnabled(false));
        IToolBarManager toolBar = site.getActionBars().getToolBarManager();
        Stream.of(this.treemapActions).forEach(arg_0 -> ((IToolBarManager)toolBar).add(arg_0));
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        if (pageRec.page instanceof TreemapPage) {
            ((TreemapPage)pageRec.page).bindTreemapActions();
        } else {
            Stream.of(this.treemapActions).forEach(action -> action.setEnabled(false));
        }
    }
}

