/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.actions;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.flightrecorder.configuration.FlightRecorderException;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.DumpRecordingWizardModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.DumpRecordingWizardPage;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.ui.wizards.AbstractWizardUserAction;
import org.openjdk.jmc.ui.wizards.OnePageWizard;

public class DumpAnyRecordingAction
extends AbstractWizardUserAction {
    private final FlightRecorderProvider flightRecorder;

    public DumpAnyRecordingAction(FlightRecorderProvider flightRecorderProvider) {
        super(Messages.ACTION_DUMP_ANY_RECORDING_LABEL, Messages.ACTION_DUMP_ANY_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_dump.png"));
        this.flightRecorder = flightRecorderProvider;
    }

    public IWizard doCreateWizard() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (IConnectionHandle handle = this.flightRecorder.getServerHandle().connect(Messages.ACTION_DUMP_ANY_RECORDING_LABEL);){
                RecordingProvider recording = this.flightRecorder.getSnapshotRecording(handle);
                if (recording != null) {
                    this.flightRecorder.resetWarning();
                    return new OnePageWizard((IWizardPage)new DumpRecordingWizardPage(new DumpRecordingWizardModel(recording)));
                }
                throw new FlightRecorderException(NLS.bind((String)Messages.DUMP_ANY_RECORDING_ERROR_MSG, (Object)this.flightRecorder.getServerHandle().getServerDescriptor().getDisplayName()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.flightRecorder.setWarning(e.getLocalizedMessage());
            throw e;
        }
    }
}

